package junkutil.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

import junkutil.common.StringUtil;

/**
 * ListW_IɈB
 * @author Hiroyuki Shiota
 */
public class LzList {
	private java.util.List base;

	/**
	 * RXgN^
	 */
	public LzList() {
		base = new ArrayList();
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(List list) {
		base = list;
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(Object[] args) {
		base = Arrays.asList(args);
	}
	/**
	 * RXgN^
	 * @param list
	 */
	public LzList(Set set) {
		base = Arrays.asList(set.toArray());
	}

	/**
	 * RXgN^
	 * @param e
	 */
	public LzList(Enumeration e) {
		base = asList(e);
	}

	/**
	 * RXgN^
	 * @param i
	 */
	public LzList(Iterator i) {
		base = asList(i);
	}

	/**
	 * Xg擾B
	 * @return
	 */
	public List list() {
		return base;
	}

	/**
	 * or擾B
	 * @param arg
	 * @return
	 */
	public LzList or(List arg) {
		List list = new ArrayList(base);
		for (int i = 0; i < arg.size(); i++) {
			Object obj = arg.get(i);
			if (!base.contains(obj)) list.add(obj);
		}
		return new LzList(list);
	}

	/**
	 * and擾B
	 * @param arg
	 * @return
	 */
	public LzList and(List arg) {
		List list = new ArrayList();
		for (int i = 0; i < arg.size(); i++) {
			Object obj = arg.get(i);
			if (base.contains(obj)) list.add(obj);
		}
		return new LzList(list);
	}

	/**
	 * nullȊO擾B
	 * @param arg
	 * @return
	 */
	public LzList notNull() {
		List list = new ArrayList();
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (obj != null) list.add(obj);
		}
		return new LzList(list);
	}

	/**
	 * ComparatorBnullΉς݁Bnull͍ŌɗB
	 */
	private static Comparator compStrAsc = new Comparator() {
		public int compare(Object o1, Object o2) {
			if (o1 == null && o2 == null) {
				return 0;
			} else if (o1 == null) {
				return 1;
			} else if (o2 == null) {
				return -1;
			} else {
				return o1.toString().compareTo(o2.toString());
			}
		}
	};

	/**
	 * tComparatorBnullΉς݁Bnull͍ŌɗB
	 */
	private static Comparator compStrDesc = new Comparator() {
		public int compare(Object o1, Object o2) {
			if (o1 == null && o2 == null) {
				return 0;
			} else if (o1 == null) {
				return 1;
			} else if (o2 == null) {
				return -11;
			} else {
				return -(o1.toString().compareTo(o2.toString()));
			}
		}
	};

	/**
	 * Ń\[gB
	 * @return
	 */
	public LzList sortAsc() {
		return sort(compStrAsc);
	}

	/**
	 * ~Ń\[gB
	 * @return
	 */
	public LzList sortDesc() {
		return sort(compStrDesc);
	}

	/**
	 * w菇Ń\[gB
	 * @return
	 */
	public LzList sort(Comparator c) {
		List list = new ArrayList(base);
		Collections.sort(list, c);
		return new LzList(list);
	}

	/**
	 * i荞݂sBnull͏OB
	 * @param re
	 * @return
	 */
	public LzList grep(String re) {
		List list = new ArrayList();
		Pattern pattern = Pattern.compile(re);
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (obj == null) continue;
			if (StringUtil.match(obj.toString(), pattern)) {
				list.add(obj);
			}
		}
		return new LzList(list);
	}

	/**
	 * ti荞݂sBnull͏OB
	 * @param re
	 * @return
	 */
	public LzList ungrep(String re) {
		List list = new ArrayList();
		Pattern pattern = Pattern.compile(re);
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (obj == null) continue;
			if (!StringUtil.match(obj.toString(), pattern)) {
				list.add(obj);
			}
		}
		return new LzList(list);
	}

	/**
	 * XgB
	 * @param arg
	 * @return
	 */
	public LzList join(Collection arg) {
		List list = new ArrayList(base);
		list.addAll(arg);
		return new LzList(list);
	}

	/**
	 * j[NȃXg擾B
	 * @param arg
	 * @return
	 */
	public LzList uniq() {
		List list = new ArrayList();
		for (int i = 0; i < base.size(); i++) {
			Object obj = base.get(i);
			if (!list.contains(obj)) list.add(obj);
		}
		return new LzList(list);
	}

	/**
	 * ]Xg擾B
	 * @return
	 */
	public LzList reverse() {
		List list = new ArrayList();
		int len = base.size();
		for (int i = len-1; i >= 0; i--) {
			list.add(base.get(i));
		}
		return new LzList(list);
	}

	/**
	 * N[WɌĂяoB
	 * @param closure
	 * @return
	 */
	public LzList forEach(LzListClosure closure) {
		List list = new ArrayList();
		int len = base.size();
		for (int i = 0; i < len; i++) {
			Object obj = base.get(i);
			if (closure.process(i, len, obj)) {
				list.add(obj);
			}
		}
		return new LzList(list);
	}

	/**
	 * ǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equals(List arg) {
		if (base == arg) return true;
		if (base.size() != arg.size()) return false;
		for (int i = 0; i < base.size(); i++) {
			Object obj1 = base.get(i);
			Object obj2 = arg.get(i);
			if (obj1 == null && obj2 == null) {
			} else {
				if (obj1 == null || obj2 == null) return false;
				if (!obj1.equals(obj2)) return false;
			}
		}
		return true;
	}

	/**
	 * 𑵂ƁAǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equalsOnSort(List arg) {
		if (base.size() != arg.size()) return false;
		LzList sortedBase = new LzList(base).sortAsc();
		List sortedArg = new LzList(arg).sortAsc().list();
		return sortedBase.equals(sortedArg);
	}

	/**
	 * ǂeXgB
	 * @param arg
	 * @return
	 */
	public boolean equals(String arg) {
		return toString().equals(arg);
	}

	/**
	 * 񉻂B
	 * @Override
	 */
	public String toString() {
		return base.toString();
	}

	/**
	 * EnumerationListɂB
	 * @param e
	 * @return
	 */
	public static List asList(Enumeration e) {
		List result = new ArrayList();
		while (e.hasMoreElements()) {
			result.add(e.nextElement());
		}
		return result;
	}

	/**
	 * IteratorListɂB
	 * @param i
	 * @return
	 */
	public static List asList(Iterator i) {
		List result = new ArrayList();
		while (i.hasNext()) {
			result.add(i.next());
		}
		return result;
	}

}
