package junkutil.crypt;

import java.io.FileInputStream;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.common.DataDumper;
import junkutil.crypt.MD5;

/**
 * MD5B
 * @author Hiroyuki Shiota
 */
public class MD5Test extends TestCase {
	private String md5Hash = "81dc9bdb52d04dc20036dbd8313ed055";
	private String md5SjisHash = "ad7cf5ce5313f8b3fc59d626b9aad653";
	private String sha1Hash = "7110eda4d09e062aa5e4a390b0a572ac0d2c0220";
	private String sha1SjisHash = "2c332e42c55ba9293827672e85f16f1cda65518e";

	/**
	 * RXgN^
	 * @param name
	 */
	public MD5Test(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("MD5Test");
		test.addTest(new TestSuite(MD5Test.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testCryptString() throws Exception {
		MD5 md5 = new MD5();
		assertTrue(md5.crypt("1234").equals(md5Hash));

		MD5 sha1 = new MD5(MD5.SHA_1);
		assertTrue(sha1.crypt("1234").equals(sha1Hash));

		assertTrue(md5.crypt("", "Shift_JIS").equals(md5SjisHash));

		assertTrue(sha1.crypt("", "Shift_JIS").equals(sha1SjisHash));
	}

	/**
	 * @throws Exception
	 */
	public void testCryptFile() throws Exception {
		MD5 md5 = new MD5();
		FileInputStream in = null;
		try {
			in = new FileInputStream("testdata/crypt.txt");
			assertTrue(md5.crypt(in, 4096).equals(md5Hash));
		} finally {
			if (in != null) in.close();
		}

		MD5 sha1 = new MD5(MD5.SHA_1);
		FileInputStream in2 = null;
		try {
			in2 = new FileInputStream("testdata/crypt.txt");
			assertTrue(sha1.crypt(in2, 4096).equals(sha1Hash));
		} finally {
			if (in2 != null) in.close();
		}
	}

	/**
	 * @throws Exception
	 */
	public void testAsByteArray() throws Exception {
		byte[] byteArray = MD5.asByteArray(new MD5().crypt("1234"));
		DataDumper.dumpByteArray(System.out, byteArray);
		assertTrue(true);
	}

}
