package junkutil.gui;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.AbstractAction;

/**
 * R[obN֐
 * @author Hiroyuki Shiota
 */
public class LzCallback {

	private Object obj;
	private Method method;
	private boolean arg = false;
	
	/**
	 * R[obN֐̐
	 * @param obj - this
	 * @param methodName - "callback1"
	 */
	public LzCallback(Object obj, String methodName) {
		this.obj = obj;
		try {
			method = obj.getClass().getMethod(methodName, new Class[]{ActionEvent.class});
			arg = true;
		} catch (SecurityException e) {
			throw new RuntimeException(e);
		} catch (NoSuchMethodException e) {
			try {
				method = obj.getClass().getMethod(methodName, new Class[]{});
				arg = false;
			} catch (SecurityException e2) {
				throw new RuntimeException(e2);
			} catch (NoSuchMethodException e2) {
				throw new RuntimeException(e2);
			}
		}
	}
	
	/**
	 * R[obNs
	 * @param a
	 */
	public void call(ActionEvent a) {
		try {
			if (arg) {
				method.invoke(obj, new Object[]{a});
			} else {
				method.invoke(obj, new Object[]{});
			}
		} catch (IllegalArgumentException e) {
			throw new RuntimeException(e);
		} catch (IllegalAccessException e) {
			throw new RuntimeException(e);
		} catch (InvocationTargetException e) {
			throw new RuntimeException(e);
		}
	}
	
	/**
	 * R[obNɊւR[h
	 */
	public class LCallbackAction extends AbstractAction {
		private LzCallback callback;
		public LCallbackAction(LzCallback callback) {
			this.callback = callback;
		}
		public void actionPerformed(ActionEvent e) {
			callback.call(e);
		}
	}
	
	/**
	 * R[obNANV擾
	 * @return
	 */
	public LCallbackAction getCallbackAction() {
		return new LCallbackAction(this);
	}
}
