package junkutil.common;

import java.util.Calendar;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * ݒt@C̓ǂݍ݂eXgB
 * @author Hiroyuki Shiota
 */
public class DateUtilTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public DateUtilTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("DateUtilTest");
		test.addTest(new TestSuite(DateUtilTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testDiffString() throws Exception {
		Calendar timeCal = Calendar.getInstance();

		String timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("0bO"));

		timeCal.add(Calendar.SECOND, -30);
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("30bO"));

		timeCal.add(Calendar.MINUTE, -15);
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("15O"));

		timeCal.add(Calendar.HOUR, -3);
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("3ԑO"));

		Calendar testCal = Calendar.getInstance();
		timeCal.set(testCal.get(Calendar.YEAR), testCal.get(Calendar.MONTH), testCal.get(Calendar.DAY_OF_MONTH)-8);
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("8O"));

		timeCal.set(testCal.get(Calendar.YEAR), testCal.get(Calendar.MONTH)-1, testCal.get(Calendar.DAY_OF_MONTH));
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("1O"));

		timeCal.set(testCal.get(Calendar.YEAR), testCal.get(Calendar.MONTH)-3, testCal.get(Calendar.DAY_OF_MONTH));
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("3O"));

		timeCal.set(testCal.get(Calendar.YEAR)-1, testCal.get(Calendar.MONTH), testCal.get(Calendar.DAY_OF_MONTH));
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("1NO"));

		timeCal.set(testCal.get(Calendar.YEAR)-2, testCal.get(Calendar.MONTH), testCal.get(Calendar.DAY_OF_MONTH));
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("2NO"));

		timeCal.set(testCal.get(Calendar.YEAR)-3, testCal.get(Calendar.MONTH), testCal.get(Calendar.DAY_OF_MONTH));
		timeString = DateUtil.dateDiff(timeCal.getTime());
		assertTrue(timeString.equals("3NO"));
	}

}
