/*
 * Decompiled with CFR 0.152.
 */
package junkutil.gui;

import java.awt.event.ActionEvent;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import junkutil.common.StringUtil;
import junkutil.gui.LzCallback;

public class LzMenu {
    private JMenuBar menuBar = new JMenuBar();
    private Map menuMap = new HashMap();

    public void addMenu(String menuPath) {
        this.addMenu(menuPath, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
            }
        });
    }

    public void addMenu(String menuPath, LzCallback callback) {
        this.addMenu(menuPath, callback.getCallbackAction());
    }

    public void addMenu(String menuPath, Action action) {
        String[] menus = StringUtil.split(menuPath, "/");
        StringBuffer sb = new StringBuffer();
        String parentPath = "";
        String path = "";
        String item = menus[menus.length - 1];
        action.putValue("Name", item);
        for (int i = 0; i < menus.length - 1; ++i) {
            JMenu menu = new JMenu(menus[i]);
            parentPath = new String(sb);
            if (i != 0) {
                sb.append("/");
            }
            sb.append(menus[i]);
            path = new String(sb);
            if (this.menuMap.containsKey(path)) continue;
            this.menuMap.put(path, menu);
            this.setupMenuItem(path, menu);
            if (parentPath.length() == 0) {
                this.menuBar.add(menu);
                continue;
            }
            this.getMenu(parentPath).add(menu);
        }
        if (item.startsWith("-")) {
            if (path.length() != 0) {
                this.getMenu(path).add(new JSeparator());
            }
        } else {
            JMenuItem menuItem = new JMenuItem(action);
            if (!this.menuMap.containsKey(menuPath)) {
                this.menuMap.put(menuPath, menuItem);
                this.setupMenuItem(menuPath, menuItem);
                if (path.length() == 0) {
                    this.menuBar.add(menuItem);
                } else {
                    this.getMenu(path).add(menuItem);
                }
            }
        }
    }

    private void setupMenuItem(String menuPath, JMenuItem menuItem) {
        String accelStr;
        String text;
        String value = menuItem.getText();
        char mnemonic = ' ';
        int idx = value.indexOf(44);
        if (idx != -1) {
            text = value.substring(0, idx).trim();
            accelStr = value.substring(idx + 1).trim();
        } else {
            text = value.trim();
            accelStr = null;
        }
        int aIdx = text.indexOf(40) + 1;
        if (aIdx == -1) {
            return;
        }
        if (aIdx < text.length()) {
            mnemonic = text.charAt(aIdx);
        }
        menuItem.setText(text);
        if (mnemonic != ' ') {
            menuItem.setMnemonic(mnemonic);
        }
        if (accelStr != null && accelStr.indexOf(43) != -1) {
            String[] accelList = StringUtil.split(accelStr, "+");
            int mask = 0;
            for (int i = 0; i < accelList.length; ++i) {
                String accel = accelList[i].toLowerCase();
                if (accel.equals("ctrl")) {
                    mask += 128;
                }
                if (accel.equals("shift")) {
                    mask += 64;
                }
                if (!accel.equals("alt")) continue;
                mask += 512;
            }
            char keyChar = accelList[accelList.length - 1].toUpperCase().charAt(0);
            int keyCode = 0;
            if ('0' <= keyChar && keyChar <= '9') {
                keyCode = 48 + (keyChar - 48);
            } else if ('A' <= keyChar && keyChar <= 'Z') {
                keyCode = 65 + (keyChar - 65);
            } else {
                throw new UnsupportedCharsetException(accelStr);
            }
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode, mask));
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public JMenu getMenu(String path) {
        return (JMenu)this.menuMap.get(path);
    }

    public JMenuItem getMenuItem(String path) {
        return (JMenuItem)this.menuMap.get(path);
    }
}

