package junkutil.crypt;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * MD5B
 * @author Hiroyuki Shiota
 */
public class DESTest extends TestCase {
	private String key = "Bzj0bsgyyGv76i+YIM5r70qK/eOSnlS5";
	private String crypt = "qID0i3tzYRlQgogSOW/gSbMEt9yU47aBsuMRQVXGSEw=";

	/**
	 * RXgN^
	 * @param name
	 */
	public DESTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("DESTest");
		test.addTest(new TestSuite(DESTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testCrypt() throws Exception {
		DES des = new DES(DES.DESEDE_ALGORITHM);
		String key = des.createKey("test");
		assertTrue(key.indexOf(this.key) == 0);
		
		String data = "testeXg`";
		
		byte[] encryptBytes = des.encrypt(data.getBytes("UTF-8"), key);
		assertTrue(DES.encodeBASE64(encryptBytes).indexOf(crypt)  == 0);

		byte[] decryptBytes = des.decrypt(encryptBytes, key);
		assertTrue(new String(decryptBytes, "UTF-8").equals(data));
		//DataDumper.dumpByteArray(System.out, decryptBytes);
	}
	
}
