/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private StringUtil() {
    }

    public static String replaceFirst(String target, String search, String replacement) {
        int pos = target.indexOf(search);
        return pos == -1 ? target : target.substring(0, pos) + replacement + target.substring(pos + search.length());
    }

    public static String replaceAll(String target, String strOld, String strNew) {
        if (target.indexOf(strOld) == -1) {
            return target;
        }
        int pos = 0;
        String strTemp = target;
        while ((pos = strTemp.indexOf(strOld, pos)) != -1) {
            strTemp = strTemp.substring(0, pos) + strNew + strTemp.substring(pos + strOld.length());
            pos += strOld.length();
        }
        return strTemp;
    }

    public static String join(String[] args, String delim) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(args[i]);
        }
        return new String(sb);
    }

    public static String[] split(String args, String delim) {
        if (args.indexOf(delim) == -1) {
            return new String[]{args};
        }
        ArrayList<String> list = null;
        int idx = 0;
        int pos = 0;
        String strTemp = args;
        while (true) {
            if ((idx = strTemp.indexOf(delim, pos)) == -1) {
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(args.substring(pos));
                String[] retStrs = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    retStrs[i] = (String)list.get(i);
                }
                return retStrs;
            }
            if (list == null) {
                list = new ArrayList();
            }
            list.add(args.substring(pos, idx));
            pos = idx + delim.length();
        }
    }

    public static String trimLeft(String str) {
        int len = str.length();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == ' ') continue;
            index = i;
            break;
        }
        return str.substring(index, len);
    }

    public static String trimRight(String str) {
        int len = str.length();
        int index = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (c == ' ') continue;
            index = i + 1;
            break;
        }
        return str.substring(0, index);
    }

    public static String padLeft(String str, int len) {
        return StringUtil.padLeft(str, len, ' ');
    }

    public static String padLeft(String str, int len, char pad) {
        int padding_len = len - str.length();
        if (padding_len > 0) {
            return StringUtil.repeat(pad, padding_len) + str;
        }
        return str;
    }

    public static String padRight(String str, int len) {
        return StringUtil.padRight(str, len, ' ');
    }

    public static String padRight(String str, int len, char pad) {
        int padding_len = len - str.length();
        if (padding_len > 0) {
            return str + StringUtil.repeat(pad, padding_len);
        }
        return str;
    }

    public static String wrapBracket(String str, String both) {
        return both + str + both;
    }

    public static String wrapBracket(String str, String left, String right) {
        return left + str + right;
    }

    public static String unwrapBracket(String str, String both) {
        String result = str;
        if (!result.startsWith(both)) {
            return str;
        }
        result = result.substring(both.length(), result.length());
        if (!result.endsWith(both)) {
            return str;
        }
        result = result.substring(0, result.length() - both.length());
        return result;
    }

    public static String unwrapBracket(String str, String left, String right) {
        String result = str;
        if (!result.startsWith(left)) {
            return str;
        }
        result = result.substring(left.length(), result.length());
        if (!result.endsWith(right)) {
            return str;
        }
        result = result.substring(0, result.length() - right.length());
        return result;
    }

    public static String tabToSpace(String str, int spaceLen) {
        return str.replaceAll("\t", StringUtil.repeat(' ', spaceLen));
    }

    public static String spaceToTab(String str, int spaceLen) {
        return str.replaceAll(StringUtil.repeat(' ', spaceLen), "\t");
    }

    public static String getRepeatedSpaces(int len) {
        return StringUtil.repeat(' ', len);
    }

    public static String getRepeatedChars(String s, int len) {
        if (s.length() != 1) {
            throw new IllegalArgumentException(s);
        }
        return StringUtil.repeat(s.charAt(0), len);
    }

    public static String repeat(char c, int len) {
        StringBuffer buff = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            buff.append(c);
        }
        return new String(buff);
    }

    public static String getRepeatedChars(char c, int len) {
        return StringUtil.repeat(c, len);
    }

    public static void clearRepeatedCharsCash() {
    }

    public static boolean fuzzyEquals(String str1, String str2, int err) {
        if (err < 0) {
            throw new IllegalArgumentException();
        }
        if (str1.equals(str2)) {
            return true;
        }
        if (Math.abs(str1.length() - str2.length()) > err) {
            return false;
        }
        int noise = StringUtil.noiseCount(str1, str2, err, 0);
        return noise <= err;
    }

    private static int noiseCount(String str1, String str2, int err, int noise) {
        int heads;
        int maxlen = Math.max(str1.length(), str2.length());
        if (maxlen == (heads = StringUtil.equalHeads(str1, str2))) {
            return noise;
        }
        str1 = str1.substring(heads);
        str2 = str2.substring(heads);
        if (str1.length() == 0) {
            return noise + str2.length();
        }
        if (str2.length() == 0) {
            return noise + str1.length();
        }
        int minErr = maxlen;
        int retErr = 0;
        for (int i = -Math.min(err, str1.length()); i <= Math.min(err, str2.length()); ++i) {
            String tempstr;
            if (i == 0) continue;
            int slide = Math.abs(i);
            if (i < 0) {
                if (noise + slide > err) continue;
                tempstr = str1.substring(slide);
                retErr = StringUtil.noiseCount(tempstr, str2, err, slide);
            } else {
                if (noise + slide > err) continue;
                tempstr = str2.substring(slide);
                retErr = StringUtil.noiseCount(str1, tempstr, err, slide);
            }
            if (retErr >= minErr) continue;
            minErr = retErr;
        }
        return noise + minErr;
    }

    private static int equalHeads(String str1, String str2) {
        int minlen = str1.length() < str2.length() ? str1.length() : str2.length();
        for (int i = 0; i < minlen; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            return i + 1;
        }
        return minlen;
    }

    public static String toString(String[] args) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]);
            if (args.length == i + 1) {
                buf.append("]");
                continue;
            }
            buf.append(", ");
        }
        return new String(buf);
    }

    public static boolean equals(String[] arg1, String[] arg2) {
        if (arg1 == null) {
            return arg2 == null;
        }
        if (arg2 == null) {
            return false;
        }
        if (arg1.length != arg2.length) {
            return false;
        }
        for (int i = 0; i < arg1.length; ++i) {
            if (arg1[i] == null && arg2[i] != null) {
                return false;
            }
            if (arg1[i] != null && arg2[i] == null) {
                return false;
            }
            if (arg1[i].equals(arg2[i])) continue;
            return false;
        }
        return true;
    }

    public static String urlEncode(String str) {
        return StringUtil.encodeURL(str, "utf-8");
    }

    public static String urlEncode(String str, String encoding) {
        return StringUtil.encodeURL(str, encoding);
    }

    public static String urlDecode(String str) {
        return StringUtil.decodeURL(str, "utf-8");
    }

    public static String urlDecode(String str, String encoding) {
        return StringUtil.decodeURL(str, encoding);
    }

    public static String encodeURL(String str) {
        return StringUtil.encodeURL(str, "utf-8");
    }

    public static String encodeURL(String str, String encoding) {
        try {
            return URLEncoder.encode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String decodeURL(String str) {
        return StringUtil.decodeURL(str, "utf-8");
    }

    public static String decodeURL(String str, String encoding) {
        try {
            if (encoding == null) {
                encoding = "utf-8";
            }
            return URLDecoder.decode(str, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String escapeHtml(String str) {
        str = StringUtil.replaceAll(str, "&", "&amp;");
        str = StringUtil.replaceAll(str, "<", "&lt;");
        str = StringUtil.replaceAll(str, ">", "&gt;");
        str = StringUtil.replaceAll(str, "\"", "&quot;");
        str = StringUtil.replaceAll(str, "'", "&#39;");
        return str;
    }

    public static String unescapeHtml(String str) {
        str = StringUtil.replaceAll(str, "&lt;", "<");
        str = StringUtil.replaceAll(str, "&gt;", ">");
        str = StringUtil.replaceAll(str, "&quot;", "\"");
        str = StringUtil.replaceAll(str, "&#39;", "'");
        str = StringUtil.replaceAll(str, "&amp;", "&");
        return str;
    }

    public static boolean match(String str, Pattern pattern) {
        Matcher match = pattern.matcher(str);
        return match.find();
    }

    public static boolean match(String str, String re) {
        Pattern pattern = Pattern.compile(re);
        Matcher match = pattern.matcher(str);
        return match.find();
    }
}

