/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.common.constants;

import org.stormcat.jvbeans.common.constants.SingleValueEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileExtension implements SingleValueEnum<String>
{
    TXT("txt"),
    CSV("csv"),
    TSV("tsv");

    private String extension;
    private String regularExpression;

    private FileExtension(String extension) {
        this.extension = extension;
        this.regularExpression = String.format("^.*\\.(%s|%s)$", extension.toUpperCase(), extension);
    }

    @Override
    public String getValue() {
        return this.extension;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public boolean matchesExtension(String target) {
        if (target == null) {
            return false;
        }
        return target.matches(this.regularExpression);
    }
}

