/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.common.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.stormcat.jvbeans.common.exception.ClassNotFoundRuntimeException;
import org.stormcat.jvbeans.common.exception.IllegalAccessRuntimeException;
import org.stormcat.jvbeans.common.exception.InstantiationRuntimeException;
import org.stormcat.jvbeans.common.exception.InvocationTargetRuntimeException;
import org.stormcat.jvbeans.common.exception.NoSuchMethodRuntimeException;
import org.stormcat.jvbeans.common.lang.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    protected ClassUtil() {
    }

    public static Class<?> forName(String fqdn) {
        if (StringUtil.isBlank((String)fqdn)) {
            return null;
        }
        try {
            return Class.forName(fqdn);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> target, Class<?> ... parameterTypes) {
        try {
            return target.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> target) {
        return ClassUtil.getConstructor(target, new Class[0]);
    }

    public static <T> T newInstance(Class<T> target, Object ... parameters) {
        Constructor<T> constructor = ClassUtil.getConstructor(target, ClassUtil.convertTypeArray(parameters));
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> target) {
        return ClassUtil.newInstance(target, new Object[0]);
    }

    private static Class<?>[] convertTypeArray(Object[] parameters) {
        Class[] classArray = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            classArray[i] = parameters[i].getClass();
            ++i;
        }
        return classArray;
    }

    public static String getPackageName(String fqdn) {
        return fqdn.substring(0, fqdn.lastIndexOf("."));
    }

    public static String getClassName(String fqdn) {
        return fqdn.substring(fqdn.lastIndexOf(".") + 1, fqdn.length());
    }
}

