/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink;

import java.util.Iterator;
import org.stormcat.jvbeans.common.lang.ThreadUtil;
import org.stormcat.jvbeans.config.condition.OpenCondition;
import org.stormcat.jvbeans.config.condition.StoredOpenCondition;
import org.stormcat.jvbeans.exception.JvBeansRuntimeException;
import org.stormcat.jvbeans.jvlink.JvBindingDto;
import org.stormcat.jvbeans.jvlink.JvLinkExceptionHandler;
import org.stormcat.jvbeans.jvlink.JvLinkManagerImpl;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.response.JvContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvDataIterator<T extends JvBindingDto>
implements Iterator<JvContents<T>> {
    private JvLinkManagerImpl jvLinkManager;
    private OpenCondition<T> openCondition;
    private int returnCode = -1;

    public JvDataIterator(JvLinkManagerImpl jvLinkManager, OpenCondition<T> openCondition) {
        this.jvLinkManager = jvLinkManager;
        this.openCondition = openCondition;
    }

    @Override
    public boolean hasNext() {
        if (this.returnCode < -1) {
            throw new JvBeansRuntimeException(String.format("\u30c7\u30fc\u30bf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002: return code = %d", this.returnCode));
        }
        return this.returnCode != 0;
    }

    @Override
    public JvContents<T> next() {
        JvContents<T> contents = this.readLine();
        this.returnCode = contents.getReturnCode();
        return contents;
    }

    @Override
    public void remove() {
        JvContents<T> jvContents = this.readLine();
        this.returnCode = jvContents.getReturnCode();
    }

    private JvContents<T> readLine() {
        if (this.openCondition == null) {
            throw new JvBeansRuntimeException("JVOpen\u304c\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        return this.readContents(this.openCondition);
    }

    private JvContents<T> readContents(OpenCondition<? extends JvBindingDto> condition) {
        JvContents<T> contents = null;
        JvBeansContainer container = this.jvLinkManager.getJvBeansContainer();
        int result = -1;
        while (result != 0) {
            contents = this.read(container.getRecordByteLength(condition.getRecordTypeId()));
            result = contents.getReturnCode();
            if (result < -1) {
                if (result == -3) {
                    ThreadUtil.sleep(1000L);
                    continue;
                }
                JvLinkExceptionHandler.handleException(contents);
            }
            if (contents.startWith(condition.getRecordTypeId()) && !contents.isEmpty()) break;
            if (!(condition instanceof StoredOpenCondition)) continue;
            this.jvLinkManager.skip();
        }
        return contents;
    }

    private JvContents<T> read(int length) {
        return this.jvLinkManager.getJvLinkWrapper().jvRead(length);
    }

    public OpenCondition<T> getOpenCondition() {
        return this.openCondition;
    }
}

