/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.jvbeans.jvlink.converter;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.stormcat.jvbeans.common.constants.Charset;
import org.stormcat.jvbeans.common.constants.FileExtension;
import org.stormcat.jvbeans.common.lang.StringUtil;
import org.stormcat.jvbeans.jvlink.analyze.JvBeansContainer;
import org.stormcat.jvbeans.jvlink.analyze.JvRecordMeta;
import org.stormcat.jvbeans.jvlink.converter.JvDataConverter;
import org.stormcat.jvbeans.util.JvStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JvIncludeSeparatorDataConvertor
extends JvDataConverter {
    protected JvIncludeSeparatorDataConvertor(FileExtension outputType) {
        super(outputType);
    }

    @Override
    public String convert(JvBeansContainer container, String data) {
        if (StringUtils.isBlank((String)data)) {
            return "";
        }
        if (data.length() < 2) {
            return data;
        }
        List<JvRecordMeta> metaItems = container.getRecordMetaItems(data.substring(0, 2));
        StringBuilder builder = new StringBuilder();
        this.appendString(builder, data, metaItems);
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private void appendString(StringBuilder builder, String data, List<JvRecordMeta> metaItems) {
        int position = 0;
        byte[] bytes = StringUtil.getBytes(data, Charset.MS932);
        for (JvRecordMeta meta : metaItems) {
            int byteLength = meta.getByteLength();
            int repeatCount = meta.getRepeatCount();
            int i = 1;
            while (i <= repeatCount) {
                byte[] parts = ArrayUtils.subarray((byte[])bytes, (int)position, (int)(position + byteLength));
                String rawData = StringUtil.getString(parts, Charset.MS932);
                List<JvRecordMeta> joinItems = meta.getJoinMetaItems();
                if (joinItems != null && !joinItems.isEmpty()) {
                    this.appendString(builder, rawData, joinItems);
                } else {
                    builder.append("\"");
                    builder.append(JvStringUtil.trim(rawData));
                    builder.append("\"");
                    builder.append(this.getSeparator());
                }
                position += byteLength;
                ++i;
            }
        }
    }

    protected abstract String getSeparator();
}

