/*
 * Copyright 2009-2011 the Stormcat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.stormcat.jvbeans.jvlink.definitions.code;
 
/**
 * <b>2007.競走条件コード</b> のEnumによる表現です。
 * @author jv-beans-gen
 * @since 0.1
 *
 */
public enum RaceConditionCd implements org.stormcat.jvbeans.common.constants.PairValueEnum<String> {

    /** 未設定・未整備時の初期値(主に地方競馬・海外国際レースに関するデータ) */
    UNKNOWN("未設定・未整備時の初期値(主に地方競馬・海外国際レースに関するデータ)", "000", ""),
    
    /** １００万円以下 */
    _00100_LESS("１００万円以下", "001", "1,000,000 & LESS"),
    
    /** ２００万円以下  */
    _00200_LESS("２００万円以下 ", "002", "2,000,000 & LESS"),
    
    /** ３００万円以下   */
    _00300_LESS("３００万円以下  ", "003", "3,000,000 & LESS"),
    
    /** ４００万円以下 */
    _00400_LESS("４００万円以下", "004", "4,000,000 & LESS"),
    
    /** ５００万円以下 */
    _00500_LESS("５００万円以下", "005", "5,000,000 & LESS"),
    
    /** ６００万円以下 */
    _00600_LESS("６００万円以下", "006", "6,000,000 & LESS"),
    
    /** ７００万円以下 */
    _00700_LESS("７００万円以下", "007", "7,000,000 & LESS"),
    
    /** ８００万円以下 */
    _00800_LESS("８００万円以下", "008", "8,000,000 & LESS"),
    
    /** ９００万円以下 */
    _00900_LESS("９００万円以下", "009", "9,000,000 & LESS"),
    
    /** １０００万円以下 */
    _01000_LESS("１０００万円以下", "010", "10,000,000 & LESS"),
    
    /** １１００万円以下 */
    _01100_LESS("１１００万円以下", "011", "11,000,000 & LESS"),
    
    /** １２００万円以下 */
    _01200_LESS("１２００万円以下", "012", "12,000,000 & LESS"),
    
    /** １３００万円以下 */
    _01300_LESS("１３００万円以下", "013", "13,000,000 & LESS"),
    
    /** １４００万円以下 */
    _01400_LESS("１４００万円以下", "014", "14,000,000 & LESS"),
    
    /** １５００万円以下 */
    _01500_LESS("１５００万円以下", "015", "15,000,000 & LESS"),
    
    /** １６００万円以下 */
    _01600_LESS("１６００万円以下", "016", "16,000,000 & LESS"),
    
    /** １７００万円以下 */
    _01700_LESS("１７００万円以下", "017", "17,000,000 & LESS"),
    
    /** １８００万円以下 */
    _01800_LESS("１８００万円以下", "018", "18,000,000 & LESS"),
    
    /** １９００万円以下 */
    _01900_LESS("１９００万円以下", "019", "19,000,000 & LESS"),
    
    /** ２０００万円以下 */
    _02000_LESS("２０００万円以下", "020", "20,000,000 & LESS"),
    
    /** ２１００万円以下 */
    _02100_LESS("２１００万円以下", "021", "21,000,000 & LESS"),
    
    /** ２２００万円以下 */
    _02200_LESS("２２００万円以下", "022", "22,000,000 & LESS"),
    
    /** ２３００万円以下 */
    _02300_LESS("２３００万円以下", "023", "23,000,000 & LESS"),
    
    /** ２４００万円以下 */
    _02400_LESS("２４００万円以下", "024", "24,000,000 & LESS"),
    
    /** ２５００万円以下 */
    _02500_LESS("２５００万円以下", "025", "25,000,000 & LESS"),
    
    /** ２６００万円以下 */
    _02600_LESS("２６００万円以下", "026", "26,000,000 & LESS"),
    
    /** ２７００万円以下 */
    _02700_LESS("２７００万円以下", "027", "27,000,000 & LESS"),
    
    /** ２８００万円以下 */
    _02800_LESS("２８００万円以下", "028", "28,000,000 & LESS"),
    
    /** ２９００万円以下 */
    _02900_LESS("２９００万円以下", "029", "29,000,000 & LESS"),
    
    /** ３０００万円以下 */
    _03000_LESS("３０００万円以下", "030", "30,000,000 & LESS"),
    
    /** ３１００万円以下 */
    _03100_LESS("３１００万円以下", "031", "31,000,000 & LESS"),
    
    /** ３２００万円以下 */
    _03200_LESS("３２００万円以下", "032", "32,000,000 & LESS"),
    
    /** ３３００万円以下 */
    _03300_LESS("３３００万円以下", "033", "33,000,000 & LESS"),
    
    /** ３４００万円以下 */
    _03400_LESS("３４００万円以下", "034", "34,000,000 & LESS"),
    
    /** ３５００万円以下 */
    _03500_LESS("３５００万円以下", "035", "35,000,000 & LESS"),
    
    /** ３６００万円以下 */
    _03600_LESS("３６００万円以下", "036", "36,000,000 & LESS"),
    
    /** ３７００万円以下 */
    _03700_LESS("３７００万円以下", "037", "37,000,000 & LESS"),
    
    /** ３８００万円以下 */
    _03800_LESS("３８００万円以下", "038", "38,000,000 & LESS"),
    
    /** ３９００万円以下 */
    _03900_LESS("３９００万円以下", "039", "39,000,000 & LESS"),
    
    /** ４０００万円以下 */
    _04000_LESS("４０００万円以下", "040", "40,000,000 & LESS"),
    
    /** ４１００万円以下 */
    _04100_LESS("４１００万円以下", "041", "41,000,000 & LESS"),
    
    /** ４２００万円以下 */
    _04200_LESS("４２００万円以下", "042", "42,000,000 & LESS"),
    
    /** ４３００万円以下 */
    _04300_LESS("４３００万円以下", "043", "43,000,000 & LESS"),
    
    /** ４４００万円以下 */
    _04400_LESS("４４００万円以下", "044", "44,000,000 & LESS"),
    
    /** ４５００万円以下 */
    _04500_LESS("４５００万円以下", "045", "45,000,000 & LESS"),
    
    /** ４６００万円以下 */
    _04600_LESS("４６００万円以下", "046", "46,000,000 & LESS"),
    
    /** ４７００万円以下 */
    _04700_LESS("４７００万円以下", "047", "47,000,000 & LESS"),
    
    /** ４８００万円以下 */
    _04800_LESS("４８００万円以下", "048", "48,000,000 & LESS"),
    
    /** ４９００万円以下 */
    _04900_LESS("４９００万円以下", "049", "49,000,000 & LESS"),
    
    /** ５０００万円以下 */
    _05000_LESS("５０００万円以下", "050", "50,000,000 & LESS"),
    
    /** ５１００万円以下 */
    _05100_LESS("５１００万円以下", "051", "51,000,000 & LESS"),
    
    /** ５２００万円以下 */
    _05200_LESS("５２００万円以下", "052", "52,000,000 & LESS"),
    
    /** ５３００万円以下 */
    _05300_LESS("５３００万円以下", "053", "53,000,000 & LESS"),
    
    /** ５４００万円以下 */
    _05400_LESS("５４００万円以下", "054", "54,000,000 & LESS"),
    
    /** ５５００万円以下 */
    _05500_LESS("５５００万円以下", "055", "55,000,000 & LESS"),
    
    /** ５６００万円以下 */
    _05600_LESS("５６００万円以下", "056", "56,000,000 & LESS"),
    
    /** ５７００万円以下 */
    _05700_LESS("５７００万円以下", "057", "57,000,000 & LESS"),
    
    /** ５８００万円以下 */
    _05800_LESS("５８００万円以下", "058", "58,000,000 & LESS"),
    
    /** ５９００万円以下 */
    _05900_LESS("５９００万円以下", "059", "59,000,000 & LESS"),
    
    /** ６０００万円以下 */
    _06000_LESS("６０００万円以下", "060", "60,000,000 & LESS"),
    
    /** ６１００万円以下 */
    _06100_LESS("６１００万円以下", "061", "61,000,000 & LESS"),
    
    /** ６２００万円以下 */
    _06200_LESS("６２００万円以下", "062", "62,000,000 & LESS"),
    
    /** ６３００万円以下 */
    _06300_LESS("６３００万円以下", "063", "63,000,000 & LESS"),
    
    /** ６４００万円以下 */
    _06400_LESS("６４００万円以下", "064", "64,000,000 & LESS"),
    
    /** ６５００万円以下 */
    _06500_LESS("６５００万円以下", "065", "65,000,000 & LESS"),
    
    /** ６６００万円以下 */
    _06600_LESS("６６００万円以下", "066", "66,000,000 & LESS"),
    
    /** ６７００万円以下 */
    _06700_LESS("６７００万円以下", "067", "67,000,000 & LESS"),
    
    /** ６８００万円以下 */
    _06800_LESS("６８００万円以下", "068", "68,000,000 & LESS"),
    
    /** ６９００万円以下 */
    _06900_LESS("６９００万円以下", "069", "69,000,000 & LESS"),
    
    /** ７０００万円以下 */
    _07000_LESS("７０００万円以下", "070", "70,000,000 & LESS"),
    
    /** ７１００万円以下 */
    _07100_LESS("７１００万円以下", "071", "71,000,000 & LESS"),
    
    /** ７２００万円以下 */
    _07200_LESS("７２００万円以下", "072", "72,000,000 & LESS"),
    
    /** ７３００万円以下 */
    _07300_LESS("７３００万円以下", "073", "73,000,000 & LESS"),
    
    /** ７４００万円以下 */
    _07400_LESS("７４００万円以下", "074", "74,000,000 & LESS"),
    
    /** ７５００万円以下 */
    _07500_LESS("７５００万円以下", "075", "75,000,000 & LESS"),
    
    /** ７６００万円以下 */
    _07600_LESS("７６００万円以下", "076", "76,000,000 & LESS"),
    
    /** ７７００万円以下 */
    _07700_LESS("７７００万円以下", "077", "77,000,000 & LESS"),
    
    /** ７８００万円以下 */
    _07800_LESS("７８００万円以下", "078", "78,000,000 & LESS"),
    
    /** ７９００万円以下 */
    _07900_LESS("７９００万円以下", "079", "79,000,000 & LESS"),
    
    /** ８０００万円以下 */
    _08000_LESS("８０００万円以下", "080", "80,000,000 & LESS"),
    
    /** ８１００万円以下 */
    _08100_LESS("８１００万円以下", "081", "81,000,000 & LESS"),
    
    /** ８２００万円以下 */
    _08200_LESS("８２００万円以下", "082", "82,000,000 & LESS"),
    
    /** ８３００万円以下 */
    _08300_LESS("８３００万円以下", "083", "83,000,000 & LESS"),
    
    /** ８４００万円以下 */
    _08400_LESS("８４００万円以下", "084", "84,000,000 & LESS"),
    
    /** ８５００万円以下 */
    _08500_LESS("８５００万円以下", "085", "85,000,000 & LESS"),
    
    /** ８６００万円以下 */
    _08600_LESS("８６００万円以下", "086", "86,000,000 & LESS"),
    
    /** ８７００万円以下 */
    _08700_LESS("８７００万円以下", "087", "87,000,000 & LESS"),
    
    /** ８８００万円以下 */
    _08800_LESS("８８００万円以下", "088", "88,000,000 & LESS"),
    
    /** ８９００万円以下 */
    _08900_LESS("８９００万円以下", "089", "89,000,000 & LESS"),
    
    /** ９０００万円以下 */
    _09000_LESS("９０００万円以下", "090", "90,000,000 & LESS"),
    
    /** ９１００万円以下 */
    _09100_LESS("９１００万円以下", "091", "91,000,000 & LESS"),
    
    /** ９２００万円以下 */
    _09200_LESS("９２００万円以下", "092", "92,000,000 & LESS"),
    
    /** ９３００万円以下 */
    _09300_LESS("９３００万円以下", "093", "93,000,000 & LESS"),
    
    /** ９４００万円以下 */
    _09400_LESS("９４００万円以下", "094", "94,000,000 & LESS"),
    
    /** ９５００万円以下 */
    _09500_LESS("９５００万円以下", "095", "95,000,000 & LESS"),
    
    /** ９６００万円以下 */
    _09600_LESS("９６００万円以下", "096", "96,000,000 & LESS"),
    
    /** ９７００万円以下 */
    _09700_LESS("９７００万円以下", "097", "97,000,000 & LESS"),
    
    /** ９８００万円以下 */
    _09800_LESS("９８００万円以下", "098", "98,000,000 & LESS"),
    
    /** ９９００万円以下  */
    _09900_LESS("９９００万円以下 ", "099", "99,000,000 & LESS"),
    
    /** １億円以下   */
    _10000_LESS("１億円以下  ", "100", "100,000,000 & LESS"),
    
    /** 新馬 */
    NEWCOMER("新馬", "701", "NEWCOMER"),
    
    /** 未出走 */
    UNRACED("未出走", "702", "UNRACED"),
    
    /** 未勝利 */
    MAIDEN("未勝利", "703", "MAIDEN"),
    
    /** オープン */
    OPEN("オープン", "999", "OPEN"),
    
    ;

    /** 名称 */
    private String name;
    
    /** 値 */
    private String value;
    
    /** 欧字名 */
    private String nameEng;
    
    private RaceConditionCd(String name, String value, String nameEng) {
        this.name = name;
        this.value = value;
        this.nameEng = nameEng;
    }
    
    /**
     * {@inheritDoc}
     */
    public String getName() {
        return this.name;
    }    

    /**
     * {@inheritDoc}
     */
    public String getValue() {
        return this.value;
    }
    
    /**
     * 欧字名を返します。
     * @return 欧字名
     */
    public String getNameEng() {
        return this.nameEng;
    }

}