#include "stdafx.h"

#include "CommandArgument.hpp"

#include <assert.h>

CommandArgument::CommandArgument() throw()
	: cmdtype_( cmdtype_none )
{
}

CommandArgument::CommandArgument( const CommandArgument& v_other ) throw()
	: cmdtype_( v_other.cmdtype_ )
	, serviceName_( v_other.serviceName_ )
	, configPath_( v_other.configPath_ )
	, logPath_( v_other.logPath_ )
	, dependencies_( v_other.dependencies_ )
	, workdir_( v_other.workdir_ )
{
}

CommandArgument::~CommandArgument() throw()
{
}

CommandArgument::size_type CommandArgument::size() const throw()
{
	return dependencies_.size();
}

CommandArgument::const_iterator CommandArgument::begin() const throw()
{
	return dependencies_.begin();
}

CommandArgument::const_iterator CommandArgument::end() const throw()
{
	return dependencies_.end();
}

const CommandArgument::cmdtype CommandArgument::getCommandType() const throw()
{
	return cmdtype_;
}

const std::string& CommandArgument::getServiceName() const throw()
{
	return serviceName_;
}

const std::string& CommandArgument::getConfigPath() const throw()
{
	return configPath_;
}

const std::string& CommandArgument::getLogPath() const throw()
{
	return logPath_;
}

const std::string& CommandArgument::getWorkDir() const throw()
{
	return workdir_;
}


////////////////////

CommandArgumentFactory::CommandArgumentFactory() throw()
	: acceptDependencies_( false )
{
}

CommandArgumentFactory::~CommandArgumentFactory() throw()
{
}

CommandArgument CommandArgumentFactory::create( int argc, char* argv[] ) throw ( std::exception )
{
	//required:
	assert( argc > 0 );
	assert( argv != NULL );

	//do:
	CommandArgumentFactory inst;
	StringVector args;

	int optionLen = 0;
	for( int idx=1; idx<argc; idx++ ) {
		const std::string arg = argv[ idx ];
		if( optionLen == 0 ) {
			optionLen = inst.getOptionLength( arg );
			if( optionLen <= 0 ) {
				throw std::invalid_argument( std::string( "FłȂIvVw肳Ă܂B" ) + arg );
			}
			args.clear();
		}
		args.push_back( arg );
		if( --optionLen == 0 ) {
			inst.parse( args );
		}
	}
	if( optionLen != 0 ) {
		throw std::invalid_argument( "sĂ܂B" );
	}

	inst.validate();
	return inst.target_;
}

void CommandArgumentFactory::validate() const throw ( std::exception )
{
	// T[rX̌
	switch( target_.cmdtype_ )
	{
	case CommandArgument::cmdtype_runservice:
	case CommandArgument::cmdtype_regist:
	case CommandArgument::cmdtype_unregist:
		if( target_.serviceName_.empty() ) {
			throw std::invalid_argument( "T[rXw肳Ă܂B" );
		}
		break;

	case CommandArgument::cmdtype_none:
		break;

	default:
		assert( false );
		throw std::runtime_error( "sȃR}h^Cvݒ肳܂B" );
		break;
	}

	// ݒt@Cƈˑ֌WA[LOfBNǧ
	switch( target_.cmdtype_ )
	{
	case CommandArgument::cmdtype_runservice:
	case CommandArgument::cmdtype_regist:
		if( target_.configPath_.empty() ) {
			throw std::invalid_argument( "ݒt@Cw肳Ă܂B" );
		}
		break;

	case CommandArgument::cmdtype_unregist:
	case CommandArgument::cmdtype_none:
	default:
		if( ! target_.configPath_.empty() ) {
			throw std::invalid_argument( "ݒt@C͓o^ȊOł͎wł܂B" );
		}
		if( ! target_.logPath_.empty() ) {
			throw std::invalid_argument( "Ot@C͓o^ȊOł͎wł܂B" );
		}
		if( ! target_.workdir_.empty() ) {
			throw std::invalid_argument( "[LOfBNg͓o^ȊOł͎wł܂B" );
		}
		if( target_.dependencies_.size() > 0 ) {
			throw std::invalid_argument( "ˑT[rX͓o^ȊOł͎wł܂B" );
		}
		break;
	}
}

int CommandArgumentFactory::getOptionLength( const std::string& v_arg ) throw( std::exception )
{
	if( target_.cmdtype_ == CommandArgument::cmdtype_none ) {
		if( v_arg == "-h" || v_arg == "--help" ) {
			return 1;
		}
		else if( v_arg == "-r" || v_arg == "--regist" ) {
			return 2;
		}
		else if( v_arg == "-u" || v_arg == "--unregist" ) {
			return 2;
		}
		else if( v_arg == "--runService" ) {
			return 2;
		}
		else if( v_arg[ 0 ] != '-' ) {
			return 1;
		}
	}
	else {
		if( ! acceptDependencies_ ) {
			if( v_arg == "-c" || v_arg == "--config" ) {
				return 2;
			}
			else if( v_arg == "-l" || v_arg == "--log" ) {
				return 2;
			}
			else if( v_arg == "-w" || v_arg == "--workingdir" ) {
				return 2;
			}
			else if( v_arg == "-d" || v_arg == "--dependencies" ) {
				return 1;
			}
		}
		else {
			if( v_arg[ 0 ] == '-' ) {
				return 0;
			}
			return 1;
		}
	}
	return 0;
}

void CommandArgumentFactory::parse( const StringVector& v_args ) throw ( std::exception )
{
	if( target_.cmdtype_ == CommandArgument::cmdtype_none ) {
		if( v_args[ 0 ] == "-h" || v_args[ 0 ] == "--help" ) {
			target_.cmdtype_ = CommandArgument::cmdtype_none;
		}
		else if( v_args[ 0 ] == "-r" || v_args[ 0 ] == "--regist" ) {
			target_.cmdtype_ = CommandArgument::cmdtype_regist;
			target_.serviceName_ = v_args[ 1 ];
		}
		else if( v_args[ 0 ] == "-u" || v_args[ 0 ] == "--unregist" ) {
			target_.cmdtype_ = CommandArgument::cmdtype_unregist;
			target_.serviceName_ = v_args[ 1 ];
		}
		else if( v_args[ 0 ] == "--runService" ) {
			target_.cmdtype_ = CommandArgument::cmdtype_runservice;
			target_.serviceName_ = v_args[ 1 ];
		}
		else if( v_args[ 0 ][ 0 ] != '-' ) {
			target_.cmdtype_ = CommandArgument::cmdtype_regist;
			target_.serviceName_ = v_args[ 0 ];
		}
		else {
			assert( false );
		}
	}
	else {
		if( ! acceptDependencies_ ) {
			if( v_args[ 0 ] == "-c" || v_args[ 0 ] == "--config" ) {
				target_.configPath_ = v_args[ 1 ];
			}
			else if( v_args[ 0 ] == "-l" || v_args[ 0 ] == "--log" ) {
				target_.logPath_ = v_args[ 1 ];
			}
			else if( v_args[ 0 ] == "-w" || v_args[ 0 ] == "--workingdir" ) {
				target_.workdir_ = v_args[ 1 ];
			}
			else if( v_args[ 0 ] == "-d" || v_args[ 0 ] == "--dependencies" ) {
				acceptDependencies_ = true;
			}
			else {
				assert( false );
			}
		}
		else {
			if( v_args[ 0 ][ 0 ] != '-' ) {
				target_.dependencies_.push_back( v_args[ 0 ] );
			}
			else {
				assert( false );
			}
		}
	}
}

void CommandArgumentFactory::showHelp() throw()
{
	fputs( "̂ꂩ̌`ŃR}hw肵܂B\n", stdout );
	fputs( "T[rX̓o^\n  jvmservice.exe [ --regist ] T[rX --config ݒt@C [--log Ot@C] [--workingdir ƃfBNg] [ --dependencies [ ˑT[rX ... ]]\n", stdout );
	fputs( "T[rX̓o^\n  jvmservice.exe --unregist T[rX\n", stdout );
}



