#ifndef INCLUDE_H_CONFIGPARSER
#define INCLUDE_H_CONFIGPARSER

#include <list>

#include "JavaVMMainThread.hpp"

class ConfigParser
{
public:
	typedef std::list<StartupInfo> StartupInfoList;

	typedef StartupInfoList::iterator iterator;
	typedef StartupInfoList::const_iterator const_iterator;
	typedef StartupInfoList::value_type value_type;
	typedef StartupInfoList::size_type size_type;
	typedef StartupInfoList::reference reference;
	typedef StartupInfoList::const_reference const_reference;

	ConfigParser();
	~ConfigParser();

	void parse( const std::string& v_fileName );

	const JavaVMStartupInfo& getJavaVMStartupInfo() const;
	ConfigParser::iterator begin();
	ConfigParser::const_iterator begin() const;
	ConfigParser::iterator end();
	ConfigParser::const_iterator end() const;
	ConfigParser::size_type size() const;

protected:
	static std::string expandEnvironmentStrings( const std::string& v_line );
	void parseJVMOption( const std::string& v_line );
	void parseMethodOption( const std::string& v_line );

private:
	JavaVMStartupInfo jvmStartupInfo_;
	StartupInfoList methods_;
};


#endif
