#include "stdafx.h"

#include "Event.hpp"

namespace
{
	volatile LONG lock_ = 0L;
}

EventRef::EventRef( bool v_auto, bool v_initialState ) throw ( std::exception )
{
	HANDLE hEvent = CreateEvent( NULL, v_auto ? FALSE : TRUE, v_initialState ? TRUE : FALSE, NULL );
	if( hEvent == NULL ) {
		throw std::runtime_error( "Cxg̍쐬Ɏs܂B" );
	}

	try{
		pEventData_ = new EventData_();
		while( InterlockedExchange( &lock_, 1L ) != 0L ) {
			Sleep( 0 );
		}
		pEventData_->hEvent_ = hEvent;
		pEventData_->ref_ = 1;
		InterlockedExchange( &lock_, 0L );
	}
	catch( ... ) {
		CloseHandle( hEvent );
		throw;
	}
}

EventRef::EventRef( const EventRef& v_event ) throw()
{
	while( InterlockedExchange( &lock_, 1L ) != 0L ) {
		Sleep( 0 );
	}
	__try{
		pEventData_ = v_event.pEventData_;
		pEventData_->ref_++;
	}
	__finally{
		InterlockedExchange( &lock_, 0L );
	}
}

EventRef& EventRef::operator=( const EventRef& v_event ) throw()
{
	if( this != &v_event ) {
		while( InterlockedExchange( &lock_, 1L ) != 0L ) {
			Sleep( 0 );
		}
		__try{
			if( --pEventData_->ref_ == 0 ) {
				delete pEventData_;
			}
			pEventData_ = v_event.pEventData_;
			pEventData_->ref_++;
		}
		__finally {
			InterlockedExchange( &lock_, 0L );
		}
	}
	return *this;
}

EventRef::~EventRef() throw()
{
	while( InterlockedExchange( &lock_, 1L ) != 0L ) {
		Sleep( 0 );
	}
	__try{
		if( --pEventData_->ref_ == 0 ) {
			delete pEventData_;
		}
	}
	__finally {
		InterlockedExchange( &lock_, 0L );
	}
}

bool EventRef::waitForSignal( DWORD v_wait ) throw()
{
	return WaitForSingleObject( pEventData_->hEvent_ , v_wait ) != WAIT_TIMEOUT;
}

void EventRef::signal( bool v_state ) throw()
{
	if( v_state ) {
		SetEvent( pEventData_->hEvent_ );
	}
	else {
		ResetEvent( pEventData_->hEvent_ );
	}
}

void EventRef::pulse() throw()
{
	PulseEvent( pEventData_->hEvent_ );
}

