#ifndef INCLUDE_H_EVENTLOG
#define INCLUDE_H_EVENTLOG

#include <string>
#include <exception>

#include <windows.h>

#include "Win32Exception.hpp"

class EventLog
{
private:
	EventLog( const EventLog& ); //<! Ȃ
	operator=( const EventLog& ); //<! Ȃ

public:
	EventLog( const std::string& v_eventSourceName ) throw();
	~EventLog() throw();

	void open() throw ( std::exception );
	void close() throw();
	void reportEvent( DWORD v_eventID, WORD cnt = 0, LPCSTR* messages = NULL, WORD v_eventType = EVENTLOG_ERROR_TYPE ) const throw();

	void registerEventSource( const std::string& v_modulePath ) throw( std::exception );
	void unregisterEventSource( const std::string& v_modulePath ) throw ( std::exception );

private:
	std::string eventSourceName_;
	HANDLE hEventLog_;
};

#endif
