#ifndef INCLUDE_H_JVMLAUNCHER
#define INCLUDE_H_JVMLAUNCHER

#include "JavaVMCallback.hpp"
#include "JavaVMMainThread.hpp"

#include "Win32Exception.hpp"

#include <string>
#include <memory>

class JVMLauncher
{
private:
	JVMLauncher( const JVMLauncher& ); //<! Ȃ
	operator=( const JVMLauncher& ); //<! Ȃ

public:
	JVMLauncher( JVMEventListener& v_eventListener ) throw ();
	void preloadLibrary( const std::string& v_preloadConfPath ) throw ( Win32Exception );
	void launchJVM( const std::string& v_configPath ) throw ( std::exception );
	void switchToJVM() throw();
	bool shutdown() throw();

private:
	static unsigned __stdcall stopThreadProc( void* v_pData ) throw();

	JVMEventListener& eventListener_;
	typedef std::auto_ptr<JavaVMMainThread> JavaVMMainThreadPtr;
	JavaVMMainThreadPtr pJVM_;
};

#endif
