#ifndef INCLUDE_H_JAVAVMMAINTHREAD
#define INCLUDE_H_JAVAVMMAINTHREAD

#include <string>
#include <vector>
#include <exception>

#include "JavaVMCallback.hpp"
#include "JVMException.hpp"
#include "StartupInfo.hpp"
#include "JavaVMStartupInfo.hpp"
#include "Event.hpp"

class JavaVMMainThread
{
public:
	/*!
	 * JVM̋Np[^w肵č\z܂B
	 * (JNI1.2)łJVM͈񂵂쐬łȂ߁A
	 * ̃IuWFNgx\z邱Ƃ͂ł܂B 
	 * \param v_callback JavaVM̃Cxgʒm܂B
	 * \param v_jvmStartupInfo JVM̋Np[^
	 * \exception std::exception JVMVɍ\złȂꍇ
	 */
	JavaVMMainThread( JVMEventListener& v_eventListener, const JavaVMStartupInfo& v_jvmStartupInfo ) throw ( std::exception );
	
	/*!
	 * fXgN^
	 */
	~JavaVMMainThread() throw();

	/*!
	 * ݂̃XbhJavaVM̃CXbhJn܂B
	 * JnłȂAłɊJnς݂łΗO܂B
	 * \exception std::exception JVMVɊJnłȂꍇ
	 */
	void start() throw ( std::exception );

	/*!
	 * ݂̃XbhJavaVMׂ̂ẴXbh̏Iҋ@܂B
	 * JavaVMJnĂȂꍇ͗O܂B
	 *  (JNI1.2)ł́AJVM͔j邱Ƃ͂܂B
	 * \exception std::exception O
	 */
	void waitForFinishedAll() throw ( std::exception );

	/*!
	 * VXbh쐬A\bhĂяo܂B
	 * JavaVMJnĂȂꍇAу\bȟĂяołȂꍇ͗O܂B
	 * v_waittruȅꍇ̓XbhI܂Ő߂܂B
	 * łȂΊ҂ɐԂ܂B
	 * ҋ@ꍇÃXbhO𔭐ĂꍇfalseԂ܂B
	 * ҋ@ȂAXbhO𔭐ɏIꍇtrueԂ܂B
	 * \param v_startupInfo Np[^
	 * \param v_wait Xbh̏Iҋ@ꍇAtrue
	 * \return ȂtrueAłȂfalse
	 * \exception std::exception O
	 */
	bool invokeClassMethod( const StartupInfo& v_startupInfo, bool v_wait = false ) throw ( std::exception );

	/*!
	 * ݂̃XbhJavaVMɐڑASystem.exit()Ăяo܂B
	 * ̃\bh͌ĐɕA܂B
	 * JavaVMJnĂȂꍇASystem.exit()̌ĂяołȂꍇ͗O܂B
	 * ɌĂяoꂽꍇAJavaVMexitCxg𔭐AexitĂяo܂B
	 * \exception std::exception O
	 */
	void stopInterrupt() throw ( std::exception );

protected:

	enum ThreadEvent
	{
		ThreadEvent_Starting = 0,
		ThreadEvent_Terminated = 1
	};

	/*!
	 * XbhɈn߂̃p[^B
	 */
	class InvokeInfoRef
	{
	public:
		InvokeInfoRef( JavaVMMainThread* v_pThis, const StartupInfo& v_startupInfo, EventRef& v_hStarted ) throw();
		InvokeInfoRef( const InvokeInfoRef& v_other ) throw();
		InvokeInfoRef& operator=( const InvokeInfoRef& v_other ) throw();
		~InvokeInfoRef() throw();

		void setExceptionReason( const std::string& v_exceptionReason ) throw();
		const StartupInfo& getStartupInfo() const throw();
		const std::string& getExceptionReason() const throw();
		JavaVMMainThread* getJavaVMMainThread() const throw();
		void signal() throw();

	private:
		struct InvokeInfoData_
		{
			InvokeInfoData_( JavaVMMainThread* v_pThis, const StartupInfo& v_startupInfo, EventRef& v_hStarted );

			/*!
			* XbhĂяo
			*/
			JavaVMMainThread* pThis_;

			/*!
			* JAVA\bhIDɈnp[^
			*/
			StartupInfo startupInfo_;

			/*!
			* OɂIꍇ̎R
			* Ȃ΋łB
			*/
			std::string exceptionReason_;

			/*!
			* XbhNƂCxgB
			* Xbh́AJVMɃXbhA^b`A
			* ̃f[^Rs[ƂɃCxgVOiԂɂ܂B
			* ܂ŃXbh쐬͑ҋ@Ȃ΂Ȃ܂B
			*/
			EventRef hStarted_;

			/*!
			 * QƃJEg
			 */
			int ref_;
		};
		
		mutable InvokeInfoData_* pInvokeInfoData_;
	};

	/*!
	 * Xbh̊Jn^ICxg󂯎nhłB
	 * \param v_eventType Cxg^Cv
	 * \param v_invokeInfo Np[^
	 */
	void notifyThreadEvent( ThreadEvent v_eventType, const InvokeInfoRef& v_invokeInfo ) throw();

	/*!
	 * hbg\L̃NXJNIvXbV؂̂̂ɕϊĕԂ܂B
	 */
	static std::string ConvertToJNIClassName( const std::string& v_className ) throw();

	/*!
	 * Xbh̃GgłB
	 * \param v_pData XbhɓnInvokeInfo\̂ւ̃|C^
	 */
	static unsigned __stdcall invokeClassMethodProc( void* v_pData ) throw();

	/*!
	 * JVMŖIexitꂽꍇɌĂяo܂B
	 * ͕ԂexitKv܂B
	 */
	static void __stdcall jvm_exit( jint );

	/*!
	 * JVMabortꂽꍇɌĂяo܂B
	 * ͕ԂabortKv܂B
	 */
	static void __stdcall jvm_abort();

	/*!
	 * JVMbZ[Wo͂邽тɌĂяo܂B
	 * \param v_fp o͐
	 * \param v_format tH[}bg
	 * \param v_args Xg
	 * \return ݕ
	 */
	static jint __stdcall jvm_vfprintf( FILE* v_fp, const char* v_format, va_list v_args );

private:

	/*!
	 * JavaVMNp[^
	 */
	JavaVMStartupInfo jvmStartupInfo_;

	/*!
	 * JavaVMւ̃|C^
	 */
	JavaVM* jvm_;
};

#endif
