#ifndef INCLUDE_H_JVMSTARTUPINFO
#define INCLUDE_H_JVMSTARTUPINFO

#include <vector>
#include <string>

class JavaVMStartupInfo
{
public:
	typedef std::vector<std::string> StringVector;

	typedef StringVector::iterator iterator;
	typedef StringVector::const_iterator const_iterator;
	typedef StringVector::value_type value_type;
	typedef StringVector::size_type size_type;
	typedef StringVector::reference reference;
	typedef StringVector::const_reference const_reference;

	JavaVMStartupInfo( const bool v_ignoreUnrecognized = true ) throw();
	JavaVMStartupInfo( const JavaVMStartupInfo& v_other ) throw();
	JavaVMStartupInfo& operator=( const JavaVMStartupInfo& v_other ) throw();
	~JavaVMStartupInfo() throw();

	bool isIgnoreUnrecognized() const throw();

	JavaVMStartupInfo::iterator begin() throw();
	JavaVMStartupInfo::const_iterator begin() const throw();
	JavaVMStartupInfo::iterator end() throw();
	JavaVMStartupInfo::const_iterator end() const throw();
	JavaVMStartupInfo::size_type size() const throw();
	
	bool push_back( const std::string& v_arg ) throw();

private:
	bool ignoreUnrecognized_;
	StringVector options_;
};


#endif
