#ifndef INCLUDE_H_SERVICECONTROLLMANAGER
#define INCLUDE_H_SERVICECONTROLLMANAGER

#include <exception>
#include <string>
#include <vector>

#include "Win32Exception.hpp"

class ServiceIdentifier
{
public:
	ServiceIdentifier( const std::string& v_serviceName ) throw( std::exception );
	ServiceIdentifier( const ServiceIdentifier& v_other ) throw();
	ServiceIdentifier& operator=( const ServiceIdentifier& v_other ) throw();

	const std::string& getServiceName() const throw();
	
private:
	std::string serviceName_;
};

class ServiceRegistParam : public ServiceIdentifier
{
public:
	typedef std::vector<std::string> StringVector;

	ServiceRegistParam( const std::string& v_serviceName, const std::string& v_displayName, const std::string& v_command ) throw ( std::exception );
	ServiceRegistParam( const ServiceRegistParam& v_other ) throw();
	ServiceRegistParam& operator=( const ServiceRegistParam& v_other ) throw();

	const std::string& getDisplayName() const throw();
	const std::string& getCommand() const throw();
	const StringVector& dependencies() const throw();
	StringVector& dependencies() throw();

private:
	std::string displayName_;
	std::string command_;
	StringVector dependencies_;
};

class ServiceControlManager
{
public:
	ServiceControlManager() throw( std::exception );
	~ServiceControlManager() throw();

	void createOrReplaceService( const ServiceRegistParam& v_serviceParam ) throw ( std::exception );
	void updateService( const ServiceRegistParam& v_serviceParam ) throw ( std::exception );
	void deleteService( const ServiceIdentifier& v_serviceIdentifier ) throw ( std::exception );

private:
	class ServiceHandleHolder
	{
	public:
		ServiceHandleHolder( SC_HANDLE v_Sercice ) throw();
		ServiceHandleHolder( const ServiceHandleHolder& v_other ) throw();
		~ServiceHandleHolder() throw();
		ServiceHandleHolder& operator=( const ServiceHandleHolder& v_other ) throw();

		operator SC_HANDLE() const throw();
		SC_HANDLE get() const throw();

	private:
		struct ServiceHandleHolderData_
		{
			~ServiceHandleHolderData_();
			SC_HANDLE hService_;
			int ref_;
		};
		ServiceHandleHolderData_* pData_;
	};

	static std::string getOwnModuleFileName() throw ( std::exception );
	static void checkOwnService( const ServiceHandleHolder& v_service_handle ) throw ( std::exception );
	static void allocDependenciesString( const std::vector<std::string> v_dependencies, std::vector<char>& v_buffer ) throw();

	SC_HANDLE hServiceControlManager_;
};


#endif
