#ifndef INCLUDE_H_SERVICEREGISTERCOMMAND
#define INCLUDE_H_SERVICEREGISTERCOMMAND

#include "Command.hpp"

#include "ServiceControlManager.hpp"

#include <exception>

class ServiceRegisterBase : public Command
{
protected:
	ServiceRegisterBase( const CommandArgument& v_argument ) throw ( std::exception );

public:
	virtual ~ServiceRegisterBase() throw();

protected:
	ServiceControlManager serviceControlManager_;
};

class ServiceRegisterCommand : public ServiceRegisterBase
{
public:
	ServiceRegisterCommand( const CommandArgument& v_argument ) throw ( std::exception );
	virtual ~ServiceRegisterCommand() throw();
	virtual void execute() throw ( std::exception );
};

class ServiceUnregisterCommand : public ServiceRegisterBase
{
public:
	ServiceUnregisterCommand( const CommandArgument& v_argument ) throw ( std::exception );
	virtual ~ServiceUnregisterCommand() throw();
	virtual void execute() throw ( std::exception );
};

#endif
