#include "stdafx.h"

#include "Command.hpp"

int main( int argc, char* argv[] )
{
	const char* const pApplicationName = argv[ 0 ];

	try{
		const CommandArgument argument( CommandArgumentFactory::create( argc, argv ) );
		CommandPtr cmd( Command::create( argument ) );
		cmd->execute();
	}
	catch( const std::exception& v_exception ) {
		MessageBox( NULL, v_exception.what(), pApplicationName, MB_ICONERROR | MB_OK | MB_SERVICE_NOTIFICATION );
	}

	return 0;
}

