#
# Demonstrates the entity classes.
# $Id: entities01.py 934 2006-06-27 22:22:56Z $
#
# Author: nemo
#

import math
from math import sin, cos, pi
import qcad
from qcad import currentGraphic, Graphic, Vector, Line, LineData, Arc, ArcData, Point, PointData, zoomAuto
from matrix import Matrix

doc = currentGraphic()	# current document
#var view				# current document view

#
# Starts the demo.
#
def start(str):
#	doc =  currentGraphic()
#	view = View

	arcs()
	lines()
	points()
#	view.zoomAuto()
	zoomAuto()
	return 1

#
# Arc demo.
#
def arcs():
	global doc

	radius = 1
	angle = 0.0
	while angle<2*pi:
		arc = Arc(doc,
					ArcData(Vector(50.0,50.0),		# center
					radius,							# radius
					angle, angle+pi/2,			# start- / end angle
					0))							# counter clock wise
		doc.addEntity(arc)
		radius+=1
		angle+=pi/16

#
# Line demo.
#
def lines():
	global doc

	v1 = Vector(200,50)
	v2 = Vector(200,50)
	v3 = Vector(200,50)
	v2 = rotate(Vector(150,50), v2, pi*2/3)
	v3 = rotate(Vector(150,50), v3, pi*2/3*2)

	for i in range(0,10,1):
		line = Line(doc, LineData(v1, v2))
		doc.addEntity(line)
		line = Line(doc, LineData(v2, v3))
		doc.addEntity(line)
		line = Line(doc, LineData(v3, v1))
		doc.addEntity(line)

		v1 = rotate(Vector(150,50), v1, pi/16)
		v2 = rotate(Vector(150,50), v2, pi/16)
		v3 = rotate(Vector(150,50), v3, pi/16)

		v1 = scale(Vector(150,50), v1, 0.758)
		v2 = scale(Vector(150,50), v2, 0.758)
		V3 = scale(Vector(150,50), v3, 0.758)

#
# Point demo
#
def points():
	global doc

	p11 = Vector(20, 100)
	p12 = Vector(90, 110)
	p21 = Vector(40, 130)
	p22 = Vector(60, 125)

	for i in range(0,10,1):
		print i
		p1 = divide(p11, p12, 10, i)
		p2 = divide(p21, p22, 10, i)
		print "p1: x=", p1.x, ", y=", p1.y
		print "p2: x=", p2.x, ", y=", p2.y
		for k in range(0,10,1):
			p = divide(p1, p2, 10, k)
			point = Point(doc, PointData(p))
			doc.addEntity(point)


def divide(p1, p2, steps, step):
	p = Vector(0,0)
	p.x = p1.x + (p2.x - p1.x)/steps*step
	p.y = p1.y + (p2.y - p1.y)/steps*step
	return p

# rotating Vector
def rotate(cp, v, ang):
	p = Vector(0,0)
	#moving v to origin
	matm = Matrix(4,4)
	matm.init(0)
	matm[0][0] = 1.0
	matm[1][1] = 1.0
	matm[2][2] = 1.0
	matm[3][3] = 1.0
	matm[0][3] = -cp.x
	matm[1][3] = -cp.y
	matm[2][3] = 0.0
	#rotating
	matr = Matrix(4,4)
	matr.init(0)
	matr[0][0] = cos(ang)
	matr[0][1] = -sin(ang)
	matr[1][0] = sin(ang)
	matr[1][1] = cos(ang)
	matr[2][2] = 1.0
	matr[3][3] = 1.0
	#adding offset
	matm1 = Matrix(4,4)
	matm1.init(0)
	matm1[0][0] = 1.0
	matm1[1][1] = 1.0
	matm1[2][2] = 1.0
	matm1[3][3] = 1.0
	matm1[0][3] = cp.x
	matm1[1][3] = cp.y
	matm1[2][3] = 0.0
	tmat = matm * matr * matm1
	mat1 = Matrix(4,1)
	mat1[0][0] = v.x
	mat1[1][0] = v.y
	mat1[2][0] = 0.0
	mat1[3][0] = 1.0
	rmat = tmat * mat1
	p.x = rmat[0][0]
	p.y = rmat[1][0]
#	p.z = rmat[2][0]
	return p

# scaling Vector
def scale(cp, v, scl):
	p = Vector(0,0)
	#moving v to origin
	matm = Matrix(4,4)
	matm.init(0)
	matm[0][0] = 1.0
	matm[1][1] = 1.0
	matm[2][2] = 1.0
	matm[3][3] = 1.0
	matm[0][3] = -cp.x
	matm[1][3] = -cp.y
	matm[2][3] = 0.0
	#scaling
	mats = Matrix(4,4)
	mats.init(0)
	mats[0][0] = scl
	mats[1][1] = scl
	mats[2][2] = scl
	mats[3][3] = 1.0
	#adding offset
	matm1 = Matrix(4,4)
	matm1.init(0)
	matm1[0][0] = 1.0
	matm1[1][1] = 1.0
	matm1[2][2] = 1.0
	matm1[3][3] = 1.0
	matm1[0][3] = cp.x
	matm1[1][3] = cp.y
	matm1[2][3] = 0.0
	tmat = matm * mats * matm1
	mat1 = Matrix(4,1)
	mat1[0][0] = v.x
	mat1[1][0] = v.y
	mat1[2][0] = 0.0
	mat1[3][0] = 1.0
	rmat = tmat * mat1
	p.x = rmat[0][0]
	p.y = rmat[1][0]
#	p.z = rmat[2][0]
	return p
