/* $Id: syscalls.h,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#ifndef __SINBY_KAFFE_ECOS_SYSCALL_H__
#define __SINBY_KAFFE_ECOS_SYSCALL_H__

#include <sinby/kaffe/fs_support.h>

int ecos_native_open(const char *path, int flags, int m, int *outfd);
int ecos_native_read(int fd, void* buf, size_t len, ssize_t *out);
int ecos_native_write(int fd, const void* buf, size_t len, ssize_t *out);
int ecos_native_lseek(int f, off_t o, int w, off_t *out);
int ecos_native_close(int fd);
int ecos_native_fstat(int fds,struct stat *buf);
int ecos_native_stat(const char *p, struct stat *st);
int ecos_native_mkdir(const char *p, int m);
int ecos_native_rmdir(const char *p);
int ecos_native_rename(const char *p, const char *q);
int ecos_native_remove(const char *p);

int ecos_native_socket(int domain, int type, int protocol, int *outsock);
int ecos_native_connect(int sock, struct sockaddr* addr, int len, int timeout);
int ecos_native_bind(int sock, struct sockaddr* addr, int len);
int ecos_native_listen(int sock, int backlog);
int ecos_native_accept(int sock, struct sockaddr* addr, int *len, int timeout, int* outsock);
int ecos_native_sock_read(int sock, void* buf, size_t len, int timeout, ssize_t *out);
int ecos_native_recvfrom(int sock, void* buf, size_t len, int flags, struct sockaddr* addr, int* flen, int timeout, ssize_t *out);
int ecos_native_sock_write(int sock, const void* buf, size_t len, ssize_t *out);
int ecos_native_sendto(int sock, const void* buf, size_t len, int flags, const struct sockaddr* addr, int tolen, ssize_t *out);
int ecos_native_setsockopt(int sock, int level, int optname, const void* optval, int optlen);
int ecos_native_getsockopt(int sock, int level, int optname, void* optval, int *optlen);
int ecos_native_getsockname(int sock, struct sockaddr* name, int* namelen);
int ecos_native_getpeername(int sock, struct sockaddr* name, int* namelen);
int ecos_native_sockclose(int sock);
int ecos_native_gethostbyname(const char *host, struct hostent **out);
int ecos_native_gethostbyaddr(const char* addr, int len, int type, struct hostent **out);
int ecos_native_select(int nfd, fd_set* in, fd_set* out, fd_set* ex, struct timeval* tv, int* rout);

int ecos_native_forkexec(char *argv[], char *env[], int ioes[4], int *outpid);
int ecos_native_waitpid(int a, int* b, int c, int* out);
int ecos_native_kill(int a, int b);

#endif /* __SINBY_KAFFE_ECOS_SYSCALL_H__ */
