/* $Id: syscalls.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <network.h>
#include <sys/types.h>
#include <sinby/kaffe/syscalls.h>
#include <pkgconf/kaffe_ecos.h>

#ifndef CYGFUN_KAFFE_ECOS_OTHER_FILE_SYSTEM
#ifdef CYGFUN_KAFFE_ECOS_ECOS_FILE_SYSTEM

int
ecos_native_open(const char *path, int flags, int mode, int *outfd)
{
	*outfd = open(path,flags,mode);
	return (*outfd < 0) ? errno : 0;
}

int
ecos_native_read(int fds, void* buf, size_t len, ssize_t *outlen)
{
	*outlen = read(fds, buf, len);
	return (*outlen < 0) ? errno : 0;
}

int
ecos_native_write(int fds, const void* buf, size_t len, ssize_t *outlen)
{
	*outlen = write(fds, buf, len);
	return (*outlen < 0) ? errno : 0;
}

int
ecos_native_lseek(int fds, off_t offset, int whence, off_t *outoffset)
{
	*outoffset = lseek(fds, offset, whence);
	return (*outoffset < 0) ? errno : 0;
}

int
ecos_native_close(int fds)
{
	return (close(fds) < 0) ? errno : 0;
}

int
ecos_native_fstat(int fds,struct stat *stbuf)
{
	return (fstat(fds, stbuf) < 0) ? errno : 0;
}

int
ecos_native_stat(const char *path, struct stat *stbuf)
{
	return (stat(path, stbuf) < 0) ? errno : 0;
}

int
ecos_native_mkdir(const char *path, int mode)
{
	return (mkdir(path, mode) < 0) ? errno : 0;
}

int
ecos_native_rmdir(const char *path)
{
	return (rmdir(path) < 0) ? errno : 0;
}

int
ecos_native_rename(const char *path, const char *newpath)
{
	return (rename(path, newpath) < 0) ? errno : 0;
}

int
ecos_native_remove(const char *path)
{
	return (unlink(path) < 0) ? errno : 0;
}

#else /* CYGFUN_KAFFE_ECOS_ECOS_FILE_SYSTEM */

int
ecos_native_open(const char *path, int flags, int m, int *outfd)
{
	char *mode;
	FILE *fp;

	switch( flags ) {
	case O_RDONLY :
		mode = "r";
		break;
	default:
		errno = ENOSUPP;
		return errno;
	}
	fp = fopen(path,mode);
	if ( fp == NULL ) {
		return errno;
	}
	*outfd = (int)fp;
	return 0;
}

int
ecos_native_read(int fd, void* buf, size_t len, ssize_t *out)
{
	FILE *fp;

	fp = (FILE*)fd;
	*out = fread(buf,1,len,fp);

	if ( *out == len ) {
		return 0;
	}

	if ( feof(fp) ) {
		return 0;
	}

	return errno;
}

int
ecos_native_write(int fd, const void* buf, size_t len, ssize_t *out)
{
	FILE *fp;

	fp = (FILE*)fd;
	*out = fwrite(buf,1,len,fp);

	if ( *out == len ) {
		return 0;
	} else {
		return errno;
	}
}

int
ecos_native_lseek(int f, off_t o, int w, off_t *out)
{
	return ENOSUPP;
}

int
ecos_native_close(int fd)
{
	if ( fclose((FILE*)fd) == 0 ) {
		return 0;
	} else {
		return errno;
	}
}

int
ecos_native_fstat(int fds,struct stat *buf)
{
	return ENOSUPP;
}

int
ecos_native_stat(const char *p, struct stat *st)
{
	return ENOSUPP;
}

int
ecos_native_mkdir(const char *p, int m)
{
	return ENOSUPP;
}

int
ecos_native_rmdir(const char *p)
{
	return ENOSUPP;
}

int
ecos_native_rename(const char *p, const char *q)
{
	return ENOSUPP;
}

int
ecos_native_remove(const char *p)
{
	return ENOSUPP;
}

#endif /* CYGFUN_KAFFE_ECOS_ECOS_FILE_SYSTEM */
#endif /* CYGFUN_KAFFE_ECOS_OTHER_FILE_SYSTEM */
