/* $Id: jar_driver.h,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

/* $Id: jar_driver.h,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */

#ifndef __SINBY_KAFFE_ECOS_JAR_DRIVER_H__
#define __SINBY_KAFFE_ECOS_JAR_DRIVER_H__

#include <pkgconf/io.h>
#include <cyg/io/io.h>
#include <cyg/io/devtab.h>
#include <sinby/kaffe/md.h>
#include <pkgconf/kaffe_jar.h>
#include <cyg/hal/hal_tables.h>

typedef struct ecos_jar_file {
	long flags;
	const char *name;
	const char *full_path;
	unsigned char *file_start;
	unsigned char *file_end;
	unsigned int len;
	struct cyg_devtab_entry devtab_entry;
} ecos_jar_file_t;

#if SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME 
#define ECOS_JAR_FILE_ENTRY_DEFAULT(_l,_name)  \
   extern unsigned char _binary_ ## _l ## _jar_start[];           \
   extern unsigned char _binary_ ## _l ## _jar_end[];             \
   extern unsigned int _binary_ ## _l ## _jar_size;             \
ecos_jar_file_t _l CYG_HAL_TABLE_ENTRY(jar_table) = {  \
   0,                                                    \
   _name,                                                \
   DEV_JAVA _name,                                       \
   _binary_ ## _l ## _jar_start,                          \
   _binary_ ## _l ## _jar_end,                            \
   (unsigned int)&_binary_ ## _l ## _jar_size,            \
   {0,0,0,0,0,0,0}                                       \
};
#else /* SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME */
#define ECOS_JAR_FILE_ENTRY_DEFAULT(_l,_name)  \
   extern unsigned char binary_ ## _l ## _jar_start[];           \
   extern unsigned char binary_ ## _l ## _jar_end[];             \
   extern unsigned int binary_ ## _l ## _jar_size;             \
ecos_jar_file_t _l CYG_HAL_TABLE_ENTRY(jar_table) = {  \
   0,                                                    \
   _name,                                                \
   DEV_JAVA _name,                                       \
   binary_ ## _l ## _jar_start,                          \
   binary_ ## _l ## _jar_end,                            \
   (unsigned int)&binary_ ## _l ## _jar_size,            \
   {0,0,0,0,0,0,0}                                       \
};
#endif /* SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME */

#define DEV_JAVA "/dev/java/"
#define DEV_JAVA_LEN (sizeof(DEV_JAVA) - 1)
#define ECOS_JAR_FILE_INFO 0x1209

int ecos_get_file_info(char *name,void **startp,void **endp,unsigned int *lenp);
void ecos_jar_classpath_init(void);

extern ecos_jar_file_t __JAR_FILE_ENTRY__[], __JAR_FILE_ENTRY_END__;

#ifdef CYGFUN_KAFFE_JAR_LOAD_JAR_FILE
	int load_jar_file_from_fs(ecos_jar_file_t *);
#if SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME 
#define ECOS_JAR_FILE_RESERVE_ENTRY_DEFAULT(_l,_name)  \
   extern unsigned char _binary_ ## _l ## _jar_start[];           \
   extern unsigned char _binary_ ## _l ## _jar_end[];             \
ecos_jar_file_t _l CYG_HAL_TABLE_ENTRY(jar_table) = {  \
   0,                                                    \
   _name,                                                \
   DEV_JAVA _name,                                       \
   0,                                                    \
   0,                                                    \
   0,                                                    \
   {0,0,0,0,0,0,0}                                       \
};
#else /* SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME */
#define ECOS_JAR_FILE_RESERVE_ENTRY_DEFAULT(_l,_name)  \
   extern unsigned char binary_ ## _l ## _jar_start[];           \
   extern unsigned char binary_ ## _l ## _jar_end[];             \
ecos_jar_file_t _l CYG_HAL_TABLE_ENTRY(jar_table) = {  \
   0,                                                    \
   _name,                                                \
   DEV_JAVA _name,                                       \
   0,                                                    \
   0,                                                    \
   0,                                                    \
   {0,0,0,0,0,0,0}                                       \
};
#endif /* SINBY_MD_NEED_UNDER_SCORE_FOR_FNAME */
#endif /* CYGFUN_KAFFE_JAR_LOAD_JAR_FILE */
#endif /* __SINBY_KAFFE_ECOS_JAR_DRIVER_H__ */
