/* $Id: jar_driver.c,v 1.1.1.1 2004/07/14 05:07:41 ryos Exp $ */
/* Copyright (C) 2000-2004 Sinby Corporation */
/* All Rights Reserved */
/* This project is covered by LGPL */

#include <pkgconf/io.h>
#include <cyg/io/io.h>
#include <cyg/io/devtab.h>
#include <cyg/io/file.h>
#include <cyg/kernel/kapi.h>
#include <cyg/infra/diag.h>
#include <sinby/kaffe/jar_driver.h>

static Cyg_ErrNo jar_bwrite(cyg_io_handle_t handle, const void *buf, cyg_uint32 *len,cyg_uint32);
static Cyg_ErrNo jar_bread(cyg_io_handle_t handle, void *buf, cyg_uint32 *len,cyg_uint32);
static cyg_bool  jar_select(cyg_io_handle_t handle, cyg_uint32 which, CYG_ADDRWORD info);
static Cyg_ErrNo jar_get_config(cyg_io_handle_t handle, cyg_uint32 key, void* buf, cyg_uint32 *len);
static Cyg_ErrNo jar_set_config(cyg_io_handle_t handle, cyg_uint32 key, const void *buf, cyg_uint32 *len);

static bool jar_init(struct cyg_devtab_entry *tab);
static Cyg_ErrNo jar_lookup(struct cyg_devtab_entry **tab,struct cyg_devtab_entry *sub_tab,const char *name);

CYG_HAL_TABLE_BEGIN( __JAR_FILE_ENTRY__, jar_table );
CYG_HAL_TABLE_END( __JAR_FILE_ENTRY_END__, jar_table );

BLOCK_DEVIO_TABLE( jar_devio ,
	jar_bwrite,
	jar_bread,
	jar_select,
	jar_get_config,
	jar_set_config
);

BLOCK_DEVTAB_ENTRY( jar_io, 
             "/dev/java/",
             0,                     // Doesn't depend on a lower level interface
             &jar_devio, 
             jar_init, 
             jar_lookup,           // No initialization/lookup needed
             0);


static bool 
jar_init(struct cyg_devtab_entry *tab)
{
	return true;
}

static Cyg_ErrNo 
jar_bwrite(cyg_io_handle_t handle, const void *_buf, cyg_uint32 *len,cyg_uint32 pos)
{
	return -EINVAL;
}

#define min(a,b) (((a)>(b))?(b):(a))
static Cyg_ErrNo 
jar_bread(cyg_io_handle_t handle, void *_buf, cyg_uint32 *len,cyg_uint32 pos)
{
	cyg_devtab_entry_t *tab = (cyg_devtab_entry_t *)handle;
	ecos_jar_file_t *jp;
	int copylen;

	jp = (ecos_jar_file_t *)tab->priv;
#ifdef DEBUG
	diag_printf("jar_bread len:%d len:%d\n",jp->len,pos);
	diag_printf("jar_bread file_start:%x\n",jp->file_start);
	diag_printf("jar_bread file_start:%x\n",&jp->file_start[pos]);
#endif

	if (( pos < 0 ) || ( (jp->len) <= pos )) {
		return -EINVAL;
	}
	copylen = min((jp->len) , *len);
	memcpy(_buf,&(jp->file_start[pos]),copylen);
	*len = copylen;
	
	return ENOERR;
}

static cyg_bool jar_select(cyg_io_handle_t handle, cyg_uint32 which, CYG_ADDRWORD info)
{
	if ( which == CYG_FREAD ) {
		return true;
	} else {
		return false;
	}
}

static Cyg_ErrNo 
jar_get_config(cyg_io_handle_t handle, cyg_uint32 key, void* buf, cyg_uint32 *len)
{
	cyg_devtab_entry_t *tab = (cyg_devtab_entry_t *)handle;

	switch ( key ) {
	case ECOS_JAR_FILE_INFO:
		if ( *len < sizeof(ecos_jar_file_t)) {
			return -EINVAL;
		}
		*((ecos_jar_file_t *)buf) = *((ecos_jar_file_t *)(tab->priv));
		*len = sizeof(ecos_jar_file_t);
		return ENOERR;
	default:
		return -EINVAL;
	}
}

static Cyg_ErrNo 
jar_set_config(cyg_io_handle_t handle, cyg_uint32 key, const void *buf, cyg_uint32 *len)
{
	//cyg_devtab_entry_t *t = (cyg_devtab_entry_t *)handle;
	return -EINVAL;
}

static Cyg_ErrNo 
jar_lookup(struct cyg_devtab_entry **tab,
	struct cyg_devtab_entry *sub_tab,
	const char *name)
{
	ecos_jar_file_t *jtabp;

#ifdef DEBUG
	diag_printf("\njar_lookup %s\n",name);
	diag_printf("start 0x%08x\n",&__JAR_FILE_ENTRY__[0]); 
	diag_printf("e n d 0x%08x\n",&__JAR_FILE_ENTRY_END__);
#endif
	for (jtabp = &__JAR_FILE_ENTRY__[0]; jtabp != &__JAR_FILE_ENTRY_END__; jtabp++) {
		char *sp,*dp;

		sp = (char *)name;
		dp = jtabp->name;
		//printf("cmp for %s 0x%08x\n",dp,jtabp);
		while ( *dp != 0 ) {
			//printf("cmp %c %c\n",*sp,*dp);
			if ( *sp != *dp ) {
				break;
			}
			sp++;
			dp++;
		}
		if ( *dp == 0 ) {
			break;
		}
	}

	if ( jtabp == &__JAR_FILE_ENTRY_END__ ) {
		return -ENOENT;
	}

#ifdef CYGFUN_KAFFE_JAR_LOAD_JAR_FILE
	if ( jtabp->file_start == NULL ) {
		int eno;
		
		eno = load_jar_file_from_fs(jtabp);
		if ( eno != ENOERR ) {
			return -eno;
		}
	}
#endif

	jtabp->devtab_entry = **tab;
	jtabp->devtab_entry.priv = (void *)jtabp;
	*tab = &(jtabp->devtab_entry);

	return ENOERR;
}

int
ecos_get_file_info(char *name,void **startp,void **endp,unsigned int *lenp) 
{
	int res,len;
	cyg_io_handle_t handle;
	ecos_jar_file_t jtab;
					
	res = cyg_io_lookup(name, &handle);
	if (res != ENOERR) {
		return EINVAL;
	}
	
	len = sizeof(jtab);
	res = cyg_io_get_config(handle,ECOS_JAR_FILE_INFO, &jtab , &len);
	if ( res != ENOERR ) {
		return EINVAL;
	}

	*startp = jtab.file_start;
	*endp = jtab.file_end;
	*lenp = jtab.len;

	return 0;
}

int addClasspath(const char *cp);

void 
ecos_jar_classpath_init(void)
{
	ecos_jar_file_t *jtabp;

	for (jtabp = &__JAR_FILE_ENTRY__[0]; jtabp != &__JAR_FILE_ENTRY_END__; jtabp++) {
		addClasspath(jtabp->full_path);
	}
}

