/* Copyright (c) 2000 Sinby.com
   All Rights Reserved

   This project is covered by the GNU General Public License. */

/* $Id: signal.c,v 1.1.1.1 2000/12/22 07:22:06 ryos Exp $ */

#include "config.h"
#include "debug.h"
#include "config-std.h"
#include "config-signal.h"
#include "config-mem.h"
#include "config-setjmp.h"
#include "jthread.h"
#include "md.h"

#if defined(INTERPRETER)
#define	DEFINEFRAME()		/* Does nothing */
#define	EXCEPTIONPROTO		int sig
#define	EXCEPTIONFRAME(f, c)	/* Does nothing */
#define	EXCEPTIONFRAMEPTR	0
#elif defined(TRANSLATOR)
#define	DEFINEFRAME()		exceptionFrame frame
#define	EXCEPTIONFRAMEPTR	&frame
#endif /* TRANSLATOR */

#define SIG_T   void*

static void nullException(EXCEPTIONPROTO);
static void floatingException(EXCEPTIONPROTO);

static exchandler_t nullHandler;
static exchandler_t floatingHandler;

void
jthread_initexceptions(exchandler_t _nullHandler, exchandler_t _floatingHandler)
{
	nullHandler = _nullHandler;
	floatingHandler = _floatingHandler;

	if (DBGEXPR(EXCEPTION, false, true)) {
		/* Catch signals we need to convert to exceptions */
#if defined(SIGSEGV)
		signal(SIGSEGV, nullException);
#endif
#if defined(SIGBUS)
		signal(SIGBUS, nullException);
#endif
#if defined(SIGFPE)
		signal(SIGFPE, floatingException);
#endif
#if defined(SIGPIPE)
		signal(SIGPIPE, SIG_IGN);
#endif
	}
}

static void
nullException(EXCEPTIONPROTO)
{
	DEFINEFRAME();

	EXCEPTIONFRAME(frame, ctx);
	nullHandler(EXCEPTIONFRAMEPTR);
}

static void
floatingException(EXCEPTIONPROTO)
{
	DEFINEFRAME();

	EXCEPTIONFRAME(frame, ctx);
	floatingHandler(EXCEPTIONFRAMEPTR);
}

void
blockAsyncSignals(void)
{
}

void
unblockAsyncSignals(void)
{
}
