/*
 * X509Extension.java
 *
 * Copyright (c) 2001 University of Utah and the Flux Group.
 * All rights reserved.
 *
 * This file is licensed under the terms of the GNU Public License.
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Contributed by the Flux Research Group, Department of Computer Science,
 * University of Utah, http://www.cs.utah.edu/flux/
 */

package java.security.cert;

import java.util.Set;

public interface X509Extension
{
    Set getCriticalExtensionOIDs();

    byte[] getExtensionValue(String oid);

    Set getNonCriticalExtensionOIDs();

    boolean hasUnsupportedCriticalExtension();
}
