--================================================================================
-- <データベース構築メモ>
-- 「CREATE DATABASE」コマンドは「CREATE TABLE」コマンドと同時実行できない。
-- 「xxxxxxxx」をコンテンツ名に一括置換の上実行する。
--  
--
--  実行例）psql -h 192.168.101.35 -U kakikosystemadmin -f "c:\KakikoDB_tokyo.sql"
--  ※kakikomapdbにconnectすること
--
--  作成日 2006/09/01 by (IIS)S.Komukai
--  更新日
--
--  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
--  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
--================================================================================


-- table: "usertable"

-- drop table "xxxxxxxx_usertable";

create table "xxxxxxxx_usertable"
(
  "userid" varchar(32) not null, -- ユーザid
  "usertype" char(1) not null, -- ユーザ種別
  "mailaddress" varchar(128) not null, -- メールアドレス
  "username" varchar(128), -- ユーザ名称
  "password" varchar(32) not null, -- パスワード
  "statusflg" char(1) not null, -- 状態フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_usertable_pkey" primary key ("userid")
) 
without oids;
alter table "xxxxxxxx_usertable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_usertable"."userid" is 'ユーザid';
comment on column "xxxxxxxx_usertable"."usertype" is 'ユーザ種別';
comment on column "xxxxxxxx_usertable"."mailaddress" is 'メールアドレス';
comment on column "xxxxxxxx_usertable"."username" is 'ユーザ名称';
comment on column "xxxxxxxx_usertable"."password" is 'パスワード';
comment on column "xxxxxxxx_usertable"."statusflg" is '状態フラグ';
comment on column "xxxxxxxx_usertable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_usertable"."updatedatetime" is '更新日時';



-- table: "layerusertable"

-- drop table "xxxxxxxx_layerusertable";

create table "xxxxxxxx_layerusertable"
(
  "userid" varchar(32) not null, -- ユーザid
  "layerid" varchar(32) not null, -- レイヤーid
  "statusflg" char(1) not null, -- 状態フラグ
  "adddatetime" timestamp not null, -- 登録日時
  constraint "xxxxxxxx_layerusertable_pkey" primary key ("userid", "layerid")
) 
without oids;
alter table "xxxxxxxx_layerusertable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_layerusertable"."userid" is 'ユーザid';
comment on column "xxxxxxxx_layerusertable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_layerusertable"."statusflg" is '状態フラグ';
comment on column "xxxxxxxx_layerusertable"."adddatetime" is '登録日時';



-- table: "layerprioritytable"

-- drop table "xxxxxxxx_layerprioritytable";

create table "xxxxxxxx_layerprioritytable"
(
  "priorityorder" int4 not null, -- 優先順位
  "layerid" varchar(32) not null, -- レイヤーid
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_layerprioritytable_pkey" primary key ("priorityorder")
) 
without oids;
alter table "xxxxxxxx_layerprioritytable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_layerprioritytable"."priorityorder" is '優先順位';
comment on column "xxxxxxxx_layerprioritytable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_layerprioritytable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_layerprioritytable"."updatedatetime" is '更新日時';



-- table: "layertable"

-- drop table "xxxxxxxx_layertable";

create table "xxxxxxxx_layertable"
(
  "userid" varchar(32) not null, -- ユーザid
  "layerid" varchar(32) not null, -- レイヤーid
  "layername" varchar(128) not null, -- レイヤー名称
  "layernote" text, -- レイヤーの説明
  "publiclayer" char(1) not null, -- レイヤー公開区分
  "receiptlayer" char(1) not null, -- レイヤー受付区分
  "addattestuser" char(1) not null, -- ユーザ登録認証区分
  "directlink" char(1) not null, -- ダイレクトリンク区分
  "initscale" int4, -- 初期スケール
  "startx" float8, -- 始点x
  "starty" float8, -- 始点y
  "endx" float8, -- 終点x
  "endy" float8, -- 終点y
  "centerscale" int4, -- 中心スケール
  "diffx" float8, -- 差分x
  "diffy" float8, -- 差分y
  "rssfilename" varchar(64) not null, -- rssファイル名
  "statusflg" char(1) not null, -- 状態フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_layertable_pkey" primary key ("userid", "layerid")
) 
without oids;
alter table "xxxxxxxx_layertable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_layertable"."userid" is 'ユーザid';
comment on column "xxxxxxxx_layertable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_layertable"."layername" is 'レイヤー名称';
comment on column "xxxxxxxx_layertable"."layernote" is 'レイヤーの説明';
comment on column "xxxxxxxx_layertable"."publiclayer" is 'レイヤー公開区分';
comment on column "xxxxxxxx_layertable"."receiptlayer" is 'レイヤー受付区分';
comment on column "xxxxxxxx_layertable"."addattestuser" is 'ユーザ登録認証区分';
comment on column "xxxxxxxx_layertable"."directlink" is 'ダイレクトリンク区分';
comment on column "xxxxxxxx_layertable"."initscale" is '初期スケール';
comment on column "xxxxxxxx_layertable"."startx" is '始点x';
comment on column "xxxxxxxx_layertable"."starty" is '始点y';
comment on column "xxxxxxxx_layertable"."endx" is '終点x';
comment on column "xxxxxxxx_layertable"."endy" is '終点y';
comment on column "xxxxxxxx_layertable"."centerscale" is '中心スケール';
comment on column "xxxxxxxx_layertable"."diffx" is '差分x';
comment on column "xxxxxxxx_layertable"."diffy" is '差分y';
comment on column "xxxxxxxx_layertable"."rssfilename" is 'rssファイル名';
comment on column "xxxxxxxx_layertable"."statusflg" is '状態フラグ';
comment on column "xxxxxxxx_layertable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_layertable"."updatedatetime" is '更新日時';


-- sequence: "memotypetable_memotypeid_seq"

-- drop sequence "xxxxxxxx_memotypetable_memotypeid_seq";

create sequence "xxxxxxxx_memotypetable_memotypeid_seq"
  increment 1
  minvalue 1
  maxvalue 9223372036854775807
  start 1
  cache 1;
alter table "xxxxxxxx_memotypetable_memotypeid_seq" owner to kakikosystemadmin;


-- table: "memotypetable"

-- drop table "xxxxxxxx_memotypetable";

create table "xxxxxxxx_memotypetable"
(
  "memotypeid" int4 not null default nextval('"xxxxxxxx_memotypetable_memotypeid_seq"'::regclass), -- メモ種類id
  "layerid" varchar(32) not null, -- レイヤーid
  "memotypename" varchar(128) not null, -- メモ種類名称
  "publicmemotype" char(1) not null, -- メモ種類公開区分
  "authoritymemotype" char(1) not null, -- メモ種類権限区分
  "icontype" char(1) not null, -- アイコン種別
  "icon" varchar(128), -- アイコン
  "ribboncolor" char(6), -- リボン色
  "listtype" char(1) not null, -- 表示種別
  "effectiveterm" timestamp, -- 有効期限
  "deleteflg" char(1), -- 削除フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_memotypetable_pkey" primary key ("memotypeid")
) 
without oids;
alter table "xxxxxxxx_memotypetable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_memotypetable"."memotypeid" is 'メモ種類id';
comment on column "xxxxxxxx_memotypetable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_memotypetable"."memotypename" is 'メモ種類名称';
comment on column "xxxxxxxx_memotypetable"."publicmemotype" is 'メモ種類公開区分';
comment on column "xxxxxxxx_memotypetable"."authoritymemotype" is 'メモ種類権限区分';
comment on column "xxxxxxxx_memotypetable"."icontype" is 'アイコン種別';
comment on column "xxxxxxxx_memotypetable"."icon" is 'アイコン';
comment on column "xxxxxxxx_memotypetable"."ribboncolor" is 'リボン色';
comment on column "xxxxxxxx_memotypetable"."listtype" is '表示種別';
comment on column "xxxxxxxx_memotypetable"."effectiveterm" is '有効期限';
comment on column "xxxxxxxx_memotypetable"."deleteflg" is '削除フラグ';
comment on column "xxxxxxxx_memotypetable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_memotypetable"."updatedatetime" is '更新日時';

-- index: "index_xxxxxxxx_memotypetable_layerid"

-- drop index "index_xxxxxxxx_memotypetable_layerid";

create index "index_xxxxxxxx_memotypetable_layerid"
  on "xxxxxxxx_memotypetable"
  using btree
  (layerid);


-- table: "memodetailtable"

-- drop table "xxxxxxxx_memodetailtable";

create table "xxxxxxxx_memodetailtable"
(
  "memoid" int4 not null, -- メモid
  "memotypeid" int4 not null, -- メモ種類id
  "username" varchar(128) not null, -- ユーザ名称
  "memotitle" varchar(128) not null, -- メモタイトル
  "memotext" text not null, -- 本文
  "mailaddress" varchar(128), -- メールアドレス
  "releteurl" text, -- 関連url
  "imagefile" varchar(128), -- 画像ファイル
  "updatedeletepassword" varchar(4), -- 修正・削除用パスワード
  "accesscount" int4 not null, -- アクセス回数
  "deleteflg" char(1), -- 削除フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_memodetailtable_pkey" primary key ("memoid")
) 
without oids;
alter table "xxxxxxxx_memodetailtable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_memodetailtable"."memoid" is 'メモid';
comment on column "xxxxxxxx_memodetailtable"."memotypeid" is 'メモ種類id';
comment on column "xxxxxxxx_memodetailtable"."username" is 'ユーザ名称';
comment on column "xxxxxxxx_memodetailtable"."memotitle" is 'メモタイトル';
comment on column "xxxxxxxx_memodetailtable"."memotext" is '本文';
comment on column "xxxxxxxx_memodetailtable"."mailaddress" is 'メールアドレス';
comment on column "xxxxxxxx_memodetailtable"."releteurl" is '関連url';
comment on column "xxxxxxxx_memodetailtable"."imagefile" is '画像ファイル';
comment on column "xxxxxxxx_memodetailtable"."updatedeletepassword" is '修正・削除用パスワード';
comment on column "xxxxxxxx_memodetailtable"."accesscount" is 'アクセス回数';
comment on column "xxxxxxxx_memodetailtable"."deleteflg" is '削除フラグ';
comment on column "xxxxxxxx_memodetailtable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_memodetailtable"."updatedatetime" is '更新日時';

-- index: "index_xxxxxxxx_memodetailtable_memotypeid"

-- drop index "index_xxxxxxxx_memodetailtable_memotypeid";

create index "index_xxxxxxxx_memodetailtable_memotypeid"
  on "xxxxxxxx_memodetailtable"
  using btree
  (memotypeid);


-- sequence: "memopositiontable_memoid_seq"

-- drop sequence "xxxxxxxx_memopositiontable_memoid_seq";

create sequence "xxxxxxxx_memopositiontable_memoid_seq"
  increment 1
  minvalue 1
  maxvalue 9223372036854775807
  start 1
  cache 1;
alter table "xxxxxxxx_memopositiontable_memoid_seq" owner to kakikosystemadmin;


-- table: "memopositiontable"

-- drop table "xxxxxxxx_memopositiontable";

create table "xxxxxxxx_memopositiontable"
(
  "memoid" int4 not null default nextval('"xxxxxxxx_memopositiontable_memoid_seq"'::regclass), -- メモid
  "memotypeid" int4 not null, -- メモ種類id
  "longitude" float8 not null, -- 経度(x)
  "latitude" float8 not null, -- 緯度(y)
  "deleteflg" char(1), -- 削除フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_memopositiontable_pkey" primary key ("memoid")
) 
without oids;
alter table "xxxxxxxx_memopositiontable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_memopositiontable"."memoid" is 'メモid';
comment on column "xxxxxxxx_memopositiontable"."memotypeid" is 'メモ種類id';
comment on column "xxxxxxxx_memopositiontable"."longitude" is '経度(x)';
comment on column "xxxxxxxx_memopositiontable"."latitude" is '緯度(y)';
comment on column "xxxxxxxx_memopositiontable"."deleteflg" is '削除フラグ';
comment on column "xxxxxxxx_memopositiontable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_memopositiontable"."updatedatetime" is '更新日時';

-- index: "index_xxxxxxxx_memopositiontable_memotypeid"

-- drop index "index_xxxxxxxx_memopositiontable_memotypeid";

create index "index_xxxxxxxx_memopositiontable_memotypeid"
  on "xxxxxxxx_memopositiontable"
  using btree
  (memotypeid);


-- sequence: "commenttable_commentid_seq"

-- drop sequence "xxxxxxxx_commenttable_commentid_seq";

create sequence "xxxxxxxx_commenttable_commentid_seq"
  increment 1
  minvalue 1
  maxvalue 9223372036854775807
  start 1
  cache 1;
alter table "xxxxxxxx_commenttable_commentid_seq" owner to kakikosystemadmin;


-- table: "commenttable"

-- drop table "xxxxxxxx_commenttable";

create table "xxxxxxxx_commenttable"
(
  "commentid" int4 not null default nextval('"xxxxxxxx_commenttable_commentid_seq"'::regclass), -- コメントid
  "memotypeid" int4 not null, -- メモ種類id
  "memoid" int4 not null, -- メモid
  "highercommentid" int4 not null, -- 上位コメントid
  "username" varchar(128) not null, -- ユーザ名称
  "commenttitle" varchar(128) not null, -- コメントタイトル
  "commenttext" text not null, -- 本文
  "mailaddress" varchar(128), -- メールアドレス
  "releteurl" text, -- 関連url
  "imagefile" varchar(128), -- 画像ファイル
  "updatedeletepassword" char(4), -- 修正・削除用パスワード
  "accesscount" int4 not null, -- アクセス回数
  "deleteflg" char(1), -- 削除フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_commenttable_pkey" primary key ("commentid")
) 
without oids;
alter table "xxxxxxxx_commenttable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_commenttable"."commentid" is 'コメントid';
comment on column "xxxxxxxx_commenttable"."memotypeid" is 'メモ種類id';
comment on column "xxxxxxxx_commenttable"."memoid" is 'メモid';
comment on column "xxxxxxxx_commenttable"."highercommentid" is '上位コメントid';
comment on column "xxxxxxxx_commenttable"."username" is 'ユーザ名称';
comment on column "xxxxxxxx_commenttable"."commenttitle" is 'コメントタイトル';
comment on column "xxxxxxxx_commenttable"."commenttext" is '本文';
comment on column "xxxxxxxx_commenttable"."mailaddress" is 'メールアドレス';
comment on column "xxxxxxxx_commenttable"."releteurl" is '関連url';
comment on column "xxxxxxxx_commenttable"."imagefile" is '画像ファイル';
comment on column "xxxxxxxx_commenttable"."updatedeletepassword" is '修正・削除用パスワード';
comment on column "xxxxxxxx_commenttable"."accesscount" is 'アクセス回数';
comment on column "xxxxxxxx_commenttable"."deleteflg" is '削除フラグ';
comment on column "xxxxxxxx_commenttable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_commenttable"."updatedatetime" is '更新日時';

-- index: "index_xxxxxxxx_commenttable_memotypeid"

-- drop index "index_xxxxxxxx_commenttable_memotypeid";

create index "index_xxxxxxxx_commenttable_memotypeid"
  on "xxxxxxxx_commenttable"
  using btree
  (memotypeid);

-- index: "index_xxxxxxxx_commenttable_memoid"

-- drop index "index_xxxxxxxx_commenttable_memoid";

create index "index_xxxxxxxx_commenttable_memoid"
  on "xxxxxxxx_commenttable"
  using btree
  (memoid);


-- table: "userpersonalinfotable"

-- drop table "xxxxxxxx_userpersonalinfotable";

create table "xxxxxxxx_userpersonalinfotable"
(
  "userid" varchar(32) not null, -- ユーザid
  "layerid" varchar(32) not null, -- レイヤーid
  "layerliststate" char(1) not null, -- レイヤー表示状態区分
  "layerpriorityorder" int4, -- レイヤー優先順位
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_userpersonalinfotable_pkey" primary key ("userid", "layerid")
) 
without oids;
alter table "xxxxxxxx_userpersonalinfotable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_userpersonalinfotable"."userid" is 'ユーザid';
comment on column "xxxxxxxx_userpersonalinfotable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_userpersonalinfotable"."layerliststate" is 'レイヤー表示状態区分';
comment on column "xxxxxxxx_userpersonalinfotable"."layerpriorityorder" is 'レイヤー優先順位';
comment on column "xxxxxxxx_userpersonalinfotable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_userpersonalinfotable"."updatedatetime" is '更新日時';


-- sequence: "imibaseinfotable_imispaceid_seq"

-- drop sequence "xxxxxxxx_imibaseinfotable_imispaceid_seq";

create sequence "xxxxxxxx_imibaseinfotable_imispaceid_seq"
  increment 1
  minvalue 1
  maxvalue 9223372036854775807
  start 1
  cache 1;
alter table "xxxxxxxx_imibaseinfotable_imispaceid_seq" owner to kakikosystemadmin;



-- table: "imibaseinfotable"

-- drop table "xxxxxxxx_imibaseinfotable";

create table "xxxxxxxx_imibaseinfotable"
(
  "imispaceid" int4 not null default nextval('"xxxxxxxx_imibaseinfotable_imispaceid_seq"'::regclass), -- 空間id
  "imispacename" varchar(128) not null, --空間名称
  "userid" varchar(32) not null, --ユーザid
  "publicdivision" char(1) not null, --公開区分
  "viewmode" char(1) not null, --表示モード
  "takememodatetime" timestamp not null, -- メモ取り込み日時
  "memochangeflg" char(1) not null, --メモ変更フラグ
  "memodeletewarnflg" char(1) not null, --メモ削除警告フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_imibaseinfotable_pkey" primary key ("imispaceid")
) 
without oids;
alter table "xxxxxxxx_imibaseinfotable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_imibaseinfotable"."imispaceid" is '空間id';
comment on column "xxxxxxxx_imibaseinfotable"."imispacename" is '空間名称';
comment on column "xxxxxxxx_imibaseinfotable"."userid" is 'ユーザid';
comment on column "xxxxxxxx_imibaseinfotable"."publicdivision" is '公開区分';
comment on column "xxxxxxxx_imibaseinfotable"."viewmode" is '表示モード';
comment on column "xxxxxxxx_imibaseinfotable"."takememodatetime" is 'メモ取り込み日時';
comment on column "xxxxxxxx_imibaseinfotable"."memochangeflg" is 'メモ変更フラグ';
comment on column "xxxxxxxx_imibaseinfotable"."memodeletewarnflg" is 'メモ削除警告フラグ';
comment on column "xxxxxxxx_imibaseinfotable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_imibaseinfotable"."updatedatetime" is '更新日時';



-- table: "imicolorinfotable"

-- drop table "xxxxxxxx_imicolorinfotable";

create table "xxxxxxxx_imicolorinfotable"
(
  "imispaceid" int4 not null, -- 空間id
  "colorid" char(3) not null, --色id
  "categoryname" varchar(64) , --カテゴリ名称
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_imicolorinfotable_pkey" primary key ("imispaceid","colorid")
) 
without oids;
alter table "xxxxxxxx_imicolorinfotable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_imicolorinfotable"."imispaceid" is '空間id';
comment on column "xxxxxxxx_imicolorinfotable"."colorid" is '色id';
comment on column "xxxxxxxx_imicolorinfotable"."categoryname" is 'カテゴリ名称';
comment on column "xxxxxxxx_imicolorinfotable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_imicolorinfotable"."updatedatetime" is '更新日時';


-- table: "imilayertable"

-- drop table "xxxxxxxx_imilayertable";

create table "xxxxxxxx_imilayertable"
(
  "imispaceid" int4 not null, -- 空間id
  "layerid" varchar(32) not null, --レイヤーid
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_imilayertable_pkey" primary key ("imispaceid","layerid")
) 
without oids;
alter table "xxxxxxxx_imilayertable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_imilayertable"."imispaceid" is '空間id';
comment on column "xxxxxxxx_imilayertable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_imilayertable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_imilayertable"."updatedatetime" is '更新日時';


-- table: "imimemopositiontable"

-- drop table "xxxxxxxx_imimemopositiontable";

create table "xxxxxxxx_imimemopositiontable"
(
  "imispaceid" int4 not null, -- 空間id
  "memoid" int4 not null, --メモid
  "coordinatex" float4 not null, --座標x
  "coordinatey" float4 not null, --座標y
  "colorid" char(3), --色id
  "layerid" varchar(32) not null, --レイヤーid
  "memotypeid" int4 not null, --メモ種類id
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "xxxxxxxx_imimemopositiontable_pkey" primary key ("imispaceid","memoid")
) 
without oids;
alter table "xxxxxxxx_imimemopositiontable" owner to kakikosystemadmin;
comment on column "xxxxxxxx_imimemopositiontable"."imispaceid" is '空間id';
comment on column "xxxxxxxx_imimemopositiontable"."memoid" is 'メモid';
comment on column "xxxxxxxx_imimemopositiontable"."coordinatex" is '座標x';
comment on column "xxxxxxxx_imimemopositiontable"."coordinatey" is '座標y';
comment on column "xxxxxxxx_imimemopositiontable"."colorid" is '色id';
comment on column "xxxxxxxx_imimemopositiontable"."layerid" is 'レイヤーid';
comment on column "xxxxxxxx_imimemopositiontable"."memotypeid" is 'メモ種類id';
comment on column "xxxxxxxx_imimemopositiontable"."adddatetime" is '登録日時';
comment on column "xxxxxxxx_imimemopositiontable"."updatedatetime" is '更新日時';



-- Function: "trigger_function_xxxxxxxx_user"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_user"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_user"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From "xxxxxxxx_layertable" Where userid = old.userid;
		Delete From "xxxxxxxx_layerusertable" Where userid = old.userid;
		Delete From "xxxxxxxx_userpersonalinfotable" Where userid = old.userid;
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_user"() OWNER TO kakikosystemadmin;


-- Function: "trigger_function_xxxxxxxx_layer"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_layer"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_layer"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From "xxxxxxxx_layerusertable" Where layerid = old.layerid;
		Delete From "xxxxxxxx_memotypetable" Where layerid = old.layerid;
		Delete From "xxxxxxxx_layerprioritytable" Where layerid = old.layerid;
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_layer"() OWNER TO kakikosystemadmin;


-- Function: "trigger_function_xxxxxxxx_memotype"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_memotype"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_memotype"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From "xxxxxxxx_memopositiontable" Where memotypeid = old.memotypeid;
		Delete From "xxxxxxxx_memodetailtable" Where memotypeid = old.memotypeid;
		Delete From "xxxxxxxx_commenttable" Where memotypeid = old.memotypeid;
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_memotype"() OWNER TO kakikosystemadmin;


-- Function: "trigger_function_xxxxxxxx_imibaseinfo"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_imibaseinfo"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_imibaseinfo"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From "xxxxxxxx_imilayertable" Where imispaceid = old.imispaceid;
		Delete From "xxxxxxxx_imimemopositiontable" Where imispaceid = old.imispaceid;
		Delete From "xxxxxxxx_imicolorinfotable" Where imispaceid = old.imispaceid;
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_imibaseinfo"() OWNER TO kakikosystemadmin;


-- Function: "trigger_function_xxxxxxxx_imilayer"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_imilayer"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_imilayer"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Update "xxxxxxxx_imibaseinfotable" Set memoDeleteWarnFlg = '1' Where imispaceid = old.imispaceid;
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_imilayer"() OWNER TO kakikosystemadmin;


-- Function: "trigger_function_xxxxxxxx_imimemoposition"()

-- DROP FUNCTION "trigger_function_xxxxxxxx_imimemoposition"();

CREATE OR REPLACE FUNCTION "trigger_function_xxxxxxxx_imimemoposition"()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Update "xxxxxxxx_imibaseinfotable" Set memoDeleteWarnFlg = '1' Where imispaceid = old.imispaceid And memoDeleteWarnFlg !=  '1';
	End If;
	Return Null;
END;
$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION "trigger_function_xxxxxxxx_imimemoposition"() OWNER TO kakikosystemadmin;


-- Trigger: trigger_user on "xxxxxxxx_usertable"

-- DROP TRIGGER trigger_user ON "xxxxxxxx_usertable";

--CREATE TRIGGER trigger_user
--  AFTER UPDATE
CREATE TRIGGER trigger_user
  AFTER INSERT OR UPDATE OR DELETE
  ON "xxxxxxxx_usertable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_user"();


-- Trigger: trigger_user_delete on "xxxxxxxx_usertable";

-- DROP TRIGGER trigger_user_delete ON "xxxxxxxx_usertable";

CREATE TRIGGER trigger_user_delete
  AFTER DELETE
  ON "xxxxxxxx_usertable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_user"();


-- Trigger: trigger_layer on "xxxxxxxx_layertable"

-- DROP TRIGGER trigger_layer ON "xxxxxxxx_layertable";

CREATE TRIGGER trigger_layer
  AFTER DELETE
  ON "xxxxxxxx_layertable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_layer"();


-- Trigger: trigger_memotype on "xxxxxxxx_memotypetable"

-- DROP TRIGGER trigger_memotype ON "xxxxxxxx_memotypetable";

CREATE TRIGGER trigger_memotype
  AFTER DELETE
  ON "xxxxxxxx_memotypetable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_memotype"();


-- Trigger: trigger_imibaseinfo on "xxxxxxxx_imibaseinfotable"

-- DROP TRIGGER trigger_imibaseinfo ON "xxxxxxxx_imibaseinfotable";

CREATE TRIGGER trigger_imibaseinfo
  AFTER DELETE
  ON "xxxxxxxx_imibaseinfotable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_imibaseinfo"();


-- Trigger: trigger_imilayer on "xxxxxxxx_imilayertable"

-- DROP TRIGGER trigger_imilayer ON "xxxxxxxx_imilayertable";

CREATE TRIGGER trigger_imilayer
  AFTER DELETE
  ON "xxxxxxxx_imilayertable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_imilayer"();


-- Trigger: trigger_imimemoposition on "xxxxxxxx_imimemopositiontable"

-- DROP TRIGGER trigger_imimemoposition ON "xxxxxxxx_imimemopositiontable";

CREATE TRIGGER trigger_imimemoposition
  AFTER DELETE
  ON "xxxxxxxx_imimemopositiontable"
  FOR EACH ROW
  EXECUTE PROCEDURE "trigger_function_xxxxxxxx_imimemoposition"();


-- Role: "xxxxxxxx_kakikomapadmin"

-- DROP ROLE "xxxxxxxx_kakikomapadmin";

CREATE ROLE "xxxxxxxx_kakikomapadmin" LOGIN
  ENCRYPTED PASSWORD 'xxxxxxxx_kakikomapadmin'
  NOSUPERUSER NOINHERIT NOCREATEDB NOCREATEROLE;


-- Role: "xxxxxxxx_kakikouser"

-- DROP ROLE "xxxxxxxx_kakikouser";

CREATE ROLE "xxxxxxxx_kakikouser" LOGIN
  ENCRYPTED PASSWORD 'xxxxxxxx_kakikouser'
  NOSUPERUSER NOINHERIT NOCREATEDB NOCREATEROLE;


-- revoke all on "xxxxxxxx_usertable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_usertable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_layerusertable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_layerusertable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_layerprioritytable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_layerprioritytable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_layertable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_layertable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_memotypetable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_memotypetable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_memodetailtable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_memodetailtable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_memopositiontable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_memopositiontable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_commenttable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_commenttable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_userpersonalinfotable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_userpersonalinfotable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_imibaseinfotable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_imibaseinfotable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_imicolorinfotable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_imicolorinfotable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_imilayertable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_imilayertable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke all on "xxxxxxxx_imimemopositiontable" from kakikosystemuser CASCADE;
GRANT ALL ON "xxxxxxxx_imimemopositiontable" TO kakikosystemadmin WITH GRANT OPTION;


-- revoke SELECT, INSERT, UPDATE, DELETE on adminusertable from "xxxxxxxx_kakikomapadmin";
GRANT SELECT, INSERT, UPDATE, DELETE ON adminusertable TO "xxxxxxxx_kakikomapadmin";


-- revoke SELECT on adminusertable from "xxxxxxxx_kakikouser";
GRANT SELECT ON adminusertable TO "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on maptable from "xxxxxxxx_kakikomapadmin";
GRANT SELECT, INSERT, UPDATE, DELETE ON maptable TO "xxxxxxxx_kakikomapadmin";


-- revoke SELECT on maptable from "xxxxxxxx_kakikouser";
GRANT SELECT ON maptable TO "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on mapdetailtable from "xxxxxxxx_kakikomapadmin";
GRANT SELECT, INSERT, UPDATE, DELETE ON mapdetailtable TO "xxxxxxxx_kakikomapadmin";


-- revoke SELECT on mapdetailtable from "xxxxxxxx_kakikouser";
GRANT SELECT ON mapdetailtable TO "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on basemaptable from "xxxxxxxx_kakikomapadmin";
GRANT SELECT, INSERT, UPDATE, DELETE ON basemaptable TO "xxxxxxxx_kakikomapadmin";


-- revoke SELECT on basemaptable from "xxxxxxxx_kakikouser";
GRANT SELECT ON basemaptable TO "xxxxxxxx_kakikouser";

-- revoke SELECT on imicolormaster from "xxxxxxxx_kakikomapadmin";
GRANT SELECT ON imicolormaster TO "xxxxxxxx_kakikomapadmin";


-- revoke SELECT on imicolormaster from "xxxxxxxx_kakikouser";
GRANT SELECT ON imicolormaster TO "xxxxxxxx_kakikouser";

-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_usertable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_usertable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_layerusertable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_layerusertable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_layerprioritytable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_layerprioritytable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_layertable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_layertable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_memotypetable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_memotypetable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_memodetailtable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_memodetailtable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_memopositiontable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_memopositiontable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_commenttable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_commenttable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_userpersonalinfotable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_userpersonalinfotable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_imibaseinfotable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_imibaseinfotable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_imicolorinfotable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_imicolorinfotable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_imilayertable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_imilayertable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, INSERT, UPDATE, DELETE on "xxxxxxxx_imimemopositiontable" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, INSERT, UPDATE, DELETE ON "xxxxxxxx_imimemopositiontable" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, UPDATE on "xxxxxxxx_memotypetable_memotypeid_seq" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, UPDATE ON "xxxxxxxx_memotypetable_memotypeid_seq" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, UPDATE on "xxxxxxxx_memopositiontable_memoid_seq" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, UPDATE ON "xxxxxxxx_memopositiontable_memoid_seq" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, UPDATE on "xxxxxxxx_commenttable_commentid_seq" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, UPDATE ON "xxxxxxxx_commenttable_commentid_seq" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";


-- revoke SELECT, UPDATE on "xxxxxxxx_imibaseinfotable_imispaceid_seq" from "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
GRANT SELECT, UPDATE ON "xxxxxxxx_imibaseinfotable_imispaceid_seq" TO "xxxxxxxx_kakikomapadmin", "xxxxxxxx_kakikouser";
