--================================================================================
-- <データベース構築メモ>
-- 「CREATE DATABASE」コマンドが終了してから実行すること。
--  
--
--  実行例）psql -h 192.168.101.35 -U postgres -f -D 作成したデータベース名 "c:\SystemKakikoDB.sql"
--  ※kakikomapdbにconnectすること
--
--  作成日 2006/09/01 by (IIS)K.Shimomura
--  更新日
--
--  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
--  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
--================================================================================

-- Language: plpgsql

-- DROP LANGUAGE plpgsql;

 CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql'
  HANDLER plpgsql_call_handler
  VALIDATOR plpgsql_validator;


-- table: "adminusertable"

-- drop table "adminusertable";

create table "adminusertable"
(
  "userid" varchar(32) not null, -- ユーザid
  "usertype" char(1) not null, -- ユーザ種別
  "mailaddress" varchar(128) not null, -- メールアドレス
  "username" varchar(128), -- ユーザ名称
  "password" varchar(32) not null, -- パスワード
  "statusflg" char(1) not null, -- 状態フラグ
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "adminusertable_pkey" primary key ("userid")
) 
without oids;
alter table "adminusertable" owner to postgres;
comment on column "adminusertable"."userid" is 'ユーザid';
comment on column "adminusertable"."usertype" is 'ユーザ種別';
comment on column "adminusertable"."mailaddress" is 'メールアドレス';
comment on column "adminusertable"."username" is 'ユーザ名称';
comment on column "adminusertable"."password" is 'パスワード';
comment on column "adminusertable"."statusflg" is '状態フラグ';
comment on column "adminusertable"."adddatetime" is '登録日時';
comment on column "adminusertable"."updatedatetime" is '更新日時';

-- table: "maptable"

-- drop table "maptable";

create table "maptable"
(
  "userid" varchar(32) not null, -- ユーザid
  "directryname" varchar(128) not null, -- ディレクトリ名称
  "publiccontents" char(1) not null, -- コンテンツ公開区分
  "publiccontentsdatetime" timestamp, -- コンテンツ公開日付
  "addattestlayer" char(1) not null, -- レイヤー登録認証区分
  "usertype" char(1) not null, -- ユーザ種別
  "contentsname" varchar(128) not null, -- コンテンツ名称
--  "floatingboxcolor" char(6) not null, -- フローティングボックスカラー
--  "floatingboxtransparency" int4 not null, -- フローティングボックス透明度
--  "floatingboxfontcolor" char(6) not null, -- フローティングボックスフォントカラー
  "autologin" char(1) not null, -- 自動ログイン区分
  "layercount" int4 not null, -- レイヤー数
  "memotypecount" int4 not null, -- メモ種類数
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "maptable_pkey" primary key ("userid")
) 
without oids;
alter table "maptable" owner to postgres;
comment on column "maptable"."userid" is 'ユーザid';
comment on column "maptable"."directryname" is 'ディレクトリ名称';
comment on column "maptable"."publiccontents" is 'コンテンツ公開区分';
comment on column "maptable"."publiccontentsdatetime" is 'コンテンツ公開日付';
comment on column "maptable"."addattestlayer" is 'レイヤー登録認証区分';
comment on column "maptable"."usertype" is 'ユーザ種別';
comment on column "maptable"."contentsname" is 'コンテンツ名称';
--comment on column "maptable"."floatingboxcolor" is 'フローティングボックスカラー';
--comment on column "maptable"."floatingboxtransparency" is 'フローティングボックス透明度';
--comment on column "maptable"."floatingboxfontcolor" is 'フローティングボックスフォントカラー';
comment on column "maptable"."autologin" is '自動ログイン区分';
comment on column "maptable"."layercount" is 'レイヤー数';
comment on column "maptable"."memotypecount" is 'メモ種類数';
comment on column "maptable"."adddatetime" is '登録日時';
comment on column "maptable"."updatedatetime" is '更新日時';



-- table: "basemaptable"

-- drop table "basemaptable";

create table "basemaptable"
(
  "directryname" varchar(128) not null, -- ディレクトリ名称
  "usegis" char(1) not null, -- gis有無区分
  "startx" float8 not null, -- 始点x
  "starty" float8 not null, -- 始点y
  "endx" float8 not null, -- 終点x
  "endy" float8 not null, -- 終点y
  "mapsizehorizontal" int4 not null, -- 地図サイズ横
  "mapsizevertical" int4 not null, -- 地図サイズ縦
  "diffx" float8, -- 差分x
  "diffy" float8, -- 差分y
  "movemapsphere" char(1) not null, -- 地図移動範囲
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "basemaptable_pkey" primary key ("directryname")
) 
without oids;
alter table "basemaptable" owner to postgres;
comment on column "basemaptable"."directryname" is 'ディレクトリ名称';
comment on column "basemaptable"."usegis" is 'gis有無区分';
comment on column "basemaptable"."startx" is '始点x';
comment on column "basemaptable"."starty" is '始点y';
comment on column "basemaptable"."endx" is '終点x';
comment on column "basemaptable"."endy" is '終点y';
comment on column "basemaptable"."mapsizehorizontal" is '地図サイズ横';
comment on column "basemaptable"."mapsizevertical" is '地図サイズ縦';
comment on column "basemaptable"."diffx" is '差分x';
comment on column "basemaptable"."diffy" is '差分y';
comment on column "basemaptable"."movemapsphere" is '地図移動範囲';
comment on column "basemaptable"."adddatetime" is '登録日時';
comment on column "basemaptable"."updatedatetime" is '更新日時';



-- table: "mapdetailtable"

-- drop table "mapdetailtable";

create table "mapdetailtable"
(
  "directryname" varchar(128) not null, -- ディレクトリ名称
  "mapnumber" int4 not null, -- 地図番号
  "listname" varchar(128) not null, -- 表示名
  "initiallist" char(1), -- 初期表示
  "outsidereference" char(1), -- 外部参照
  "pixel" float8 not null, -- ピクセル数
--  "localdisposition" varchar(256) not null, -- ローカル配置先
  "adddatetime" timestamp not null, -- 登録日時
  "updatedatetime" timestamp not null, -- 更新日時
  constraint "mapdetailtable_pkey" primary key ("directryname", "mapnumber")
) 
without oids;
alter table "mapdetailtable" owner to postgres;
comment on column "mapdetailtable"."directryname" is 'ディレクトリ名称';
comment on column "mapdetailtable"."mapnumber" is '地図番号';
comment on column "mapdetailtable"."listname" is '表示名';
comment on column "mapdetailtable"."initiallist" is '初期表示';
comment on column "mapdetailtable"."outsidereference" is '外部参照';
comment on column "mapdetailtable"."pixel" is 'ピクセル数';
--comment on column "mapdetailtable"."localdisposition" is 'ローカル配置先';
comment on column "mapdetailtable"."adddatetime" is '登録日時';
comment on column "mapdetailtable"."updatedatetime" is '更新日時';



-- table: "mastertable"

-- drop table "mastertable";

--create table "mastertable"
--(
--  "master" char(2) not null, -- マスタ区分
--  "key1" char(2) not null, -- キー１
--  "key2" char(2) not null, -- キー２
--  "name" varchar(256), -- 名称
--  constraint "mastertable_pkey" primary key ("master", "key1", "key2")
--) 
--without oids;
--alter table "mastertable" owner to postgres;
--comment on column "mastertable"."master" is 'マスタ区分';
--comment on column "mastertable"."key1" is 'キー１';
--comment on column "mastertable"."key2" is 'キー２';
--comment on column "mastertable"."name" is '名称';



-- table: "imicolormaster"

-- drop table "imicolormaster";

create table imicolormaster
(
  colorid char(3) not null, --色id
  colornumber char(6) not null, --色番号
  colorname varchar(32), -- 色名
  piniconname varchar(128) not null, -- ピンアイコン名
  constraint imicolormaster_pkey primary key (colorid)
) 
without oids;
alter table imicolormaster owner to postgres;
comment on column imicolormaster.colorid is '色id';
comment on column imicolormaster.colornumber is '色番号';
comment on column imicolormaster.colorname is '色名';
comment on column imicolormaster.piniconname is 'ピンアイコン名';



-- Function: trigger_function_adminuser()

-- DROP FUNCTION trigger_function_adminuser();

CREATE OR REPLACE FUNCTION trigger_function_adminuser()
  RETURNS "trigger" AS
$BODY$
BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From maptable Where userid = old.userid;
	End If;
	Return Null;
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION trigger_function_adminuser() OWNER TO postgres;


-- Function: trigger_function_user()

-- DROP FUNCTION trigger_function_user();

CREATE OR REPLACE FUNCTION trigger_function_user()
  RETURNS "trigger" AS
$BODY$BEGIN
	If (TG_OP = 'INSERT') Then
		If (new.usertype = '1') Then
			Insert Into adminusertable
				Values (new.userid,
					new.usertype,
					new.mailaddress,
					new.username,
					new.password,
					new.statusflg,
					new.adddatetime,
					new.updatedatetime);
		End If;
	End If;

	If (TG_OP = 'UPDATE') Then
		If (old.usertype = '1') Then
			Update adminusertable Set mailaddress = new.mailaddress,
					username = new.username, password = new.password,
					statusflg = new.statusflg, updatedatetime = new.updatedatetime
								Where userid = old.userid;
		End If;
	End If;

	If (TG_OP = 'DELETE') Then
		If (old.usertype = '1') Then
			Delete From adminusertable Where userid = old.userid;
		End If;
	End If;
	Return Null;
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION trigger_function_user() OWNER TO postgres;


-- Function: trigger_function_map()

-- DROP FUNCTION trigger_function_map();

CREATE OR REPLACE FUNCTION trigger_function_map()
  RETURNS "trigger" AS
$BODY$BEGIN
	If (TG_OP = 'DELETE') Then
		Delete From basemaptable Where directryname = old.directryname;
		Delete From mapdetailtable Where directryname = old.directryname;
	End If;
	Return Null;
END;$BODY$
  LANGUAGE 'plpgsql' VOLATILE;
ALTER FUNCTION trigger_function_map() OWNER TO postgres;


-- Trigger: trigger_adminuser on adminusertable

-- DROP TRIGGER trigger_adminuser ON adminusertable;

CREATE TRIGGER trigger_adminuser
  AFTER DELETE
  ON adminusertable
  FOR EACH ROW
  EXECUTE PROCEDURE trigger_function_adminuser();


-- Trigger: trigger_map on maptable

-- DROP TRIGGER trigger_map ON maptable;

CREATE TRIGGER trigger_map
  AFTER DELETE
  ON maptable
  FOR EACH ROW
  EXECUTE PROCEDURE trigger_function_map();


-- Role: "kakikosystemadmin"

-- DROP ROLE kakikosystemadmin;

CREATE ROLE kakikosystemadmin LOGIN
  ENCRYPTED PASSWORD 'kakikosystemadmin'
  NOSUPERUSER NOINHERIT NOCREATEDB CREATEROLE;

-- revoke all on adminusertable from kakikosystemuser CASCADE;
GRANT ALL ON adminusertable TO kakikosystemadmin WITH GRANT OPTION;

-- revoke all on maptable from kakikosystemuser CASCADE;
GRANT ALL ON maptable TO kakikosystemadmin WITH GRANT OPTION;

-- revoke all on mapdetailtable from kakikosystemuser CASCADE;
GRANT ALL ON mapdetailtable TO kakikosystemadmin WITH GRANT OPTION;

-- revoke all on basemaptable from kakikosystemuser CASCADE;
GRANT ALL ON basemaptable TO kakikosystemadmin WITH GRANT OPTION;

-- revoke all on imicolormaster from kakikosystemuser CASCADE;
GRANT ALL ON imicolormaster TO kakikosystemadmin WITH GRANT OPTION;

-- Default ImiColorMaster Data;
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('000', 'CCCCCC', 'gray',   'gray16.gif');
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('001', 'FFCC99', 'orange', 'orange16.gif');
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('002', 'CCCCFF', 'blue',   'blue16.gif');
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('003', 'FFFFCC', 'yellow', 'yellow16.gif');
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('004', 'CCFFCC', 'green',  'green16.gif');
INSERT INTO imicolormaster (colorid, colornumber, colorname, piniconname) values ('005', 'FFCCCC', 'red',    'red16.gif');
