<?php
/**
* G04-006
* actionselect.php 処理概要：修正処理選択
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)j.hashimoto
* @作成日/作成者：2006/09/01 (IIS)j.hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");					// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsAdminService.class.php");	//DBアクセスサービスクラス
require_once("class/db/service/ContentsViewService.class.php");	//DBアクセスサービスクラス

require_once("class/db/tabledata/LayerData.class.php");			// レイヤー管理テーブル
//require_once("class/db/tabledata/MemoDetailData.class.php");		// メモ詳細管理テーブル
require_once("class/db/tabledata/CommentData.class.php");			// コメント管理テーブル

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

//initialize
$mode			=	"0";		//0:memo,1:comment
$doAction		=	"";			//0:memoedit.php,1:commentedit.php
$userMode		=	"0";		//0:layerAdmin,1:user
$editFlg		=	TRUE;
$delFlg			=	TRUE;

$postPwd		=	"";
$postLayerId	=	"";
$postMemoId		=	"";
$postMemoType	=	"";
$postCommentId	=	"";

//ユーザID取得
if (array_key_exists(DIRECTORY_NAME."_userid", $_SESSION)){
	$userID	=	$_SESSION[DIRECTORY_NAME.'_userid'];
}else{
	//ゲストユーザ
	$userID = "";
}

//POST引数取得
if ($_SERVER["REQUEST_METHOD"] == "POST"){
	if ((array_key_exists( "updDelPwd",		$_POST)) && 
//		(array_key_exists( "layerId", 		$_POST)) && 
		(array_key_exists( "layerid", 		$_POST)) && 
		(array_key_exists( "memoId", 		$_POST)) && 
		(array_key_exists( "memoTypeId",	$_POST)) && 
		(array_key_exists( "commentId",		$_POST)) && 
		(array_key_exists( "longitude",		$_POST)) && 
		(array_key_exists( "latitude",		$_POST))){
		$postPwd		=	trim($_POST["updDelPwd"]);
//		$postLayerId	=	trim($_POST["layerId"]);
		$postLayerId	=	trim($_POST["layerid"]);
		$postMemoId		=	trim($_POST["memoId"]);
		$postMemoType	=	trim($_POST["memoTypeId"]);
		$postCommentId	=	trim($_POST["commentId"]);
		$postLongitude	=	trim($_POST["longitude"]);
		$postLatitude	=	trim($_POST["latitude"]);
	}else{
		//アクセスエラー（引数なし）
		trigger_error($o_resource->getValue("G04006M001"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//METHODエラー
	trigger_error($o_resource->getValue("G04006M001"), E_USER_ERROR);
	exit();
}

//レイヤーIDチェック
if ((empty($postLayerId)) && ($postLayerId == "")){
	//レイヤーID引数エラー
	trigger_error($o_resource->getValue("G04006M001"), E_USER_ERROR);
	exit();
}

//メモIDチェック
if ((empty($postMemoId)) && ($postMemoId == "")){
	//メモID引数エラー
	trigger_error($o_resource->getValue("G04006M001"), E_USER_ERROR);
	exit();
}

//メモ種類IDチェック
if ((empty($postMemoType)) && ($postMemoType == "")){
	//メモ種別引数エラー
	trigger_error($o_resource->getValue("G04006M001"), E_USER_ERROR);
	exit();
}

//コメントIDチェック
if (empty($postCommentId)){
	$mode		=	"0";	//mode=memo
	$doAction	=	"memoedit.php";
}else{
	$mode		=	"1";	//mode=comment
	$doAction	=	"commentedit.php";
}

// レイヤー管理者チェック
if ($userID != ""){
	if (userTypeCheck($userID, $postLayerId)){
		$userMode	=	"0";	//userMode=レイヤー管理者
	}else{
		$userMode	=	"1";	//userMode=一般ユーザ
	}
}else{
	$userMode	=	"1";	//userMode=一般ユーザ
}

if ($userMode == "1"){
	//パスワードチェック
	if (empty($postPwd)){
		//パスワード未入力エラー
		$errorMessage	=	$o_resource->getValue("G04006M002");
		$editFlg		=	FALSE;
		$delFlg			=	FALSE;
	}
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_smarty->assign("header",			$o_resource->getValue("G04006L001"));
//$o_smarty->assign("messeage",		$o_resource->getValue("G04006MXXX"));

// 画面表示

//メモ管理 or コメント管理テーブル存在チェック
$targetID		=	$mode == "0" ? $postMemoId : $postCommentId;
$dataArray		=	array();

if (getData($mode, $targetID, $dataArray, $userID)){

	if ($dataArray["nodeStatus"] == FALSE){
		$errorMessage	=	$o_resource->getValue("G04006M003");
		$delFlg			=	FALSE;
	}

	switch ($dataArray["deleteflg"]){
		case null:
		case "0":
			//一般ユーザパスワード判定
			if ($userMode == "1"){
				if ($dataArray["pwd"] != $postPwd){
					$errorMessage	=	$o_resource->getValue("G04006M002");
					$editFlg		=	FALSE;
					$delFlg			=	FALSE;
				}
			}
			break;
		case "1":
			if ($userMode == "1"){
				$errorMessage	=	$o_resource->getValue("G04006M004");
				$editFlg		=	FALSE;
				$delFlg			=	FALSE;
			}
			break;
		default:
			trigger_error($o_resource->getValue("G04006M005"), E_USER_ERROR);
			exit();
			break;
	}
}else{
	$errorMessage	=	$o_resource->getValue("G04006M004");
	$editFlg		=	FALSE;
	$delFlg			=	FALSE;
}

// メモ修正QuickForm インスタンス化
if ($editFlg){
	$o_formEdit = new HTML_QuickForm("actionEdit", "POST", $doAction);

	$o_formEdit->addElement("hidden",	"memoId",		$postMemoId);
	$o_formEdit->addElement("hidden",	"commentId",	$postCommentId);
	$o_rendererEdit =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_formEdit->accept($o_rendererEdit);
	$o_smarty->assign("memoEdit",		$o_resource->getValue("G04006L002"),	array("class"=>"fs12_black"));
	$o_smarty->assign("formEdit",		$o_rendererEdit->toArray());

	if ($mode == "0"){
		// 位置修正QuickForm インスタンス化
		$o_formMove = new HTML_QuickForm("actionMove", "POST", "positionedit.php");

//		$o_formMove->addElement("submit",	"memoMove",	$o_resource->getValue("G04006L003"),	array("class"=>"fs12_black"));
		$o_formMove->addElement("hidden",	"memoId",		$postMemoId);
		$o_formMove->addElement("hidden",	"longitude",	$postLongitude);
		$o_formMove->addElement("hidden",	"latitude",		$postLatitude);
		$o_rendererMove =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
		$o_formMove->accept($o_rendererMove);
		$o_smarty->assign("memoMove",		$o_resource->getValue("G04006L003"),	array("class"=>"fs12_black"));
		$o_smarty->assign("formMove",		$o_rendererMove->toArray());
	}
}

if ($delFlg){
	// メモ削除QuickForm インスタンス化
	$o_formDele = new HTML_QuickForm("actionDele", "POST", "memodelete.php");

	$o_formDele->addElement("hidden",	"memoId",		$postMemoId);
	$o_formDele->addElement("hidden",	"commentId",	$postCommentId);
	$o_rendererDele =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_formDele->accept($o_rendererDele);
	$o_smarty->assign("memoDele",		$o_resource->getValue("G04006L004"),	array("class"=>"fs12_black"));
	$o_smarty->assign("formDele",		$o_rendererDele->toArray());
}

$o_smarty->assign("errorMessage",	$errorMessage);
//$o_smarty->assign("back",			$o_resource->getValue("G04006L006"),	array("onclick"=>"history.back();", "class"=>"fs12_black"));
$o_smarty->assign("back",			$o_resource->getValue("G04006L006"),	array("onclick"=>"./memodetail.php?memoid={$postMemoId}", "class"=>"fs12_black"));
$o_smarty->assign("targetID",		$postMemoId);

$tplName = DIRECTORY_NAME . "/actionselect.tpl";

// DB 開放
//$o_db->disconnect();

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：レイヤー管理者チェック
* 処理詳細	：一般ユーザ、レイヤー管理者の判定
*
* @引数		：	(I) layerID		- レイヤーID）
*			：	(I) memoID		- メモID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function userTypeCheck($userid, $layerid){

	$adminService = new ContentsAdminService(DIRECTORY_NAME);

	$layerRecord = $adminService->getLayerInfoData($userid,$layerid);

	if (is_null($layerRecord)){
		return FALSE;
	}else{
		return TRUE;
	}
}


/**
* 関数概要	：対象データ取得
* 処理詳細	：メモ／コメントデータ取得
*
* @引数		：	(I) mode		- 0:メモ or 1:コメント
*				(I) id			- メモID or コメントID
*				(O) dataArray	- データ配列
*				(I) userId		- ユーザID
*
* @戻値		：	boolean  TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getData($mode, $id, &$dataArray, $userId){
	$dataArray	=	array();
	//データ取得処理
	if ($mode == "0"){
		//メモデータ取得
		$dataArray	=	getMemoData($id, $userId);
	}else{
		//コメント取得
		$dataArray	=	getCommentData($id);
	}

	if (is_null($dataArray) == FALSE){
		$dataArray["nodeStatus"] = checkChildNode($mode, $id);
		return TRUE;
	}else{
		return FALSE;
	}
}

/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*               (I) userId  - ユーザID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getMemoData($memoid, $userId){

	$viewService		=	new ContentsViewService(DIRECTORY_NAME);
	$memoDetailRecord	=	new MemoDetailPositionTypeData;
	$memoDetailRecord	=	$viewService->getOneMemoDetailViewDataAuth($memoid, $userId);
	
	if (is_null($memoDetailRecord)){
		trigger_error("メモ取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	$memoData	=	array();

	$memoData	=	array(
						"id"			=> $memoDetailRecord->getMemoID(),
						"pwd"			=> $memoDetailRecord->getUpdateDeletePassword_d(),
						"deleteflg"		=> $memoDetailRecord->getDeleteFlg_d(),
						"nodeStatus"	=> ""
					);

	return $memoData;
}

/**
* 関数概要	：コメントデータ取得
* 処理詳細	：コメントデータ取得
*
* @引数		：	(I) memoid	- メモID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentData($commentid){

	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
//	$commentRecord	=	new CommentData;
	$commentRecord	=	new MemoDetailPositionTypeData;
	$commentRecord	=	$viewService->getOneCommentData($commentid);
	
	if (is_null($commentRecord)){
		trigger_error("コメント取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	$commentData	=	array();

	$commentData	=	array(
							"id"			=> $commentRecord->getCommentID(),
							"pwd"			=> $commentRecord->getUpdateDeletePassword_c(),
							"deleteflg"		=> $commentRecord->getDeleteFlg_c(),
							"nodeStatus"	=> ""
						);

	return $commentData;	
}

/**
* 関数概要	：子ノード存在チェック（メモ）
* 処理詳細	：コメントデータ存在チェック
*
* @引数		：	(I) mode		- 0:メモ or 1:コメント
*				(I) id			- メモID or コメントID
*
* @戻値		：	boolean			- TRUE/FALSE
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function checkChildNode($mode, $id){
	$viewService	=	new ContentsViewService(DIRECTORY_NAME);

	//データ取得処理
	if ($mode == "0"){
		if ($viewService->checkExistChildCommentByMemoId($id)){
			return	FALSE;
		}
	}else{
		if ($viewService->checkExistChildCommentByCommentId($id)){
			return	FALSE;
		}
	}

	return	TRUE;
}

?>