<?php
/**
* G04-007
* memoregist.php 処理概要：コメント修正処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)J.Hashimoto
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

//require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");
require_once("class/db/tabledata/CommentData.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");
require_once("class/xml/RSSController.class.php");			// RSS

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

$errorMessage	= "";
$pageFlg		= 0;
$tplName		= "";
$errorFileSize	= "";
$errorFileType	= "";
$filecheck		= TRUE;

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

//POST引数取得
if ($_SERVER["REQUEST_METHOD"] == "POST"){
	if ((array_key_exists( "memoId",	$_POST)) && 
		(array_key_exists( "commentId",	$_POST))){
		$postMemoId		=	trim($_POST["memoId"]);
		$postCommentId	=	trim($_POST["commentId"]);

		// 詳細情報を取得
		$commentRecord = new MemoDetailPositionTypeData;
		$commentRecord = getCommentData($postCommentId);
		if ($commentRecord == FALSE){
			//対象データなし
			trigger_error($o_resource->getValue("G04007M020"), E_USER_ERROR);
			exit();
		}
	}else{
		//アクセスエラー（引数なし）
		trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
    	exit(-1);
	}
}else{
	//METHODエラー
	trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
	exit();
}

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("commentEdit", "POST", $_SERVER["PHP_SELF"], "_self");

// 項目セット
$o_form->addElement("header",   "header",    $o_resource->getValue("G04007L001"));
$o_form->addElement("text",     "name",      $o_resource->getValue("G04007L002"), array("size"=>"40", "maxlength"=>"32", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "title",     $o_resource->getValue("G04007L003"), array("size"=>"40", "maxlength"=>"20", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("textarea", "text",      $o_resource->getValue("G04007L004"), array("maxlength"=>"500", "autocomplete"=>"off", "class"=>"", "cols"=>"45", "rows"=>"10"));
$o_form->addElement("text",     "mail",      $o_resource->getValue("G04007L005"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));
$o_form->addElement("text",     "url",       $o_resource->getValue("G04007L006"), array("size"=>"40", "maxlength"=>"128", "autocomplete"=>"off", "class"=>""));

$o_form->addElement("file",     "imgFile",   $o_resource->getValue("G04007L007"), array("autocomplete"=>"off", "class"=>""));
$o_form->addElement("password", "updDelPwd", $o_resource->getValue("G04007L008"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>""));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("name",      $o_resource->getValue("G04007M001"), "required");
$o_form->addRule("name",  	  $o_resource->getValue("G04007M002"), "maxlength_valid",   32);
$o_form->addRule("title",     $o_resource->getValue("G04007M003"), "required");
$o_form->addRule("title",  	  $o_resource->getValue("G04007M004"), "maxlength_valid",	20);
$o_form->addRule("text",  	  $o_resource->getValue("G04007M005"), "maxlength_valid",	500);
$o_form->addRule("mail",  	  $o_resource->getValue("G04007M006"), "email",	null);
$o_form->addRule("mail",	  $o_resource->getValue("G04007M007"), "maxlength_valid",	128);
$o_form->addRule("url",  	  $o_resource->getValue("G04007M008"), "regex",	"/^(http|https)?(:\/\/([\w-]+\.)+[\w-]+(\/[\w- .\/?%&=]*)?)/");
$o_form->addRule("url",	      $o_resource->getValue("G04007M009"), "maxlength_valid",	128);
$o_form->addRule("updDelPwd", $o_resource->getValue("G04007M010"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("updDelPwd", $o_resource->getValue("G04007M011"), "maxlength_valid",	4);

//画像ファイルへの指示用Radioボタン生成
if ($commentRecord->getImageFile_c() != ""){
	$o_form->addElement("text",     "currentImg",$o_resource->getValue("G04007L012"), array("autocomplete"=>"off", "class"=>"fs12_black"));
	$radioArray	=	array(
						"nc"	=>	$o_resource->getValue("G04007L014"),
						"del"	=>	$o_resource->getValue("G04007L016"),
						"upd"	=>	$o_resource->getValue("G04007L017")
					);
}else{
	$o_form->addElement("text",     "currentImg",$o_resource->getValue("G04007L013"), array("autocomplete"=>"off", "class"=>"fs12_black"));
	$radioArray	=	array(
						"nc"	=>	$o_resource->getValue("G04007L014"),
						"ins"	=>	$o_resource->getValue("G04007L015")
						);
}

// 登録ボタン
if (array_key_exists( "commentEdit", $_POST)){

	//画像ファイル指示状態チェック
	switch($_POST["imgSts"]){
		case "nc":
		case "del":
			break;
		case "ins":
		case "upd":
			// アップロードファイルチェック
			if($_FILES['imgFile']['name'] != ""){
				if($_FILES['imgFile']['size'] > 204800){
					$errorFileSize = $o_resource->getValue("G04007M016");
					$filecheck = FALSE;
				}else if(in_array($_FILES['imgFile']['type'], explode(",", UPLOAD_MIME_TYPE)) == FALSE){
					$errorFileType = $o_resource->getValue("G04007M017");
					$filecheck = FALSE;
				}
		    }else{
		    	$errorFileSize = $o_resource->getValue("G04007M018");
		    	$filecheck = FALSE;
		    }
			break;
		default:
			//アクセスエラー（引数なし）
			trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
    		exit(-1);
			break;
	}

    // チェックOK
    if (($o_form->validate()) && ($filecheck)) {
		$pageFlg = 1;

		$uploadDir = "./img/memo/";
		$uploadfileName	=	"";

		switch($_POST["imgSts"]){
			//画像変更なし
			case "nc":
				$uploadfileName = $commentRecord->getImageFile_c();
				break;
			//画像追加
			case "ins":
				list($msec, $sec) = explode(" ", microtime()); 
				// 軽度にファイル名を暗号化
//				$filename = str_replace("/", "_", crypt(date('YmdHis', time()).(((float)$msec)*1000000), "kakikomap"));
				$filename = date('YmdHis', time()).(((float)$msec)*1000000);

				if($_FILES['imgFile']['name'] != ""){
				    $pathArray = pathinfo($_FILES['imgFile']['name']);
					$uploadfileName = $filename.".".$pathArray['extension'];
					if(is_uploaded_file($_FILES["imgFile"]["tmp_name"])){
						if(move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName) == FALSE){
							print("File Upload Error!!".$uploadDir.$uploadfileName);
						}
					}else{
						trigger_error("Illegal file!!", E_USER_ERROR);
					    exit(-1);
					}
				}
				break;
			//画像変更
			case "upd":
				$uploadfileName = $commentRecord->getImageFile_c();
				if (empty($uploadfileName) == FALSE){
					if (file_exists($uploadDir . $commentRecord->getImageFile_c())){
						unlink($uploadDir . $commentRecord->getImageFile_c());
					}

					if($_FILES['imgFile']['name'] != ""){
						if(is_uploaded_file($_FILES["imgFile"]["tmp_name"])){
							if(!move_uploaded_file($_FILES['imgFile']['tmp_name'], $uploadDir.$uploadfileName)){
								print("File Upload Error!!".$uploadDir.$uploadfileName);
							}    
						}else{
							trigger_error("Illegal file!!", E_USER_ERROR);
						    exit(-1);
						}
					}
				}
				break;
			//画像削除
			case "del":
				$uploadfileName = $commentRecord->getImageFile_c();
				if (empty($uploadfileName) == FALSE){
					if (file_exists($uploadDir . $commentRecord->getImageFile_c())){
						unlink($uploadDir . $commentRecord->getImageFile_c());
					}
				}
				$uploadfileName = "";
				break;
			default:
				//アクセスエラー（引数なし）
				trigger_error($o_resource->getValue("G04007M019"), E_USER_ERROR);
	    		exit(-1);
				break;
		}

        // **************************
        // DB登録処理実装部
        // **************************

		//更新列の設定
		// コメント情報
		$targetComment = new CommentData();
		$targetComment->setCommentID(WHERE_KEY);
		$targetComment->setUserName(VAL_TARGET);
		$targetComment->setCommentTitle(VAL_TARGET);
		$targetComment->setCommentText(VAL_TARGET);
		$targetComment->setMailAddress(VAL_TARGET);
		$targetComment->setReleteURL(VAL_TARGET);
		$targetComment->setImageFile(VAL_TARGET);
		$targetComment->setUpdateDeletePassword(VAL_TARGET);
		$targetComment->setAccessCount(VAL_TARGET);
		$targetComment->setUpdateDateTime(VAL_TARGET);

		$comment = new CommentData();
		$comment->setCommentID($_POST["commentId"]);
		$comment->setUserName($_POST['name']);
		$comment->setCommentTitle($_POST['title']);
		$comment->setCommentText($_POST['text']);
		$comment->setMailAddress($_POST['mail']);
		$comment->setReleteURL($_POST['url']);
		$comment->setImageFile($uploadfileName);
		$comment->setUpdateDeletePassword($_POST['updDelPwd']);
		$comment->setAccessCount($commentRecord->getAccessCount_c() + 1);
		$comment->setUpdateDateTime(date('Y/m/d H:i:s'));

		// UPDATE
		$viewService = new ContentsViewService(DIRECTORY_NAME);

		if ($viewService->updateCommentDataByKey($targetComment, $comment) == FALSE){
			trigger_error("Comment Error", E_USER_ERROR);
			exit(-1);
		}
 
 		// RSS出力
		$rss = new RSSController($commentRecord->getLayerID(), DIRECTORY_NAME);
		if(!$rss->writeRssFile()){
			trigger_error("RSS Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}else{

	// 入力項目のデフォルトをセット
	$o_form->setDefaults(
		array(
	    	"name"      => $commentRecord->getUserName_c(),
	    	"title"     => $commentRecord->getCommentTitle(),
	    	"text"      => $commentRecord->getCommentText(),
	    	"mail"      => $commentRecord->getMailAddress_c(),
	    	"url"       => $commentRecord->getReleteURL_c(),
	    	"imgFile"   => $commentRecord->getImageFile_c(),
	    	"updDelPwd" => $commentRecord->getUpdateDeletePassword_c()
		)
	);
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
 	$o_form->addElement("hidden", "memoId", $postMemoId);
 	$o_form->addElement("hidden", "commentId", $postCommentId);
    $o_form->addElement("submit", "commentEdit", $o_resource->getValue("G04007L010"), array("class"=>"fs12_black"));
    $o_form->addElement("button", "close",  $o_resource->getValue("G04007L011"), array("onclick"=>"window.close();", "class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());
	$labelArray = array(
      "label01"  => $o_resource->getValue("G04007M012"),
      "label02"  => $o_resource->getValue("G04007M013"),
      "label03"  => $o_resource->getValue("G04007M014"),
      "errorFileSize" => $errorFileSize,
      "errorFileType" => $errorFileType
	);

	$o_smarty->assign("radioArray", $radioArray);
	$o_smarty->assign("labelArray", $labelArray);
	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME."/commentedit.tpl";

} else {
    // 完了画面
    $tplName = DIRECTORY_NAME."/memoclose.tpl";
}

$o_smarty->display($tplName);

unset($_POST);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要	：メモデータ取得
* 処理詳細	：メモデータ取得
*
* @引数		：	(I) memoid	- メモID
*
* @戻値		：	array		- データ配列
*
* @作成日/作成者：2006/09/01 (IIS)J.Hashimoto
* @更新日/更新者：
* @更新内容	：
*/
function getCommentData($commentid){
 	$viewService	=	new ContentsViewService(DIRECTORY_NAME);
	$commentRecord	=	new MemoDetailPositionTypeData;
	$commentRecord	=	$viewService->getOneCommentData($commentid);
	
	if (is_null($commentRecord)){
		trigger_error("コメント取得エラー。暫定版！！！", E_USER_ERROR);
		return FALSE;
	}

	return $commentRecord;

}

?>