<?php
/**
* createjsonimidata.php 処理概要：意味空間用JSONデータ生成処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/common/MapController.class.php");
require_once("class/common/ImiMapController.class.php");
require_once("class/db/service/ImiViewService.class.php");

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
$s_UserType = null;
$s_ImiSpaceId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$s_ImiSpaceId = $_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
}else{
	trigger_error("Illegal Access!!", E_USER_ERROR);
	exit(-1);
}

$ichiMapController = null;
$imiMapController = null;
if(isset($_POST['mapext'])){
	$arr = explode(" ", $_POST['mapext']);
	$ichiMapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], $_POST['mapType']);
	$imiMapController = new ImiMapController($arr[0], $arr[1], $arr[2], $arr[3], $_POST['area_width'], $_POST['area_height']);
}


// 検索条件の設定
$searchNew = null;
$searchWord = null;
$searchFromDate = null;
$searchToDate = null;
if($_POST['searchNew'] != ""){
	$searchNew = $_POST['searchNew'];
}
if($_POST['searchWord'] != ""){
	$searchWord = $_POST['searchWord'];
}
$searchFromDate = convertSearchDate($_POST['searchFromDate']);
if($searchFromDate === false){
	exit(-1);	
}
$searchToDate = convertSearchDate($_POST['searchToDate']);
if($searchToDate === false){
	exit(-1);	
}
$searchArray = array(
	"limit" => $searchNew,
	"from"  => $searchFromDate,
	"to"    => $searchToDate,
	"word"  => $searchWord
);

// サービスのインスタンス化
$service = new ImiViewService(DIRECTORY_NAME);
$recordData = $service->getImiMemoViewData($s_ImiSpaceId, $s_UserId, $searchArray);


$memoList = array();
// JSONデータ生成
foreach($recordData as $data){
	$coordinatesIchi = $ichiMapController->get_JsFromCoordinates($_POST['area_width'], $_POST['area_height'],
										 $data->getLongitude(), $data->getLatitude());

	$coordinatesImi = $imiMapController->get_JsFromCoordinates($data->getCoordinateX(), $data->getCoordinateY());

	$memotitle = $data->getMemoTitle();
	// 付箋に表示する文字数の制限
	$maxlen = 10;
	if(mbstrlen($memotitle) > $maxlen){ 
        $memotitle = mb_substr($memotitle, 0, $maxlen); 
        $memotitle .= "･･･"; 
    }
	
	// アイコンタイプでアドレス切り替え(位置空間)
	$iconPath = "";
	if($data->getIconType() == 0){
		$iconPath = "../../img/icon/".$data->getIcon();
	}else{
		$iconPath = "./img/icon/".$data->getIcon();
	}
	array_push($memoList, array(
								'layerid' => $data->getLayerID(), 
								'ribbon' => $data->getRibbonColor(), 
								'icon' => $iconPath, 
								'memotypeid' => $data->getMemoTypeID(), 
								'memoid' => $data->getMemoID(), 
								'longitude' => $coordinatesIchi[0], 
								'latitude' => $coordinatesIchi[1], 
								'memotitle' => $memotitle,
								'coordinatex' => $coordinatesImi[0],
								'coordinatey' => $coordinatesImi[1],
								'colorid' => $data->getColorID(),
								'imiribbon' => $data->getColorNumber(),
								'imiicon' =>  "../../img/icon/".$data->getPinIconName()
								));
}
// php_json でデータ作成
$jsonData = json_encode($memoList);
// JSONデータの出力
print($jsonData);
?>
