<?php
/**
* createjsonmemodata.php 処理概要：メモJSONデータ生成処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/common/MapController.class.php");
require_once("class/db/service/ContentsViewService.class.php");

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
}

$mapController = null;
if(isset($_POST['mapext'])){
	$arr = explode(" ", $_POST['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], $_POST['mapType']);
}


// 検索条件の設定
$searchNew = null;
$searchWord = null;
$searchFromDate = null;
$searchToDate = null;
if($_POST['searchNew'] != ""){
	$searchNew = $_POST['searchNew'];
}
if($_POST['searchWord'] != ""){
	$searchWord = $_POST['searchWord'];
}
$searchFromDate = convertSearchDate($_POST['searchFromDate']);
if($searchFromDate === false){
	exit(-1);	
}
$searchToDate = convertSearchDate($_POST['searchToDate']);
if($searchToDate === false){
	exit(-1);	
}
$searchMapExt = null;
if(isset($_POST['mapext'])){
	$searchMapExt = explode(" ", $_POST['mapext']);
}
$searchArray = array(
	"limit" => $searchNew,
	"from"  => $searchFromDate,
	"to"    => $searchToDate,
	"word"  => $searchWord,
	"minx"  => $searchMapExt[0],
	"maxx"  => $searchMapExt[2],
	"miny"  => $searchMapExt[1],
	"maxy"  => $searchMapExt[3]
);

// サービスのインスタンス化
$service = new ContentsViewService(DIRECTORY_NAME);

$recordData = null;
if($s_UserId == null){
	$recordData = $service->getMapViewMemoDataByGuest($searchArray);
}else{
	$recordData = $service->getMapViewMemoDataByUser($s_UserId, $searchArray);
}

$memoList = array();
// JSONデータ生成
foreach($recordData as $data){
	$coordinates = $mapController->get_JsFromCoordinates($_POST['area_width'], $_POST['area_height'],
										 $data->getLongitude(), $data->getLatitude());

	$memotitle = $data->getMemoTitle();
	// 付箋に表示する文字数の制限
	$maxlen = 10;
	if(mbstrlen($memotitle) > $maxlen){ 
        $memotitle = mb_substr($memotitle, 0, $maxlen); 
        $memotitle .= "･･･"; 
    }
	
	// アイコンタイプでアドレス切り替え
	$iconPath = "";
	if($data->getIconType() == 0){
		$iconPath = "../../img/icon/".$data->getIcon();
	}else{
		$iconPath = "./img/icon/".$data->getIcon();
	}
	array_push($memoList, array(
								'layerid' => $data->getLayerID(), 
								'ribbon' => $data->getRibbonColor(), 
								'icon' => $iconPath, 
								'memotypeid' => $data->getMemoTypeID(), 
								'memoid' => $data->getMemoID(), 
								'longitude' => $coordinates[0], 
								'latitude' => $coordinates[1], 
								'memotitle' => $memotitle
								));
}
// php_json でデータ作成
$jsonData = json_encode($memoList);
// JSONデータの出力
print($jsonData);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################

?>
