<?php
/**
* createMapImage.php 地図画像生成
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("function/KakikoContentsCommon.php");
require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み
require_once("class/db/service/ContentsViewService.class.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

$dispExt = "";
$mapNo = "";
$LOG->info($_GET['mapext']);
if(isset($_GET['mapext'])){
	$dispExt = $_GET['mapext'];
	$mapNo = $_GET['scale'];
//print($mapNo);
}else{
	// 暫定実装(m単位)
	trigger_error("error!!");
}

// 各画像の１メートルあたりのピクセル数を算出(l1,m1)
//ここで使用するのはl1系、5401*5401 ちなみにm1系は1801*1801


$viewService = new ContentsViewService(DIRECTORY_NAME);
$mapDetailData = $viewService->getMapDetailData($mapNo);

$pixpermer = $mapDetailData->getPixel(); // 1mあたりのピクセル数(DB取得)

$arr = explode(" ", $dispExt);
$px_minx = $arr[0];
$px_miny = $arr[1];

// 画像表示サイズを取得
$disp_width  = MAP_WIDTH;
$disp_height = MAP_HEIGHT;

// 左上の座標が存在する画像ファイルを確定し、４枚の画像ファイルを１枚に結合する。
// ┌─┬─┐
// │１│２│
// ├─┼─┤
// │３│４│
// └─┴─┘
$filepath = "./img/map/".$mapNo."/";

// 左上の座標が存在する地図のNo（上図１に該当）を割り出す
$baseFileX = $px_minx / round($disp_width / $pixpermer);
$baseFileY = $px_miny / round($disp_height / $pixpermer);

if($baseFileX >= 0){
	$baseFileX = floor($baseFileX);
}else{
	// マイナスの場合は補正する
	$baseFileX = -ceil(abs($baseFileX));
}
if($baseFileY >= 0){
	$baseFileY = floor($baseFileY);
}else{
	// マイナスの場合は補正する
	$baseFileY = -ceil(abs($baseFileY));
}

// 読み込むファイル名（パス）を確定する
$readFileName1 = $filepath."slice_".$baseFileX."_".$baseFileY.".xxx";
$readFileName2 = $filepath."slice_".($baseFileX + 1)."_".$baseFileY.".xxx";
$readFileName3 = $filepath."slice_".$baseFileX."_".($baseFileY + 1).".xxx";
$readFileName4 = $filepath."slice_".($baseFileX + 1)."_".($baseFileY + 1).".xxx";

// 画像４枚を結合した左上から切り出し開始点への距離
$cutStartX = ($px_minx % ($disp_width / $pixpermer)) * $pixpermer;
//$LOG->debug("cutStartX : ".$cutStartX." px_minx : ".$px_minx." disp_width : ".$disp_width." pixpermer : ".$pixpermer);

if($cutStartX < 0){
	// 切り出し位置がマイナスの場合は補正する
	$cutStartX = $disp_width + $cutStartX;
}
$cutStartY = ($px_miny % ($disp_height / $pixpermer)) * $pixpermer;
if($cutStartY < 0){
	// 切り出し位置がマイナスの場合は補正する
	$cutStartY = $disp_height + $cutStartY;
}
$LOG->debug("mapNo1 X,Y : ".$baseFileX." ".$baseFileY."   cut X,Y : ".$cutStartX." ".$cutStartY);

// 結合対象の４枚の画像を読み込む
$src_image1 = null;
$src_image2 = null;
$src_image3 = null;
$src_image4 = null;
// 必ず存在するファイルで画像の種類を割り出す
$imagesize = getimagesize($filepath."slice_0_0.xxx");
switch($imagesize[2]){
	case 1: // gif
		header("Content-Type:image/gif");
		if(file_exists($readFileName1))	$src_image1 = imagecreatefromgif($readFileName1);
		if(file_exists($readFileName2))	$src_image2 = imagecreatefromgif($readFileName2);
		if(file_exists($readFileName3))	$src_image3 = imagecreatefromgif($readFileName3);
		if(file_exists($readFileName4))	$src_image4 = imagecreatefromgif($readFileName4);
		break;
	case 2: // jpg
		header("Content-Type:image/jpg");
		if(file_exists($readFileName1))	$src_image1 = imagecreatefromjpeg($readFileName1);
		if(file_exists($readFileName2))	$src_image2 = imagecreatefromjpeg($readFileName2);
		if(file_exists($readFileName3))	$src_image3 = imagecreatefromjpeg($readFileName3);
		if(file_exists($readFileName4))	$src_image4 = imagecreatefromjpeg($readFileName4);
		break;
	case 3: // png
		header("Content-Type:image/png");
		if(file_exists($readFileName1))	$src_image1 = imagecreatefrompng($readFileName1);
		if(file_exists($readFileName2))	$src_image2 = imagecreatefrompng($readFileName2);
		if(file_exists($readFileName3))	$src_image3 = imagecreatefrompng($readFileName3);
		if(file_exists($readFileName4))	$src_image4 = imagecreatefrompng($readFileName4);
		break;
	default:
		$LOG->crit("This file type not supported!!");
}

// 白の空キャンバスを作成
$four_image = ImageCreateTrueColor($disp_width * 2, $disp_height * 2);
imagefill($four_image, 0, 0, 0xFFFFFF);

// 画像４枚を統合
if($src_image1)	imagecopy($four_image, $src_image1, 0, 0, 0, 0, $disp_width, $disp_height);
if($src_image2)	imagecopy($four_image, $src_image2, $disp_width, 0, 0, 0, $disp_width, $disp_height);
if($src_image3)	imagecopy($four_image, $src_image3, 0, $disp_height, 0, 0, $disp_width, $disp_height);
if($src_image4)	imagecopy($four_image, $src_image4, $disp_width, $disp_height, 0, 0, $disp_width, $disp_height);

// 統合画像から表示対象を切り出し
$out_image = ImageCreateTrueColor($disp_width, $disp_height);
imagefill($out_image, 0, 0, 0xFFFFFF);
imagecopy($out_image, $four_image, 0, 0, $cutStartX, $cutStartY, $disp_width, $disp_height);

// 出力
imagejpeg($out_image);
if($four_image)	imagedestroy($four_image);
if($out_image)	imagedestroy($out_image);
if($src_image1)	imagedestroy($src_image1);
if($src_image2)	imagedestroy($src_image2);
if($src_image3)	imagedestroy($src_image3);
if($src_image4)	imagedestroy($src_image4);


?>
