<?php
/**
* createkakikoimage.php サムネイル作成
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
$imgPath = "";
$savefileName = "";
if(isset($_GET['imgpath'])){
	$imgPath = $_GET['imgpath'];
	$pathArray = pathinfo($imgPath);
	$savefileName = $pathArray['basename'];
}else{
	exit(-1);
}

$src_image = null;
// 画像の種類を割り出す
$imagesize = getimagesize($imgPath);
switch($imagesize[2]){
	case 1: // gif
		header("Content-Type:image/gif");
		if(file_exists($imgPath))	$src_image = imagecreatefromgif($imgPath);
		break;
	case 2: // jpg
		header("Content-Type:image/jpg");
		if(file_exists($imgPath))	$src_image = imagecreatefromjpeg($imgPath);
		break;
	case 3: // png
		header("Content-Type:image/png");
		if(file_exists($imgPath))	$src_image = imagecreatefrompng($imgPath);
		break;
	default:
		$LOG->crit("This file type not supported!!");
}
header("Content-Disposition: inline; filename=".$savefileName);

// サムネイルサイズを確定する
$thumbnail_height = 0;
$thumbnail_width = 0;
$baseSize = 200;
// RSS用サムネイルサイズ
if(isset($_GET['type']) && $_GET['type'] == "s"){
	$baseSize = 80;
}
if($imagesize[0] > $imagesize[1]){
	if($baseSize > $imagesize[0]){
		$thumbnail_height = $imagesize[1];
		$thumbnail_width = $imagesize[0];
	}else{
		$thumbnail_height = $imagesize[1] / ($imagesize[0] / $baseSize);
		$thumbnail_width = $baseSize;
	}
}else if($imagesize[0] == $imagesize[1]){
	if($baseSize > $imagesize[0]){
		$thumbnail_height = $imagesize[1];
		$thumbnail_width = $imagesize[0];
	}else{
		$thumbnail_height = $baseSize;
		$thumbnail_width = $baseSize;
	}
}else{
	if($baseSize > $imagesize[1]){
		$thumbnail_height = $imagesize[1];
		$thumbnail_width = $imagesize[0];
	}else{
		$thumbnail_height = $baseSize;
		$thumbnail_width = $imagesize[0] / ($imagesize[1] / $baseSize);
	}
}

// パレット作成
$out_image = ImageCreateTrueColor($thumbnail_width, $thumbnail_height);
imagefill($out_image, 0, 0, 0xFFFFFF);

// イメージをリサイズ
imagecopyresampled($out_image, $src_image, 0, 0, 0, 0, $thumbnail_width, $thumbnail_height, $imagesize[0], $imagesize[1]);

// 出力
switch($imagesize[2]){
	case 1: // gif
		imagegif($out_image);
		break;
	case 2: // jpg
		imagejpeg($out_image);
		break;
	case 3: // png
		imagepng($out_image);
		break;
	default:
		$LOG->crit("This file type not supported!!");
}
// メモリ開放
imagedestroy($src_image);
imagedestroy($out_image);

?>
