<?php
/**
* memodetail.php 処理概要：メモ・コメント詳細表示処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("class/db/service/ContentsViewService.class.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// マップ公開区分が非公開(9)の場合公開停止画面へリダイレクト
if(MAP_PUBLIC == 9){
	header("location: ".dirname($_SERVER['PHP_SELF'])."/mapclosed.html");
	exit(-1);
}

// ログイン処理
if(!isset($_SESSION['LOGINMODE'])){
	if(MAP_AUTOLOGIN == 1){
		require_once("./userauth.php");
	}
	// SESSIONに「LOGINMODE」を設定
	$_SESSION['LOGINMODE'] = MAP_AUTOLOGIN;
}

// セッションからユーザID・ユーザ名を取得
$s_UserId = null;
$s_UserName = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserName = $_SESSION[DIRECTORY_NAME.'_username'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memoDetailForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "updDelPwd" => ""
));

// input 項目セット
$o_form->addElement("password", "updDelPwd", $o_resource->getValue("G04004L001"), array("size"=>"4", "maxlength"=>"4", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text", "memolink", $o_resource->getValue("G04004L002"), array("readonly", "onfocus"=>"this.select()", "size"=>"75", "maxlength"=>"256", "autocomplete"=>"off", "class"=>"fs12_black"));

// チェック項目
$o_form->addRule("updDelPwd", $o_resource->getValue("G04004M001"), "regex", "/^[a-zA-Z0-9]+$/");
$o_form->addRule("updDelPwd", $o_resource->getValue("G04004M002"), "maxlength_valid",	4);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

// 一時変数初期化
$errorMessage = "";
$pageFlg = 0;
$tplName = "";

if(isset($_GET[submit])){
    // 妥当性チェック
    if ($o_form->validate()) {
		$pageFlg = 1;
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    // メモ表示画面
	$dataArray = null;
	// 詳細情報を取得
	if(isset($_GET['commentId'])){
		$dataArray = getCommentDetailData($_GET['commentId']);
	}else if(isset($_GET['memoId'])){
		$dataArray = getMemoDetailData($_GET['memoId'], $s_UserId);
	}else{
		trigger_error("Unlawful computer access!!", E_USER_ERROR);
	    exit(-1);
	}
	$labelArray = array("header"     => $o_resource->getValue("G04004L003"),
			          "addDateTime"   => $o_resource->getValue("G04004L004").$dataArray['addDateTime'],
			          "layerMemoType" => $dataArray['layerName']." / ".$dataArray['memoTypeName'],
			          "memoIcon"      => $dataArray['icon'],
			          "memoColor"     => "#".$dataArray['ribbon'],
			          "memoName"      => $dataArray['memoTitle'],
			          "userName"      => $dataArray['userName'],
			          "mailAddress"   => $dataArray['mailAddress'],
			          "releteUrl"     => $dataArray['url'],
			          "labelUrl"     => $o_resource->getValue("G04004L005"),
			          "memoText"      => explode("\n",$dataArray['text']),
			          "imgFile"       => $dataArray['imgFile']
			         );
    $o_smarty->assign("labelArray", $labelArray);

	// スレッドを取得
	$tplCommentArray = getTreeData($_GET['memoId'], $_GET['commentId']);
    $o_smarty->assign("tplCommentArray", $tplCommentArray);

	// HTML_QuickForm設定
	$protocol = "";
	if(isset($_SERVER['HTTPS'])){
		$protocol="https://";
	}else{
		$protocol="http://";
	}
	$linkString = $protocol.$_SERVER['SERVER_NAME'].dirname($_SERVER['PHP_SELF'])."/directmap.php?".
			"memoId=".$_GET['memoId'];
	if(isset($_GET['commentId'])){
		$linkString = $linkString."&commentId=".$_GET['commentId'];
	}
	$o_form->setDefaults(
				array("memolink"=>$linkString)
			);

	$centerArray = null;
	// 表示順で最上位のレイヤーIDを取得する
	$service = new ContentsViewService(DIRECTORY_NAME);
	$layerTableData = null;
	if($s_UserId == null && isset($_COOKIE[LAYERPRIORITY])){
	    $layer_array = explode(",", $_COOKIE[LAYERPRIORITY]);
	    // クッキーに設定されている1番上位のレイヤーテーブル情報を取得する
		$layerTableData = $service->getLayerOneData($layer_array[0]);
	}else{
		$layerTableData = $service->getTopPriorityLayerData($s_UserId);
	}
	if(MAP_TYPE == 0){
		if($layerTableData->getDiffx() == null && $layerTableData->getDiffy() == null){
			// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
			$centerArray = explode(",", MAP_CENTER);
		}else{
			// 最上位レイヤーの中心表示情報が存在する場合はそちらを取得
			$centerArray = array($layerTableData->getDiffx(), $layerTableData->getDiffy());
		}
	}else{
		// カキコエンジン
		$centerScale = null;
		if($layerTableData->getCenterScale() == null){
			// レイヤー管理者によって初期マップ（スケール）が設定されていない場合はデフォルト
			$centerScale = MAP_CENTER;
		}else{
			// 最上位レイヤーの中心表示情報が存在する場合はそちらを取得
			$centerScale = $layerTableData->getCenterScale();
		}
		// 表示対象のマップを検索し中心座標を算出する
		$mapDetailData = $service->getMapJoinMapDetailData($centerScale);
		$distance_to_center_X = floor((($mapDetailData->getEndX_BaseMap() - $mapDetailData->getStartX_BaseMap()) / 2) * 1000000) / 1000000;
		$distance_to_center_Y = floor((($mapDetailData->getEndY_BaseMap() - $mapDetailData->getStartY_BaseMap()) / 2) * 1000000) / 1000000;
		$centerArray = array(
			 floor(($distance_to_center_X / $mapDetailData->getPixel_MapDetail()) * 1000000) / 1000000,
			 floor(($distance_to_center_Y / $mapDetailData->getPixel_MapDetail()) * 1000000) / 1000000
			);

		// GIS未使用の場合は中心表示マップに切り替える
	    $o_smarty->assign("kakikoScale", sprintf("%03d", $centerScale));
	}

    $o_form->addElement("submit", "mapmove",    $o_resource->getValue("G04004L006"), array("onclick"=>"moveCenter(".$centerArray[0].",".$centerArray[1].")", "class"=>"fs12_black"));
    $o_form->addElement("submit", "comment",    $o_resource->getValue("G04004L007"), array("class"=>"fs12_black"));
    $o_form->addElement("submit", "delupd",     $o_resource->getValue("G04004L008"), array("class"=>"fs12_black"));    
	$o_form->addElement("hidden", "layerid",    $dataArray['layerid']);
	$o_form->addElement("hidden", "memoId",     $_GET['memoId']);
	$o_form->addElement("hidden", "memoTypeId", $dataArray['memoTypeId']);
	$o_form->addElement("hidden", "commentId",  $_GET['commentId']);
	$o_form->addElement("hidden", "longitude",  $dataArray['longitude']);
	$o_form->addElement("hidden", "latitude",   $dataArray['latitude']);

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$o_smarty->assign("errorMessage", $errorMessage);

} else {
    // 修正画面へPOST
	
	// POST

}
$o_smarty->display(DIRECTORY_NAME."/directmap.tpl");



//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ詳細データ取得
* 処理詳細：メモ詳細データを取得する
*
* @引数： (I) memoid	- string  メモID
*         (I) userId    - string  ユーザID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getMemoDetailData($memoid, $userId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneMemoDetailViewDataAuth($memoid, $userId);

	// アイコンタイプでアドレス切り替え
	$iconPath = "";
	if($dataObject->getIconType() == 0){
		$iconPath = "../../img/icon/".$dataObject->getIcon();
	}else{
		$iconPath = "./img/icon/".$dataObject->getIcon();
	}
	// イメージパス
	$imgPath = "";
	if($dataObject->getImageFile_d() != ""){
		$imgPath = "./img/memo/".$dataObject->getImageFile_d();
	}

	$memoData = array(
		"longitude"    => $dataObject->getLongitude(),
		"latitude"     => $dataObject->getLatitude(),
		"addDateTime"  => $dataObject->getAddDateTime_d(),
		"layerid"      => $dataObject->getLayerID(),
		"layerName"    => $dataObject->getLayerName(),
		"memoTypeId"   => $dataObject->getMemoTypeID(),
		"memoTypeName" => $dataObject->getMemoTypeName(),
		"icon"         => $iconPath,
		"ribbon"       => $dataObject->getRibbonColor(),
		"userName"     => $dataObject->getUserName_d(),
		"memoTitle"	   => $dataObject->getMemoTitle(),
		"text"         => $dataObject->getMemoText(),
		"mailAddress"  => $dataObject->getMailAddress_d(),
		"url"          => $dataObject->getReleteURL_d(),
		"imgFile"      => $imgPath,
		"updDelPwd"    => $dataObject->getUpdateDeletePassword_d()
	);

	return $memoData;
}

/**
* 関数概要：コメント詳細データ取得
* 処理詳細：コメント詳細データを取得する
*
* @引数： (I) commentid	- string  コメントID
* @戻値： array 詳細情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getCommentDetailData($commentid){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataObject = $service->getOneCommentData($commentid);

	// アイコンタイプでアドレス切り替え
	$iconPath = "";
	if($dataObject->getIconType() == 0){
		$iconPath = "../../img/icon/".$dataObject->getIcon();
	}else{
		$iconPath = "./img/icon/".$dataObject->getIcon();
	}

	// イメージパス
	$imgPath = "";
	if($dataObject->getImageFile_c() != ""){
		$imgPath = "./img/memo/".$dataObject->getImageFile_c();
	}

	$commentData = array(
		"longitude"    => $dataObject->getLongitude(),
		"latitude"     => $dataObject->getLatitude(),
		"addDateTime"  => $dataObject->getAddDateTime_c(),
		"layerid"      => $dataObject->getLayerID(),
		"layerName"    => $dataObject->getLayerName(),
		"memoTypeId"   => $dataObject->getMemoTypeID(),
		"memoTypeName" => $dataObject->getMemoTypeName(),
		"icon"         => $iconPath,
		"ribbon"       => $dataObject->getRibbonColor(),
		"userName"     => $dataObject->getUserName_c(),
		"memoTitle"	   => $dataObject->getCommentTitle(),
		"text"         => $dataObject->getCommentText(),
		"mailAddress"  => $dataObject->getMailAddress_c(),
		"url"          => $dataObject->getReleteURL_c(),
		"imgFile"      => $imgPath,
		"updDelPwd"    => $dataObject->getUpdateDeletePassword_c()
	);
	
	return $commentData;
}

/**
* 関数概要：ツリーデータ取得
* 処理詳細：ツリーデータ（スレッド）を取得する
*
* @引数： (I) memoId	- string  メモID
*  　　　 (I) commentId - string  コメントID
* @戻値： array ツリー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getTreeData($memoId,$commentId){

	$service = new ContentsViewService(DIRECTORY_NAME);
	$dataArray = $service->getAllMemoCommentTreeDataByKey($memoId);

	$treeData = array();
	foreach($dataArray as $record){

		$linkString = "";
		if(($commentId == "" && $record->getNodeLevel() != 1) 
					|| ($record->getCommentID() != $commentId)){
			if($record->getNodeLevel() == 1){
				$linkString = $_SERVER["PHP_SELF"]
						."?memoId=".$record->getMemoID();
			}else{
				$linkString = $_SERVER["PHP_SELF"]
						."?memoId=".$record->getMemoID()
						."&commentId=".$record->getCommentID();
			}
		}
		$dotString = str_repeat("・ ", $record->getNodeLevel() - 1);

		$recordData = array(
			"commentId"	      => $record->getCommentID(),
			"highercommentid" => $record->getHigherCommentID(),
			"dot"             => $dotString,
			"title"	          => $record->getTitle(),
			"username"        => $record->getUserName(),
			"adddatetime"     => $record->getAddDatetime(),
			"link"            => $linkString
		);

		array_push($treeData, $recordData);
	}

	return $treeData;

}
?>