<?php
/**
* imidelete.php 処理概要：情報の整理 情報削除処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ImiAdminService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
$s_UserType = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("imiDeleteForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$infoData = getBaseInfoData($_POST['imiSpaceId']);
$o_form->setDefaults(array(
	"infoName"   => $infoData['imiSpaceName'],
	"userName"   => $infoData['userName'],
	"lastUpdate" => $infoData['updateDateTime']
	)
);

// 項目セット
$o_form->addElement("header", "rowTitle01", $o_resource->getValue("G04002L001"));
$o_form->addElement("header", "rowTitle02", $o_resource->getValue("G07006L002"));
$o_form->addElement("header", "rowTitle03", $o_resource->getValue("G07006L003"));
$o_form->addElement("static", "infoName", "");
$o_form->addElement("static", "userName", "");
$o_form->addElement("static", "lastUpdate", "");
$o_form->addElement("hidden", "imiSpaceId", $_POST['imiSpaceId']);

// チェック項目

// 独自チェックルールの定義

$errorMessage = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST[submit])) {
	
    // チェックOK
    if ($o_form->validate()) {
        $pageFlg = 1;
        
        // **************************
        // DB削除処理実装部
        // **************************
		// DELETE
		$service = new ImiAdminService(DIRECTORY_NAME);
		if(!$service->deleteImiBaseInfoData($_POST['imiSpaceId'])){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 設定画面
    $o_form->addElement("submit", "submit",  $o_resource->getValue("G07006L004"), array("class"=>"fs12_black"));
    $o_form->addElement("submit",  "return", $o_resource->getValue("G07006L005"), array("onclick"=>"document.imiDeleteForm.action='./imispacemenu.php'","class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$labelArray = array(
		"header"    => $o_resource->getValue("G07006L006"),
		"title"     => $o_resource->getValue("G07006L007"),
		"infoMsg01" => $o_resource->getValue("G07006M001")
   	);
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);

    $tplName = DIRECTORY_NAME."/imidelete.tpl";

} else {
	header("location: ./imispacemenu.php");
	exit(0);
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：意味空間情報取得
* 処理詳細：指定されたキーで意味空間情報データを取得する
*
* @引数： (I) $imispaceid - string  意味空間ID
* @戻値： array 使用する意味空間情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getBaseInfoData($imispaceid){

	$service = new ImiAdminService(DIRECTORY_NAME);
	$data = $service->getImiBaseInfoData($imispaceid);

	$imiSpaceArray = array(
		"imiSpaceName"   => $data->getImiSpaceName(),
		"userName"       => $data->getUserName(),
		"updateDateTime" => $data->getUpdateDateTime()
	);

	return $imiSpaceArray;
}

?>