<?php
/**
* imimemoinfoupdate.php 処理概要：意味空間メモ情報更新処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");							//Directory(PREFIX)読み込み

require_once("class/db/service/ImiViewService.class.php");
require_once("class/common/ImiMapController.class.php");

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザID,ユーザ種別,意味空間IDを取得
$s_UserId = null;
$s_UserType = null;
$s_ImiSpaceId = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}
if(isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId'])){
	$s_ImiSpaceId = $_SESSION[DIRECTORY_NAME.'_imiSpaceId'];
}else{
	trigger_error("Illegal Access!!", E_USER_ERROR);
	exit(-1);
}
// 編集不可の場合は更新処理を行わない
if(!isset($_SESSION[DIRECTORY_NAME.'_imiSpaceId']) || $_SESSION[DIRECTORY_NAME.'_editMode'] == 0){
	exit(-1);
}

$mapController = null;
if(isset($_POST['mapext'])){
	$arr = explode(" ", $_POST['mapext']);
	$mapController = new ImiMapController($arr[0], $arr[1], $arr[2], $arr[3], $_POST['area_width'], $_POST['area_height']);
}

// JSONデータをデコード
$updateDataArray = json_decode($_POST['jsonData']);

// 更新ターゲット情報
$targetImiMemoPositionData = new ImiMemoPositionData();
$targetImiMemoPositionData->setImiSpaceID(WHERE_KEY);
$targetImiMemoPositionData->setMemoID(WHERE_KEY);
$targetImiMemoPositionData->setCoordinateX(VAL_TARGET);
$targetImiMemoPositionData->setCoordinateY(VAL_TARGET);
$targetImiMemoPositionData->setColorID(VAL_TARGET);
$targetImiMemoPositionData->setLayerID(VAL_TARGET);
$targetImiMemoPositionData->setMemoTypeID(VAL_TARGET);
//$targetImiMemoPositionData->setAddDateTime(VAL_TARGET);
$targetImiMemoPositionData->setUpdateDateTime(VAL_TARGET);

// 座標変換
$valueImiMemoPositionDataArray = array();
foreach($updateDataArray as $dataObject){
	
	$data = (array)$dataObject;

	// コントローラで座標変換する
	$coordinates = $mapController->get_changeCoordinatesFromJs($data['coordinateX'], $data['coordinateY']);

	// 更新値情報
	$valueImiMemoPositionData = new ImiMemoPositionData();
	$valueImiMemoPositionData->setImiSpaceID($s_ImiSpaceId);
	$valueImiMemoPositionData->setMemoID($data['memoID']);
	$valueImiMemoPositionData->setCoordinateX($coordinates[0]);
	$valueImiMemoPositionData->setCoordinateY($coordinates[1]);
	$valueImiMemoPositionData->setColorID($data['colorID']);
	$valueImiMemoPositionData->setLayerID($data['layerID']);
	$valueImiMemoPositionData->setMemoTypeID($data['memoTypeID']);
	//$valueImiMemoPositionData->setAddDateTime("");
	$valueImiMemoPositionData->setUpdateDateTime(date('Y/m/d H:i:s'));

	array_push($valueImiMemoPositionDataArray, $valueImiMemoPositionData);
}

$service = new ImiViewService(DIRECTORY_NAME);
if(!$service->updateMemoColorAndPostion($targetImiMemoPositionData, $valueImiMemoPositionDataArray)){
	trigger_error("DB Error!!", E_USER_ERROR);
    exit(-1);
}


?>