<?php
/**
* imiregist.php 処理概要：情報の整理 新規登録処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ImiAdminService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
$s_UserType = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId   = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("imiRegistForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
	"imiSpaceName" => "",
	"publicDiv"    => 1,
	"position"     => 0
	)
);

// 項目セット
$o_form->addElement("header", "rowTitle01",   $o_resource->getValue("G07002L001"));
$o_form->addElement("header", "rowTitle02",   $o_resource->getValue("G07002L002"));
$o_form->addElement("header", "rowTitle03",   $o_resource->getValue("G07002L003"));
$o_form->addElement("header", "rowTitle04",   $o_resource->getValue("G07002L004"));
$o_form->addElement("text",   "imiSpaceName", $o_resource->getValue("G07002L005"), array("size"=>"45", "maxlength"=>"30", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("radio",  "publicDiv",    $o_resource->getValue("G07002L006"), "", 1, array("checked"=>"checked","class"=>"fs12_black"));
$o_form->addElement("radio",  "publicDiv",    $o_resource->getValue("G07002L007"), "", 0, array("class"=>"fs12_black"));
// チェックボックスはvalueの問題があるためSmarty側で実装
$o_form->addElement("radio",  "positionmode", $o_resource->getValue("G07002L008"), "", 1, array("class"=>"fs12_black"));
$o_form->addElement("radio",  "positionmode", $o_resource->getValue("G07002L009"), "", 0, array("checked"=>"checked", "class"=>"fs12_black"));


// チェック項目
$o_form->addRule("imiSpaceName",  $o_resource->getValue("G07002M001"), "required");
$o_form->addRule("imiSpaceName",  $o_resource->getValue("G07002M002"), "maxlength_valid",   30);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

$errorMessage = "";
$errorCheck = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST['submit'])) {
	
	// チェックボックスのチェック状態を判別
    if(empty($_POST['useLayer'])){
    	$errorCheck = $o_resource->getValue("G07002M003");
    }
    // チェックOK
    if ($o_form->validate() && !empty($_POST['useLayer'])) {
        $pageFlg = 1;
        
        // **************************
        // DB登録処理実装部
        // **************************
        // 意味空間基本データ生成
		$imibaseinfodata = new ImiBaseInfoData();
//		$imibaseinfodata->setImiSpaceID("default");
		$imibaseinfodata->setImiSpaceName($_POST['imiSpaceName']);
		$imibaseinfodata->setUserID($s_UserId);
		$imibaseinfodata->setPublicDivision($_POST['publicDiv']);
		$imibaseinfodata->setViewMode(1);
		$imibaseinfodata->setTakememoDatetime(date('Y/m/d H:i:s'));
		$imibaseinfodata->setMemoChangeFlg(0);
		$imibaseinfodata->setMemoDeleteWarnFlg(0);
		$imibaseinfodata->setAddDateTime(date('Y/m/d H:i:s'));
		$imibaseinfodata->setUpdateDateTime(date('Y/m/d H:i:s'));
		
        // 意味空間使用レイヤーデータ生成
		$imiLayerDataList = array();
		foreach($_POST['useLayer'] as $curlayerId){
			$layerData = new ImiLayerData();
			$layerData->setImiSpaceID("default");
			$layerData->setLayerID($curlayerId);
			$layerData->setAddDateTime(date('Y/m/d H:i:s'));
			$layerData->setUpdateDateTime(date('Y/m/d H:i:s'));
			
			array_push($imiLayerDataList, $layerData);
		}
		
		// insert
		if ( $_POST['positionmode'] == '0'){
			$positionMode =  0;
		}elseif( $_POST['positionmode'] == '1'){
			$positionMode =  1;
		}
		$service = new ImiAdminService(DIRECTORY_NAME);
		if(!$service->insertImiSpace($imibaseinfodata, $imiLayerDataList, $s_UserId, $positionMode)){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 設定画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G07002L010"), array("class"=>"fs12_black"));
    $o_form->addElement("reset",  "reset",  $o_resource->getValue("G07002L011"), array("class"=>"fs12_black"));
	$o_form->addElement("submit", "return", $o_resource->getValue("G07002L014"), array("onclick"=>"document.imiRegistForm.action='./imispacemenu.php'","class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	// チェックボックス
	$o_smarty->assign("layerArray", getUseLayerData($s_UserId, $_POST['useLayer']));

	$labelArray = array(
		"header" => $o_resource->getValue("G07002L012"),
		"title"  => $o_resource->getValue("G07002L013")
   	);
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);
	$o_smarty->assign("errorCheck",   $errorCheck);

    $tplName = DIRECTORY_NAME."/imiregist.tpl";

} else {
	header("location: ./imispacemenu.php");
	exit(0);
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：使用するレイヤー取得
* 処理詳細：使用するレイヤーチェックボックスに使用するデータを取得する
*
* @引数： (I) $userId	- string  ユーザID
*  　　　 (I) $postLayer - array  POST配列
* @戻値： array 使用するレイヤー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getUseLayerData($userId, $postLayer){

	$service = new ImiAdminService(DIRECTORY_NAME);
	$dataArray = $service->getLayerDataListPossibleToUse($userId);

	// POSTされたレイヤーがない場合、初期化
	if($postLayer == null ) $postLayer = array();

	$layerArray = array();
	if($dataArray != null){
		foreach($dataArray as $layerData){
			$layerData = array(
				"layerId"   => $layerData->getLayerId_Layer(),
				"layerName" => $layerData->getLayerName_Layer(),
				"checked"   => in_array($layerData->getLayerId_Layer(), $postLayer, true )
			);
			array_push($layerArray, $layerData);
		}
	}
	
	return $layerArray;
}

?>