<?php
/**
* imisetting.php 処理概要：情報の整理 環境設定処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("DefineDirectryName.php");					//Directory(PREFIX)読み込み

require_once("class/db/service/ImiAdminService.class.php");

require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み
require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path'], DIRECTORY_NAME) == false ) {
    header("location: ./index.php");
}

// セッションからユーザIDを取得
$s_UserId = null;
$s_UserType = null;
if(isset($_SESSION[DIRECTORY_NAME.'_userid'])){
	$s_UserId = $_SESSION[DIRECTORY_NAME.'_userid'];
	$s_UserType = $_SESSION[DIRECTORY_NAME.'_usertype'];
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("imiSettingForm", "POST", $_SERVER["PHP_SELF"], "_self");

// 入力項目のデフォルトをセット
$infoData = getBaseInfoData($_POST['imiSpaceId']);
$o_form->setDefaults(array(
	"imiSpaceName" => $infoData['imiSpaceName'],
	"publicDiv"    => $infoData['publicDivision'],
	)
);

// 項目セット
$o_form->addElement("header", "rowTitle01",   $o_resource->getValue("G07004L001"));
$o_form->addElement("header", "rowTitle02",   $o_resource->getValue("G07004L002"));
$o_form->addElement("header", "rowTitle03",   $o_resource->getValue("G07004L003"));
$o_form->addElement("header", "rowTitle04",   $o_resource->getValue("G07004L004"));
$o_form->addElement("text",   "imiSpaceName", $o_resource->getValue("G07004L005"), array("size"=>"45", "maxlength"=>"30", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("radio",  "publicDiv",    $o_resource->getValue("G07004L006"), "", 1, array("checked"=>"checked","class"=>"fs12_black"));
$o_form->addElement("radio",  "publicDiv",    $o_resource->getValue("G07004L007"), "", 0, array("class"=>"fs12_black"));
$o_form->addElement("hidden", "imiSpaceId",   $_POST['imiSpaceId']);
$o_form->addElement("hidden", "authorId",     $_POST['authorId']);
// チェックボックスはvalueの問題があるためSmarty側で実装

// チェック項目
$o_form->addRule("imiSpaceName", $o_resource->getValue("G07004M001"), "required");
$o_form->addRule("imiSpaceName", $o_resource->getValue("G07004M002"), "maxlength_valid",   30);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

$errorMessage = "";
$errorCheck = "";
$pageFlg = 0;
$tplName = "";
// 登録ボタン
if (isset($_POST['submit'])) {
	// チェックボックスのチェック状態を判別
    if(empty($_POST['useLayer'])){
    	$errorCheck =  $o_resource->getValue("G07004M003");
    }
    
    // チェックOK
    if ($o_form->validate() && !empty($_POST['useLayer'])) {
        $pageFlg = 1;
        
        // **************************
        // DB更新処理実装部
        // **************************
		// 更新対象列
		$targetImiBaseInfoData = new ImiBaseInfoData();
		$targetImiBaseInfoData->setImiSpaceID(WHERE_KEY);
		$targetImiBaseInfoData->setImiSpaceName(VAL_TARGET);
		$targetImiBaseInfoData->setPublicDivision(VAL_TARGET);
		
		// 更新設定値
		$valueImiBaseInfoData = new ImiBaseInfoData();
		$valueImiBaseInfoData->setImiSpaceID($_POST['imiSpaceId']);
		$valueImiBaseInfoData->setImiSpaceName($_POST['imiSpaceName']);
		$valueImiBaseInfoData->setPublicDivision($_POST['publicDiv']);
		$valueImiBaseInfoData->setUpdateDateTime(date('Y/m/d H:i:s'));

       // 意味空間使用レイヤーデータ生成
		$imiLayerDataList = array();
		foreach($_POST['useLayer'] as $curlayerId){
			$layerData = new ImiLayerData();
			$layerData->setImiSpaceID($_POST['imiSpaceId']);
			$layerData->setLayerID($curlayerId);
			$layerData->setAddDateTime(date('Y/m/d H:i:s'));
			$layerData->setUpdateDateTime(date('Y/m/d H:i:s'));
			
			array_push($imiLayerDataList, $layerData);
		}
		
		// UPDATE
		$service = new ImiAdminService(DIRECTORY_NAME);
		if(!$service->updateImiBaseInfo($targetImiBaseInfoData, $valueImiBaseInfoData, $imiLayerDataList, $_POST['authorId'])){
			trigger_error("DB Error!!", E_USER_ERROR);
		    exit(-1);
		}
    }
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
// ボタンを表示
if ($pageFlg == 0) {
    // 設定画面
    $o_form->addElement("submit", "submit", $o_resource->getValue("G07004L008"), array("class"=>"fs12_black"));
    $o_form->addElement("reset",  "reset",  $o_resource->getValue("G07004L009"), array("class"=>"fs12_black"));
	$o_form->addElement("submit", "return", $o_resource->getValue("G07004L012"), array("onclick"=>"document.imiSettingForm.action='./imispacemenu.php'","class"=>"fs12_black"));

	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	// チェックボックス
	$o_smarty->assign("layerArray", getUseLayerData($s_UserId, $_POST['useLayer'], $_POST['imiSpaceId']));

	$labelArray = array(
		"header" => $o_resource->getValue("G07004L010"),
		"title"  => $o_resource->getValue("G07004L011")
   	);
	$o_smarty->assign("labelArray", $labelArray);

	$o_smarty->assign("errorMessage", $errorMessage);
	$o_smarty->assign("errorCheck",   $errorCheck);

    $tplName = DIRECTORY_NAME."/imisetting.tpl";

} else {
	header("location: ./imispacemenu.php");
	exit(0);
}
$o_smarty->display($tplName);

//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：使用するレイヤー取得
* 処理詳細：使用するレイヤーチェックボックスに使用するデータを取得する
*
* @引数： (I) $userId	- string  ユーザID
*  　　　 (I) $postLayer - array  POST配列
* @戻値： array 使用するレイヤー情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getUseLayerData($userId, $postLayer, $imiSpaceId){

	$service = new ImiAdminService(DIRECTORY_NAME);
	// 使用可能なレイヤー情報を取得
	$useArray = $service->getLayerDataListPossibleToUse($userId);
	
	// 使用されているレイヤーIDの配列を作成
	$usedObjectList = $service->getImiLayerViewListData($imiSpaceId);
	$usedArray = array();
	foreach($usedObjectList as $usedObject){
		array_push($usedArray, $usedObject->getLayerId());
	}
	
	// POSTされたレイヤーがない場合、初期化
	if($postLayer == null ) $postLayer = array();

	$layerArray = array();
	if($useArray != null){
		foreach($useArray as $layerData){

			// disabled, checked設定
			$disabledFlag = false;
			$checkedFlag = false;
			if(in_array($layerData->getLayerId_Layer(), $usedArray)){
				$disabledFlag = true;
				$checkedFlag = true;
			}else{
				if(in_array($layerData->getLayerId_Layer(), $postLayer, true )){
					$checkedFlag = true;
				}
			}
			$layerData = array(
				"layerId"   => $layerData->getLayerId_Layer(),
				"layerName" => $layerData->getLayerName_Layer(),
				"checked"   => $checkedFlag,
				"disabled"  => $disabledFlag
			);
			array_push($layerArray, $layerData);
		}
	}
	
	return $layerArray;
}

/**
* 関数概要：意味空間情報取得
* 処理詳細：指定されたキーで意味空間情報データを取得する
*
* @引数： (I) $imispaceid - string  意味空間ID
* @戻値： array 使用する意味空間情報(連想配列)
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @更新内容：
*/
function getBaseInfoData($imispaceid){

	$service = new ImiAdminService(DIRECTORY_NAME);
	$data = $service->getImiBaseInfoData($imispaceid);

	$imiSpaceArray = array(
		"imiSpaceName"   => $data->getImiSpaceName(),
		"publicDivision" => $data->getPublicDivision()
	);

	return $imiSpaceArray;
}

?>