<?php
/**
* kakiko_rss.php 処理概要：RSS取得処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 
require_once("DefineDirectryName.php");	//Directory(PREFIX)読み込み

require_once("function/KakikoContentsCommon.php");
require_once("class/db/service/ContentsViewService.class.php");

// マップ公開区分が非公開(9)の場合ファイルは読み込まない
if(MAP_PUBLIC == 9){
	exit(-1);
}

$userId = "";
$layerId = "";
if(isset($_GET['userId']) && isset($_GET['layerId'])){
	$userId = $_GET['userId'];
	$layerId = $_GET['layerId'];
}else{
	$LOG->crit("Illegal access to RSS file.");
	trigger_error("Illegal access to RSS file.", E_USER_ERROR);
}
	
// rss Directory
$rssDirectory = null;
$dirs = split(PATH_SEPARATOR, ini_get('include_path')); 
foreach ($dirs as $dirpath) {
    $fpath = $dirpath.DIRECTORY_SEPARATOR."kakikomap".DIRECTORY_SEPARATOR."rss".DIRECTORY_SEPARATOR.DIRECTORY_NAME.DIRECTORY_SEPARATOR;
	if(is_dir($fpath)){
		$rssDirectory = $fpath;
		break;
	}
}
if($rssDirectory == null){
	$LOG->crit("path is not found.");
	trigger_error("path is not found.", E_USER_ERROR);
}

$service = new ContentsViewService(DIRECTORY_NAME);
$rssFileName = $service->getRssFileNameByUser($userId, $layerId);

// rssファイル読み込み
header("Content-Type:application/rdf+xml");
header("Content-Type: text/html;charset=utf-8");
$rssFileName = $rssDirectory.$rssFileName.".rdf";

$handle = fopen($rssFileName, "r");
print(fread($handle, filesize($rssFileName)));
fclose($handle);

?>
