<?php
/**
* layerdel.php 処理概要：レイヤー削除
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                           // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み


// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04027L001"),
    "topTitle2"    => $o_resource->getValue("G04027L002"),
    "listTitle01"  => $o_resource->getValue("G04027L003"),
    "listTitle02"  => $o_resource->getValue("G04027L004"),
    "listTitle03"  => $o_resource->getValue("G04027L005"),
    "listTitle04"  => $o_resource->getValue("G04027L006"),
    "listTitle05"  => $o_resource->getValue("G04027L007"),
    "stsKnd00"     => $o_resource->getValue("G04027L008"),
    "stsKnd01"     => $o_resource->getValue("G04027L009"),
    "stsKnd02"     => $o_resource->getValue("G04027L010"),
    "delBtn"       => $o_resource->getValue("G04027L011"),
    "lstBtn"       => $o_resource->getValue("G04027L012"),
    "rtnBtn"       => $o_resource->getValue("G04027L013")
);

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layerdel", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "h_layerid"     => $_POST['h_layerid'],
    "h_layername"   => $_POST['h_layername'],
    "h_adddatetime" => $_POST['h_adddatetime'],
    "h_layernote"   => nl2br(urldecode($_POST['h_layernote'])),
    "h_statusflg"   => $_POST['h_statusflg']==0?$label['stsKnd00']:
                       $_POST['h_statusflg']==1?$label['stsKnd01']:$label['stsKnd02'],
    "s_layerid"     => $_POST['h_layerid'],
    "s_layername"   => $_POST['h_layername'],
    "s_adddatetime" => $_POST['h_adddatetime'],
    "s_layernote"   => nl2br(urldecode($_POST['h_layernote'])),
    "s_statusflg"   => $_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:
                       ($_POST['h_statusflg']==KAKIKOMAP_STATUSFLG_OFF?$label['stsKnd01']:$label['stsKnd02'])
));

$pageFlg = 0;

if (isset($_POST[run])) {
    if ($o_form->validate()) {
        if ($_POST['delchk'] == 1) {
            if (deleteRecode($o_service) == true) {
                $pageFlg = 1;
            } else {
				exit();
            }
        } else {
            $errorMessage = $o_resource->getValue("G04027M006");
        }
    }
}

if ($pageFlg == 0) {
    // 削除確認画面
    $o_form->addElement("header",   "header",        $label['topTitle']);
    $o_form->addElement("hidden",   "h_layerid",     null);
    $o_form->addElement("hidden",   "h_layername",   null);
    $o_form->addElement("hidden",   "h_adddatetime", null);
    $o_form->addElement("hidden",   "h_layernote",   null);
    $o_form->addElement("hidden",   "h_statusflg",   null);
    $o_form->addElement("static",   "s_layerid",     $label['listTitle01']);
    $o_form->addElement("static",   "s_layername",   $label['listTitle02']);
    $o_form->addElement("static",   "s_adddatetime", $label['listTitle03']);
    $o_form->addElement("static",   "s_layernote",   $label['listTitle04']);
    $o_form->addElement("static",   "s_statusflg",   $label['listTitle05']);
    $o_form->addElement("checkbox", "delchk",        null, $o_resource->getValue("G04027M005"));
    $o_form->addElement("submit",   "run",           $label['delBtn'], array("class"=>"fs12_black"));
    $o_form->addElement("button",   "return",        $label['rtnBtn'], array("onclick"=>"location.href='./layerlist.php'", "class"=>"fs12_black"));
    $tplarray = array();
    $tplName = DIRECTORY_NAME."/layerdel.tpl";
} else {
    // 完了画面
    $tplarray    = array(
                          "title"         => $label['topTitle2'],
                          "fintype"       => "1",
                          "infomessage"   => $o_resource->getValue("G04027M002"),
                          "tablewidth"    => "550",
                          "tdwidth"       => "150",
                          "listdatas"     => "",
                          "buttonname"    => $label['lstBtn'],
                          "buttononclick" => "location.href='layerlist.php'"
                         );
    $tplName = DIRECTORY_NAME."/commonfin.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04027M001"));
$o_smarty->assign("tplarray",     $tplarray);
$o_smarty->assign("delchk1",      $o_resource->getValue("G04027M003"));
$o_smarty->assign("delchk2",      $o_resource->getValue("G04027M004"));
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー削除
* 処理詳細：レイヤーテーブルより情報を削除する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function deleteRecode($o_service) {

	// レイヤー削除処理
	$rtn = $o_service->deleteLayerByKey($_SESSION[DIRECTORY_NAME.'_userid'], $_POST['h_layerid']);

    return $rtn;
}

?>
