<?php
/**
* G03-015
* gishelper.php 処理概要：中心表示座標の取得処理
* PHP versions：4.4.2
* @パッケージ：-
* @作者：(IIS)S.Komukai
* @作成日/作成者：2006/09/01 (IIS)S.Komukai
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義

require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/CommentData.class.php");
require_once("class/common/MapController.class.php");
require_once("class/xml/ReadResource.class.php");			// リソースファイル読込み

require_once("function/KakikoContentsCommon.php");

require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_ADMIN);

// POSTされてきたらその座標で地図を表示
// それぞれの矢印にクリック後のGET文字列を生成

$mapController;	// まっぷコントロールクラスオブジェクト
$scaleString;	// スケール文字列
$mapExt;		// 現在表示されているエリアを表す配列

$pageFlg = 0;

if(isset($_GET['mapext']) && (!isset($_GET['reset']))){
	$arr = explode(" ", $_GET['mapext']);
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}else{
	$o_service = new ContentsAdminService(DIRECTORY_NAME);
	$layerTableData = $o_service->getLayerOneData($_GET['layerId']);
	if($layerTableData->getStartX() == null && $layerTableData->getStartY() == null
			&& $layerTableData->getEndX() == null && $layerTableData->getEndY() == null){
		// レイヤー管理者によって初期座標が設定されていない場合はデフォルト
		$arr = explode(",", MAP_INITPOSITION);
	}else{
		$arr = array($layerTableData->getStartX(),
						$layerTableData->getStartY(),
						$layerTableData->getEndX(),
						$layerTableData->getEndY()
					);
	}
	$mapController = new MapController($arr[0], $arr[1], $arr[2], $arr[3], MAP_TYPE);
}
$mapExt = $mapController->get_minX()." ".$mapController->get_minY()." ".$mapController->get_maxX()." ".$mapController->get_maxY();

// smarty インスタンス化
$o_smarty = new KakikoSmarty();

if ($pageFlg == 0) {
	if(isset($_GET['scale'])){
		$scaleString = $_GET['scale'];
	}else{
		// GISは「初期表示」固定(カキコエンジンではこの画面を使用しない)
		$scaleString = "1";
	}

	$labelArray = array(
		"windowTitle"    => $o_resource->getValue("G03015L001"),
		"rangeInMap"     => $o_resource->getValue("G03015L002")
	);

	// QuickForm インスタンス化
	$o_form = new HTML_QuickForm("kakikoFromMap", "POST", $_SERVER["PHP_SELF"], "_self");

	$o_form->addElement("hidden",   "area_height", "");
	$o_form->addElement("hidden",   "area_width",  "");
	$o_form->addElement("hidden",   "click_x",     "");
	$o_form->addElement("hidden",   "click_y",     "");
	$o_form->addElement("hidden",   "mapext",      $mapExt);
	$o_form->addElement("hidden",   "scale",       $scaleString);
	$o_form->addElement("hidden",   "settingmode", $_GET['settingmode']);
	$o_form->addElement("hidden",   "layerId",     $_GET['layerId']);

	// GET文字列の配列
	$gisCGIMode = $_SERVER["PHP_SELF"]."?settingmode=".$_GET['settingmode']."&layerId=".$_GET['layerId']."&mode=map";

	$getLinkArray = array(
	  "leftUp"    => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftUpString(),
	  "up"        => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextUpString(),
	  "rightUp"   => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightUpString(),
	  "left"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftString(),
	  "right"     => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightString(),
	  "leftDown"  => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextLeftDownString(),
	  "down"      => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextDownString(),
	  "rightDown" => $gisCGIMode."&scale=".$scaleString.$mapController->get_mapextRightDownString()
	);

	$imgPath = "../../../contents/" .DIRECTORY_NAME . "/img/";

	$getLinkImageArray = array(
	  "leftUp"    => "<img src=\"{$imgPath}left_up.gif\"    alt=\"left_up\"    border=\"0\" align=\"bottom\" >",
	  "up"        => "<img src=\"{$imgPath}up.gif\"         alt=\"up\"         border=\"0\" align=\"bottom\" >",
	  "rightUp"   => "<img src=\"{$imgPath}right_up.gif\"   alt=\"right_up\"   border=\"0\" align=\"bottom\" >",
	  "left"      => "<img src=\"{$imgPath}left.gif\"       alt=\"left\"       border=\"0\" align=\"bottom\" >",
	  "right"     => "<img src=\"{$imgPath}right.gif\"      alt=\"right\"      border=\"0\" align=\"bottom\" >",
	  "leftDown"  => "<img src=\"{$imgPath}left_down.gif\"  alt=\"left_down\"  border=\"0\" align=\"bottom\" >",
	  "down"      => "<img src=\"{$imgPath}down.gif\"       alt=\"down\"       border=\"0\" align=\"bottom\" >",
	  "rightDown" => "<img src=\"{$imgPath}right_down.gif\" alt=\"right_down\" border=\"0\" align=\"bottom\" >"
	);
	$strHref = "#";
	$o_form->addElement("link", "leftUp",    "", $strHref,  $getLinkImageArray['leftUp'],   array("onclick"=>"mapArrowLink('".$getLinkArray['leftUp']."')","class"=>"fs12_black"));
	$o_form->addElement("link", "up",        "", $strHref,  $getLinkImageArray['up'],        array("onclick"=>"mapArrowLink('".$getLinkArray['up']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "rightUp",   "", $strHref,  $getLinkImageArray['rightUp'],  array("onclick"=>"mapArrowLink('".$getLinkArray['rightUp']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "left",      "", $strHref,  $getLinkImageArray['left'],      array("onclick"=>"mapArrowLink('".$getLinkArray['left']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "right",     "", $strHref,  $getLinkImageArray['right'],     array("onclick"=>"mapArrowLink('".$getLinkArray['right']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "leftDown",  "", $strHref,  $getLinkImageArray['leftDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['leftDown']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "down",      "", $strHref,  $getLinkImageArray['down'],      array("onclick"=>"mapArrowLink('".$getLinkArray['down']."')","class"=>"fs12_black")   );
	$o_form->addElement("link", "rightDown", "", $strHref,  $getLinkImageArray['rightDown'], array("onclick"=>"mapArrowLink('".$getLinkArray['rightDown']."')","class"=>"fs12_black")   );
	$o_form->addElement("button", "commit", $o_resource->getValue("G03015L003"), array("onclick"=>"extCommit(".$_GET['settingmode'].");","class"=>"fs12_black")   );

	// 地図の範囲配列
	$rangeArray = $mapController->get_mapextRangeArray($scaleString, "&settingmode=".$_GET['settingmode']."&layerId=".$_GET['layerId']);


	$getImageAddress ="";
	if(MAP_TYPE == 0){
		$getImageAddress = MAP_SERVER_ADDR . "?" . MAP_FILE_NAME . "&mode=map".$mapController->get_mapextString();
	}

	// form
	$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
	$o_form->accept($o_renderer);
	$o_smarty->assign("form", $o_renderer->toArray());

	$o_smarty->assign("rangeArray", $rangeArray);
	$o_smarty->assign("getImageAddress", $getImageAddress);
	$o_smarty->assign("labelArray", $labelArray);
//	$o_smarty->assign("contentsDir", DIRECTORY_NAME);

	$tplName = DIRECTORY_NAME."/layergishelper.tpl";
}

$o_smarty->display($tplName);
unset($_POST);

?>
