<?php
/**
* layermemotypelist.php 処理概要：レイヤーメモ種類一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04038L001"),
    "subTitle"     => $o_resource->getValue("G04038L002"),
    "colTitleA01"  => $o_resource->getValue("G04038L003"),
    "colTitleA02"  => $o_resource->getValue("G04038L004"),
    "colTitleA03"  => $o_resource->getValue("G04038L005"),
    "colTitleA04"  => $o_resource->getValue("G04038L006"),
    "colTitleB01"  => $o_resource->getValue("G04038L007"),
    "colTitleB02"  => $o_resource->getValue("G04038L008"),
    "colTitleB03"  => $o_resource->getValue("G04038L009"),
    "addUser"      => $o_resource->getValue("G04038L010"),
    "addMemo"      => $o_resource->getValue("G04038L011"),
    "stsKnd00"     => $o_resource->getValue("G04038L012"),
    "stsKnd01"     => $o_resource->getValue("G04038L013"),
    "stsKnd02"     => $o_resource->getValue("G04038L014"),
    "publicType0"  => $o_resource->getValue("G04038L015"),
    "publicType1"  => $o_resource->getValue("G04038L016"),
    "publicType9"  => $o_resource->getValue("G04038L017"),
    "authType0"    => $o_resource->getValue("G04038L018"),
    "authType1"    => $o_resource->getValue("G04038L019"),
    "authType9"    => $o_resource->getValue("G04038L020"),
    "newBtn"       => $o_resource->getValue("G04038L021"),
    "mntBtn"       => $o_resource->getValue("G04038L022"),
    "delBtn"       => $o_resource->getValue("G04038L023"),
    "layerList"    => $o_resource->getValue("G04038L024"),
    "setupEnd"     => $o_resource->getValue("G04038L025")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layermemotypelist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
$o_form->setDefaults(array(
    "layerid"   => $_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'],
    "layername" => $_SESSION[DIRECTORY_NAME.'_newlayer']['layername'],
    "layernote" => nl2br($_SESSION[DIRECTORY_NAME.'_newlayer']['layernote']),
    "statusflg" => $_SESSION[DIRECTORY_NAME.'_newlayer']['statusflg']==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:$label['stsKnd02']
));

// 項目セット
$o_form->addElement("static", "layerid",   $label['colTitleA01'], array("size"=>"16", "maxlength"=>"16",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "layername", $label['colTitleA02'], array("size"=>"50", "maxlength"=>"128", "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "layernote", $label['colTitleA03'], array("cols"=>"40", "rows"=>"5",        "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("static", "statusflg", $label['colTitleA04'], array("value"=>$statusflg==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:$label['stsKnd02'], "class"=>"fs12_black"));

$errorMessage = "";

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // このページはチェックがありません
    }
}

// メモ種類一覧データ取得
$data_array = getMemoTypeListData($o_service);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum = count($data_array);
$params  = array(
    "perPage"=>LAYERMEMOTYPELIST_ROW,
    "urlVar"=>"list",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G04038L026"),
    "nextImg"=>$o_resource->getValue("G04038L027"),
    "httpMethod"=>"POST"
);

// POST内容をクリア
unset($_POST['h_layerid'],
      $_POST['h_layername'], 
      $_POST['btn_memo']
      );

$o_page = Pager::factory($params);
$navi = $o_page->getlinks();
$nowpage = $o_page->getCurrentPageID();

$listData = getListData($data_array, $o_date, ($nowpage - 1) * LAYERMEMOTYPELIST_ROW, LAYERMEMOTYPELIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas",    $listData);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("pager",        $navi["all"]);
$o_smarty->assign("nowpage",      $nowpage);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layermemotypelist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類一覧表示情報取得
* 処理詳細：メモ種類管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： object レコードセット
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getMemoTypeListData($o_service) {

	$data = $o_service->getMemoTypeDataList($_SESSION[DIRECTORY_NAME.'_newlayer']['layerid']);

	return $data;

}

/**
* 関数概要：メモ種類一覧表示情報取得
* 処理詳細：一覧表示用データの抽出処理
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date	- object  日付クラス
*         (I) start		- integer 開始抽出データ
*         (I) cnt		- integer 抽出データ数
*         (I) rowNum	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = $start; $i < $start + $cnt; $i++) {
    
            if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getEffectiveTerm());

			$recode_array = array(
	               "memotypeid"=>$data[$i]->getMemoTypeID(),
	               "memotypename"=>$data[$i]->getMemoTypeName(),
	               "publicmemotype"=>$data[$i]->getPublicMemoType(),
	               "authoritymemotype"=>$data[$i]->getAuthorityMemoType(),
	               "icon"=>$data[$i]->getIcon(),
	               "ribboncolor"=>$data[$i]->getRibbonColor(),
	               "listtype"=>$data[$i]->getListType(),
	               "effectiveterm"=>$o_date->format("%Y/%m/%d")
			);
            $ret_array[] = $recode_array;
        }
    }

    return $ret_array;

}

?>
