<?php
/**
* layerregist.php 処理概要：レイヤー登録
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/LayerData.class.php");
require_once("class/db/tabledata/LayerUserData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"    => $o_resource->getValue("G04023L001"),
    "topTitle2"   => $o_resource->getValue("G04023L002"),
    "colTitle01"  => $o_resource->getValue("G04023L003"),
    "colTitle02"  => $o_resource->getValue("G04023L004"),
    "colTitle03"  => $o_resource->getValue("G04023L005"),
    "colTitle04"  => $o_resource->getValue("G04023L006"),
    "stsKnd00"    => $o_resource->getValue("G04023L007"),
    "stsKnd01"    => $o_resource->getValue("G04023L008"),
    "stsKnd02"    => $o_resource->getValue("G04023L009"),
    "addBtn"      => $o_resource->getValue("G04023L010"),
    "rstBtn"      => $o_resource->getValue("G04023L011"),
    "rtnBtn"      => $o_resource->getValue("G04023L012"),
    "userBtn"     => $o_resource->getValue("G04023L013"),
    "memoBtn"     => $o_resource->getValue("G04023L014"),
    "setupEnd"    => $o_resource->getValue("G04023L015")
);

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("layerregist", "POST", $_SERVER["PHP_SELF"]);

// 項目セット
$o_form->addElement("text",     "layerid",   $label['colTitle01'], array("size"=>"16", "maxlength"=>"16",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",     "layername", $label['colTitle02'], array("size"=>"50", "maxlength"=>"32",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("textarea", "layernote", $label['colTitle03'], array("cols"=>"40", "rows"=>"5",        "autocomplete"=>"off", "class"=>"fs12_black"));

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("layerid",		$o_resource->getValue("G04023M001"), "required");
//$o_form->addRule("layerid",     $o_resource->getValue("G04023M002"), "alphanumeric");
$o_form->addRule("layerid",		$o_resource->getValue("G04023M002"), "regex",	"/^[a-zA-Z0-9]+$/");
//$o_form->addRule("layerid",		$o_resource->getValue("G04023M003"), "maxlength", 16);
$o_form->addRule("layerid",		$o_resource->getValue("G04023M003"), "maxlength_valid",	16);
$o_form->addRule("layername",	$o_resource->getValue("G04023M004"), "required");
//$o_form->addRule("layername",	$o_resource->getValue("G04023M005"), "maxlength_valid",	128);

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // 入力データチェック
        $rtn = checkInputdata($o_service);
        if ($rtn == true) {
        	$rtn = insertRecode($o_service, $statusflg);
            if ($rtn == 1) {
                // 状態
                $o_form->addElement("text", "statusflg", $label['colTitle04'], array("value"=>$statusflg==KAKIKOMAP_STATUSFLG_ON?$label['stsKnd00']:$label['stsKnd02'], "class"=>"fs12_black"));
                // SESSIONへ登録情報をセット
                $_SESSION[DIRECTORY_NAME.'_newlayer']['layerid']   = $_POST['layerid'];
                $_SESSION[DIRECTORY_NAME.'_newlayer']['layername'] = $_POST['layername'];
                $_SESSION[DIRECTORY_NAME.'_newlayer']['layernote'] = $_POST['layernote'];
                $_SESSION[DIRECTORY_NAME.'_newlayer']['statusflg'] = $statusflg;
                // 入力情報フリーズ
                $o_form->freeze();
                $pageFlg = 1;
            } else if ($rtn == 0) {
            	$errorMessage = $o_resource->getValue("G04023M010");
            }
        } else if ($rtn == false) {
            $errorMessage = $o_resource->getValue("G04023M006");
        }
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("header",   "header",    $label['topTitle']);
    $o_form->addElement("submit",   "run",       $label['addBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("reset",    "reset",     $label['rstBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("button",   "return",    $label['rtnBtn'],      array("onclick"=>"location.href='layerlist.php'", "class"=>"fs12_black"));
} else {
    // 完了画面
    $o_form->addElement("header",   "header",    $label['topTitle2']);
    $o_form->addElement("button",   "adduser",   $label['userBtn'],     array("onclick"=>"location.href='layeruserlist.php'",     "class"=>"fs12_black"));
    $o_form->addElement("button",   "addmemo",   $label['memoBtn'],     array("onclick"=>"location.href='layermemotypelist.php'", "class"=>"fs12_black"));
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("dispMode",     $pageFlg);
$o_smarty->assign("infoMsg01",    $o_resource->getValue("G04023M007"));
$o_smarty->assign("infoMsg02",    $o_resource->getValue("G04023M008"));
$o_smarty->assign("infoMsg03",    $o_resource->getValue("G04023M009"));
$o_smarty->assign("setupEnd",     $label['setupEnd']);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/layerregist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：レイヤー登録前のデータチェック
* 処理詳細：レイヤーテーブルの存在チェック等
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean true :データなし
*      ：         false:データあり
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function checkInputdata($o_service) {

	$rtn = $o_service->checkLayerDataByKey($_POST['layerid']);

    return $rtn;
}

/**
* 関数概要：レイヤー登録処理
* 処理詳細：レイヤーを新規に登録する
*
* @引数： (I) o_service     - object DBサービスクラス
*         (O) statusflg		- integer 状態
* @戻値： integer -1:異常
*      ：          1:正常
*      ：          0:チェックエラー
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function insertRecode($o_service, &$statusflg){

	// レイヤーデータ作成
	$layerdata = new LayerData();

	$layerdata->setUserID($_SESSION[DIRECTORY_NAME.'_userid']);
	$layerdata->setLayerID($_POST['layerid']);
	$layerdata->setLayerName($_POST['layername']);
    if ($_POST['layernote'] != "") {
        $layerdata->setLayerNote($_POST['layernote']);
    } else {
        $layerdata->setLayerNote(null);
    }
	$layerdata->setPublicLayer(KAKIKOMAP_PUBLICLAYER_NORMAL);
	$layerdata->setReceiptLayer(KAKIKOMAP_RECEIPTLAYER_ON);
	$layerdata->setAddAttestUser(KAKIKOMAP_ADDATTESTUSER_ON);
	$layerdata->setDirectLink(KAKIKOMAP_DIRECTLINK_NON);
	$layerdata->setInitScale(1);
	$layerdata->setStartX(null);
	$layerdata->setStartY(null);
	$layerdata->setEndX(null);
	$layerdata->setEndY(null);
	$layerdata->setCenterScale(1);
	$layerdata->setDiffX(null);
	$layerdata->setDiffY(null);
	$layerdata->setRssFileName(md5((string)time().(string)(microtime()*100000000)));
	$layerdata->setStatusFlg(null);		// レイヤーの状態フラグはサービス側で設定する
	$layerdata->setAddDateTime(date('Y/m/d H:i:s'));
	$layerdata->setUpdateDateTime(date('Y/m/d H:i:s'));

	//レイヤーユーザデータ作成
	$layeruserdata = new LayerUserData();

	$layeruserdata->setUserID($_SESSION[DIRECTORY_NAME.'_userid']);
	$layeruserdata->setLayerID($_POST['layerid']);
	$layeruserdata->setStatusFlg(KAKIKOMAP_STATUSFLG_ON);
	$layeruserdata->setAddDateTime(date('Y/m/d H:i:s'));

	// レイヤー登録処理
	$rtn = $o_service->insertLayer($layerdata, $layeruserdata);

	$statusflg = $layerdata->getStatusFlg();

    return $rtn;

}

?>
