<?php
/**
* memotypedel.php 処理概要：メモ種類削除
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持(とりあえず)
$label = array(
    "topTitle"    => $o_resource->getValue("G04034L001"),
    "listTitle01" => $o_resource->getValue("G04034L002"),
    "listTitle02" => $o_resource->getValue("G04034L003"),
    "listTitle03" => $o_resource->getValue("G04034L004"),
    "listTitle04" => $o_resource->getValue("G04034L005"),
    "listTitle05" => $o_resource->getValue("G04034L006"),
    "listTitle06" => $o_resource->getValue("G04034L007"),
    "listTitle07" => $o_resource->getValue("G04034L008"),
    "listTitle08" => $o_resource->getValue("G04034L009"),
    "publicType0" => $o_resource->getValue("G04034L010"),
    "publicType1" => $o_resource->getValue("G04034L011"),
    "publicType9" => $o_resource->getValue("G04034L012"),
    "authType0"   => $o_resource->getValue("G04034L013"),
    "authType1"   => $o_resource->getValue("G04034L014"),
    "authType9"   => $o_resource->getValue("G04034L015"),
    "listType0"   => $o_resource->getValue("G04034L016"),
    "listType1"   => $o_resource->getValue("G04034L017"),
    "listType9"   => $o_resource->getValue("G04034L018"),
    "term0"       => $o_resource->getValue("G04034L019"),
    "term1"       => $o_resource->getValue("G04034L020"),
    "delBtn"      => $o_resource->getValue("G04034L021"),
    "clsBtn"      => $o_resource->getValue("G04034L022")
);

// SESSION内容取得
$session_layerid   = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'])  ?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']  :$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];
$session_layername = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'])?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername']:$_SESSION[DIRECTORY_NAME.'_newlayer']['layername'];

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memotypedel", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
if ($_POST['h_icontype'] == KAKIKOMAP_ICONTYPE_SYSTEM) {
    $icon = "<img src='../../../img/icon/".trim($_POST['h_icon'])."' alt='' />";
} else {
    $icon = "<img src='../img/icon/".$_POST['h_icon']."' height='16' width='16' alt=''/>";
}
if ($_POST['h_ribboncolor']!="") {
    $icon .= "&nbsp;&nbsp;（<font color=".$_POST['h_ribboncolor'].">■</font>）";
}
$o_form->setDefaults(array(
    "h_memotypeid"        => $_POST['h_memotypeid'],
    "h_icontype"          => $_POST['h_icontype'],
    "h_icon"              => $_POST['h_icon'],
    "s_layername"         => $session_layername,
    "s_memotypeid"        => $_POST['h_memotypeid'],
    "s_memotypename"      => $_POST['h_memotypename'],
    "s_icon"              => $icon,
    "s_publicmemotype"    => $_POST['h_publicmemotype']==KAKIKOMAP_PUBLICMEMOTYPE_GUEST?$label['publicType0']:
                             ($_POST['h_publicmemotype']==KAKIKOMAP_PUBLICMEMOTYPE_NORMAL?$label['publicType1']:$label['publicType9']),
    "s_authoritymemotype" => $_POST['h_authoritymemotype']==KAKIKOMAP_AUTHORITYMEMOTYPE_GUEST?$label['authType0']:
                             ($_POST['h_authoritymemotype']==KAKIKOMAP_AUTHORITYMEMOTYPE_NORMAL?$label['authType1']:$label['authType9']),
    "s_listtype"          => $_POST['h_listtype']==KAKIKOMAP_LISTTYPE_RIBBON?$label['listType0']:
                             ($_POST['h_listtype']==KAKIKOMAP_LISTTYPE_PIN?$label['listType1']:$label['listType9']),
    "s_effectiveterm"     => $_POST['h_effectiveterm']=="9999/12/31"?$label['term0']:$_POST['h_effectiveterm']
));

// 対象のメモ種類に属するメモが既に登録されているかチェック
if (checkMemoDetailData($o_service)) {
    $deleteok = true;
} else {
    $deleteok = false;
}

$pageFlg = 0;

if (isset($_POST[run])) {
    if ($o_form->validate()) {
        if (deleteRecode($o_service) == true) {
            $pageFlg = 1;
        }
    }
}

if ($pageFlg == 0) {
    // 削除確認画面
    $o_form->addElement("header", "header",              $label['topTitle']);
    $o_form->addElement("hidden", "h_memotypeid",        null);
    $o_form->addElement("hidden", "h_icontype",          null);
    $o_form->addElement("hidden", "h_icon",              null);
    $o_form->addElement("static", "s_layername",         $label['listTitle01']);
    $o_form->addElement("static", "s_memotypeid",        $label['listTitle02']);
    $o_form->addElement("static", "s_memotypename",      $label['listTitle03']);
    $o_form->addElement("static", "s_icon",              $label['listTitle04']);
    $o_form->addElement("static", "s_publicmemotype",    $label['listTitle05']);
    $o_form->addElement("static", "s_authoritymemotype", $label['listTitle06']);
    $o_form->addElement("static", "s_listtype",          $label['listTitle07']);
    $o_form->addElement("static", "s_effectiveterm",     $label['listTitle08']);
    $o_form->addElement("submit", "run",                 $label['delBtn'], array("class"=>"fs12_black", ($deleteok==true)?"":"disabled"));
    $o_form->addElement("button", "close",               $label['clsBtn'], array("onclick"=>"close_window();", "class"=>"fs12_black"));
    $tplName = DIRECTORY_NAME."/memotypedel.tpl";
} else {
    $tplName = "windowclose.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("infoMsg01",    $o_resource->getValue(($deleteok==true)?"G04034M001":"G04034M002"));
$o_smarty->assign("tplarray",     $tplarray);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ詳細件数取得
* 処理詳細：メモ種類IDに属するメモ件数の取得
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean true :データなし
*      ：         false:データあり
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function checkMemoDetailData($o_service) {

	// メモ詳細チェック処理
	$rtn = $o_service->checkMemoDetailDataByMemoTypeID($_POST['h_memotypeid']);

    return $rtn;
}

/**
* 関数概要：メモ種類削除
* 処理詳細：メモ種類管理テーブルより情報を削除する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function deleteRecode($o_service) {

	// メモ種類削除処理
	$rtn = $o_service->deleteMemoTypeByKey(
						$_POST['h_memotypeid'], $_POST['h_icontype'], $_POST['h_icon']);

    return $rtn;
}

?>
