<?php
/**
* memotypelist.php 処理概要：メモ種類一覧
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// SESSIONへ情報セット
if (isset($_POST['h_layerid'])) {
    $_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'] = $_POST['h_layerid'];
    $_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'] = $_POST['h_layername'];
}

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04029L001"),
    "topTitle2"    => $o_resource->getValue("G04029L002"),
    "colTitle01"   => $o_resource->getValue("G04029L003"),
    "colTitle02"   => $o_resource->getValue("G04029L004"),
    "colTitle03"   => $o_resource->getValue("G04029L005"),
    "publicType0"  => $o_resource->getValue("G04029L006"),
    "publicType1"  => $o_resource->getValue("G04029L007"),
    "publicType9"  => $o_resource->getValue("G04029L008"),
    "authType0"    => $o_resource->getValue("G04029L009"),
    "authType1"    => $o_resource->getValue("G04029L010"),
    "authType9"    => $o_resource->getValue("G04029L011"),
    "newBtn"       => $o_resource->getValue("G04029L012"),
    "mntBtn"       => $o_resource->getValue("G04029L013"),
    "delBtn"       => $o_resource->getValue("G04029L014"),
    "layerList"    => $o_resource->getValue("G04029L015"),
    "setupEnd"     => $o_resource->getValue("G04029L016")
);

// 日付クラス
$o_date = new Date();

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memotypelist", "POST", $_SERVER["PHP_SELF"]);
// 項目セット
$o_form->addElement("header", "header",    $label['topTitle']."(".$label['topTitle2'].$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'].")");

// メモ種類一覧データ取得
$data_array = getMemoTypeListData($o_service);
if (is_null($data_array)) {
	exit();
}

// Pager
$rowNum = count($data_array);
$params  = array(
    "perPage"=>MEMOTYPELIST_ROW,
    "urlVar"=>"list",
    "mode"=>"Jumping",
    "totalItems"=>$rowNum,
    "prevImg"=>$o_resource->getValue("G04029L017"),
    "nextImg"=>$o_resource->getValue("G04029L018"),
    "httpMethod"=>"POST"
);

// POST内容をクリア
unset($_POST['h_layerid'],
      $_POST['h_layername'], 
      $_POST['btn_memo']
      );

$o_page = Pager::factory($params);
$navi = $o_page->getlinks();
$nowpage = $o_page->getCurrentPageID();

$listData = getListData($data_array, $o_date, ($nowpage - 1) * MEMOTYPELIST_ROW, MEMOTYPELIST_ROW, $rowNum);

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("listDatas",    $listData);
$o_smarty->assign("labels",       $label);
$o_smarty->assign("pager",        $navi["all"]);
$o_smarty->assign("nowpage",      $nowpage);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display(DIRECTORY_NAME."/memotypelist.tpl");


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類一覧表示情報取得
* 処理詳細：メモ種類管理テーブルより情報を取得するクエリーをセット
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： object メモ種類データオブジェクト型配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getMemoTypeListData($o_service) {

	$data = $o_service->getMemoTypeDataList($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']);

	return $data;
}

/**
* 関数概要：メモ種類一覧表示情報取得
* 処理詳細：一覧表示用データの抽出処理
*
* @引数： (I) data		- object  データオブジェクト型配列
*         (I) o_date	- object  日付クラス
*         (I) start		- integer 開始抽出データ
*         (I) cnt		- integer 抽出データ数
*         (I) rowNum	- integer データ件数
* @戻値： array 一覧情報(連想配列)
* @戻値： 一覧情報配列
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function getListData($data, $o_date, $start, $cnt, $rowNum) {

    $ret_array = array();

    if (count($data) <> 0) {

        for ($i = $start; $i < $start + $cnt; $i++) {
    
            if ($i == $rowNum) break;

			if (is_null($data[$i]))	break;

			$o_date->setDate($data[$i]->getEffectiveTerm());

			$recode_array = array(
	               "memotypeid"=>$data[$i]->getMemoTypeID(),
	               "memotypename"=>$data[$i]->getMemoTypeName(),
	               "publicmemotype"=>$data[$i]->getPublicMemoType(),
	               "authoritymemotype"=>$data[$i]->getAuthorityMemoType(),
	               "icontype"=>$data[$i]->getIconType(),
	               "icon"=>$data[$i]->getIcon(),
	               "ribboncolor"=>$data[$i]->getRibbonColor(),
	               "listtype"=>$data[$i]->getListType(),
	               "effectiveterm"=>$o_date->format("%Y/%m/%d")
			);
            $ret_array[] = $recode_array;
        }
    }

    return $ret_array;
}

?>
