<?php
/**
* memotyperegist.php 処理概要：メモ種類登録
* PHP versions：4.4.2
* @パッケージ：-
* @作者：h.keta
* @作成日/作成者：2006/09/01 (IIS)h.keta
* @更新日/更新者：
* @バージョン：1.0.0
*
*  Copyright (c) 2006 Iwate Information System Co.,Ltd. All Rights Reserved.
*  You may see the License at LICENSE_EN.txt(English) or LICENSE_JA.txt(Japanese).
*/ 

require_once("../DefineDirectryName.php");                          // マップ別定数定義
require_once("function/KakikoContentsCommon.php");
require_once("kakikomap/require/common/".DIRECTORY_NAME."_settingRead.php");    // ユーザ用設定ファイル
require_once("class/db/service/ContentsAdminService.class.php");
require_once("class/db/tabledata/MemoTypeData.class.php");
require_once("class/xml/ReadResource.class.php");                  // リソースファイル読込み

// アクセス状態チェック
$p_url = parse_url($_SERVER["PHP_SELF"]);
if (access_check($p_url['path']) == false ) {
    header("location: ./layerlist.php");
}

// リソースファイル読込みインスタンス
$o_resource = new ReadResource(RESOURCE_CONTENTS, DIRECTORY_NAME);

// ページ内で表示に使用する文字列を配列に保持
$label = array(
    "topTitle"     => $o_resource->getValue("G04030L001"),
    "colTitle01"   => $o_resource->getValue("G04030L002"),
    "colTitle02"   => $o_resource->getValue("G04030L003"),
    "colTitle03"   => $o_resource->getValue("G04030L004"),
    "colTitle04"   => $o_resource->getValue("G04030L005"),
    "colTitle05"   => $o_resource->getValue("G04030L006"),
    "colTitle06"   => $o_resource->getValue("G04030L007"),
    "colTitle07"   => $o_resource->getValue("G04030L008"),
    "colTitle08"   => $o_resource->getValue("G04030L009"),
    "iconKnd0"     => $o_resource->getValue("G04030L010"),
    "iconKnd1"     => $o_resource->getValue("G04030L011"),
    "subLabel1"    => $o_resource->getValue("G04030L012"),
    "subLabel2"    => $o_resource->getValue("G04030L013"),
    "subLabel3"    => $o_resource->getValue("G04030L014"),
    "subLabel4"    => $o_resource->getValue("G04030L015"),
    "subLabel5"    => $o_resource->getValue("G04030L016"),
    "publicType0"  => $o_resource->getValue("G04030L017"),
    "publicType1"  => $o_resource->getValue("G04030L018"),
    "publicType9"  => $o_resource->getValue("G04030L019"),
    "authType0"    => $o_resource->getValue("G04030L020"),
    "authType1"    => $o_resource->getValue("G04030L021"),
    "authType9"    => $o_resource->getValue("G04030L022"),
    "listType0"    => $o_resource->getValue("G04030L023"),
    "listType1"    => $o_resource->getValue("G04030L024"),
    "listType9"    => $o_resource->getValue("G04030L025"),
    "term0"        => $o_resource->getValue("G04030L026"),
    "term1"        => $o_resource->getValue("G04030L027"),
    "refBtn"       => $o_resource->getValue("G04030L028"),
    "addBtn"       => $o_resource->getValue("G04030L029"),
    "rstBtn"       => $o_resource->getValue("G04030L030"),
    "clsBtn"       => $o_resource->getValue("G04030L031")
);

// システムアイコン定義配列
$systemicon_array = array(
                           "0" => array("color" => "CCFFCC", "file" => "green16.gif"),
                           "1" => array("color" => "CCCCFF", "file" => "blue16.gif"),
                           "2" => array("color" => "CCCCCC", "file" => "gray16.gif"),
                           "3" => array("color" => "FFCC99", "file" => "orange16.gif"),
                           "4" => array("color" => "FFCCCC", "file" => "red16.gif"),
                           "5" => array("color" => "FFCCFF", "file" => "violet16.gif"),
                           "6" => array("color" => "FFFFCC", "file" => "yellow16.gif")
                          );

// SESSION内容取得
$session_layerid   = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'])  ?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']  :$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];
$session_layername = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layername'])?$_SESSION[DIRECTORY_NAME.'_mntlayer']['layername']:$_SESSION[DIRECTORY_NAME.'_newlayer']['layername'];

// DB接続サービス呼び出し
$o_service = new ContentsAdminService(DIRECTORY_NAME);

// QuickForm インスタンス化
$o_form = new HTML_QuickForm("memotyperegist", "POST", $_SERVER["PHP_SELF"]);

// 入力項目のデフォルトをセット
if (isset($_POST['icontype'])) {
    $icontype = $_POST['icontype'];
} else {
    $icontype = KAKIKOMAP_ICONTYPE_SYSTEM;
}
$o_form->setDefaults(array(
    "layername"               => $session_layername." (".$session_layerid.")",
    "memotypename"            => "",
    "icontype"                => $icontype,
    "icon1_group"             => KAKIKOMAP_ICONTYPE_SYSTEM,
    "icon2"                   => "",
    "ribboncolor"             => "",
    "publicmemotype_group"    => KAKIKOMAP_PUBLICMEMOTYPE_NORMAL,
    "authoritymemotype_group" => KAKIKOMAP_AUTHORITYMEMOTYPE_NORMAL,
    "listtype_group"          => KAKIKOMAP_LISTTYPE_RIBBON,
    "effectiveterm_group"     => "0",
    "effectiveterm_date"      => ""
));

// 項目セット
$o_form->addElement("static",   "layername",    $label['colTitle01']);
$o_form->addElement("text",     "memotypename", $label['colTitle02'], array("size"=>"70", "maxlength"=>"32",  "autocomplete"=>"off", "class"=>"fs12_black"));
$icontype_array = array(KAKIKOMAP_ICONTYPE_SYSTEM=>$label['iconKnd0'], KAKIKOMAP_ICONTYPE_USER=>$label['iconKnd1']);
$o_form->addElement("select",   "icontype",     null, $icontype_array, array("style"=>"width:140px;", "class"=>"fs12_black", "onChange"=>"chengeicon(document.memotyperegist)"));
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['0']['file']."' alt='' />", 0);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['1']['file']."' alt='' />", 1);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['2']['file']."' alt='' />", 2);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['3']['file']."' alt='' />", 3);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['4']['file']."' alt='' />", 4);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['5']['file']."' alt='' />", 5);
$array_icon1[] =& HTML_QuickForm::createElement("radio", "icon1", null, "<img src='../../../img/icon/".$systemicon_array['6']['file']."' alt='' />", 6);
$o_form->addGroup($array_icon1, "icon1_group", $label['colTitle03'], "&nbsp;");
$file =& $o_form->addElement("file", "icon2", $label['colTitle04'], array("size"=>"50", "maxlength"=>"128",  "autocomplete"=>"off", "class"=>"fs12_black"));
$o_form->addElement("text",     "ribboncolor", $label['colTitle04'], array("size"=>"8", "maxlength"=>"6",  "autocomplete"=>"off", "class"=>"fs12_black"));
$array_publicmemotype[] =& HTML_QuickForm::createElement("radio", "publicmemotype", null, $label['publicType0'], KAKIKOMAP_PUBLICMEMOTYPE_GUEST);
$array_publicmemotype[] =& HTML_QuickForm::createElement("radio", "publicmemotype", null, $label['publicType1'], KAKIKOMAP_PUBLICMEMOTYPE_NORMAL);
$array_publicmemotype[] =& HTML_QuickForm::createElement("radio", "publicmemotype", null, $label['publicType9'], KAKIKOMAP_PUBLICMEMOTYPE_CLOSED);
$o_form->addGroup($array_publicmemotype, "publicmemotype_group", $label['colTitle05'], "&nbsp;");
$array_authoritymemotype[] =& HTML_QuickForm::createElement("radio", "authoritymemotype", null, $label['authType0'], KAKIKOMAP_AUTHORITYMEMOTYPE_GUEST);
$array_authoritymemotype[] =& HTML_QuickForm::createElement("radio", "authoritymemotype", null, $label['authType1'], KAKIKOMAP_AUTHORITYMEMOTYPE_NORMAL);
$array_authoritymemotype[] =& HTML_QuickForm::createElement("radio", "authoritymemotype", null, $label['authType9'], KAKIKOMAP_AUTHORITYMEMOTYPE_NON);
$o_form->addGroup($array_authoritymemotype, "authoritymemotype_group", $label['colTitle06'], "&nbsp;");
$array_listtype[] =& HTML_QuickForm::createElement("radio", "listtype", null, $label['listType0'], KAKIKOMAP_LISTTYPE_RIBBON);
$array_listtype[] =& HTML_QuickForm::createElement("radio", "listtype", null, $label['listType1'], KAKIKOMAP_LISTTYPE_PIN);
$array_listtype[] =& HTML_QuickForm::createElement("radio", "listtype", null, $label['listType9'], KAKIKOMAP_LISTTYPE_SECRET);
$o_form->addGroup($array_listtype, "listtype_group", $label['colTitle07'], "&nbsp;");
$array_effectiveterm[] =& HTML_QuickForm::createElement("radio", "effectiveterm", null, $label['term0'], 0);
$array_effectiveterm[] =& HTML_QuickForm::createElement("radio", "effectiveterm", null, $label['term1'], 1);
$o_form->addGroup($array_effectiveterm, "effectiveterm_group", $label['colTitle08'], "&nbsp;");
$effectiveterm_date_option = array("size"=>"12", "maxlength"=>"10",  "autocomplete"=>"off", "class"=>"fs12_black", "language"=>"ja", "minYear"=>date("Y"), "maxYear"=>date("Y") + VALIDITY_ADD_YEAR, "format"=>"Y".$o_resource->getValue("G04030L032")."m".$o_resource->getValue("G04030L033")."d".$o_resource->getValue("G04030L034"));
$o_form->addElement("date",     "effectiveterm_date", $label['colTitle08'], $effectiveterm_date_option);

// 独自チェックルールの定義
$o_form->registerRule('maxlength_valid', 'callback', 'check_maxlength_valid');

// チェック項目
$o_form->addRule("memotypename",	$o_resource->getValue("G04030M001"),	"required");
//$o_form->addRule("memotypename",	$o_resource->getValue("G04030M002"),	"maxlength_valid",	128);
if ($_POST['icontype'] == KAKIKOMAP_ICONTYPE_USER) {
    $o_form->addRule("icon2",		$o_resource->getValue("G04030M003"),	"uploadedfile");
    $o_form->addRule("icon2",		$o_resource->getValue("G04030M004"),	"maxfilesize",		return_bytes("200K"));
    $mimetype_array = split(",", UPLOAD_MIME_TYPE);
    $o_form->addRule("icon2",		$o_resource->getValue("G04030M005"),	"mimetype",			$mimetype_array);
//    $o_form->addRule("icon2",		$o_resource->getValue("G04030M005"),	"mimetype",			array("image/gif", "image/pjpeg", "image/png"));
    $o_form->addRule("ribboncolor",	$o_resource->getValue("G04030M006"),	"required");
    $o_form->addRule("ribboncolor",	$o_resource->getValue("G04030M007"),	"regex",			"/^[0-9a-fA-F]{6}?$/");
}
if ($_POST['effectiveterm_group']['effectiveterm'] == "1") {
    $o_form->addRule("effectiveterm_date",	$o_resource->getValue("G04030M008"),	"required");
    $o_form->registerRule("date_valid", "callback", "check_date_valid");
    $o_form->addRule("effectiveterm_date",	$o_resource->getValue("G04030M009"),	"date_valid");
}

// ユーザアイコンの場合、メモ種類IDをファイル名
if ($_POST['icontype'] == KAKIKOMAP_ICONTYPE_USER) {

	$tmp  = pathinfo($file->_value['name']);
	$ext  = $tmp["extension"];

    // ファイル名を作成
    do {
        $filename = ($ext == "") ? "" : (string)date("s").(string)(microtime()*1000000).".".$ext;
        if ($filename == "") {
            $loop = FALSE;
        } else {
            $loop = file_exists($filename);
        }
    } while($loop == TRUE);
    $_POST['filename'] = $filename;
}

$errorMessage = "";
$pageFlg = 0;

// 登録ボタン
if (isset($_POST[run])) {
    // 妥当性チェック
    if ($o_form->validate()) {
        // アップロード
        if ($_POST['icontype'] == KAKIKOMAP_ICONTYPE_USER) {
            $o_form->process("process", TRUE);
        }
        $_POST['icon2'] = $filename;
        $rtn = insertRecode($o_service);
        if ($rtn == 1) {
            $pageFlg = 1;
        } else if ($rtn == 0) {
			$errorMessage = $o_resource->getValue("G04030M010");
		}
    }
}

// ボタンを表示
if ($pageFlg == 0) {
    // 登録画面
    $o_form->addElement("header",   "header",    $label['topTitle']);
    $o_form->addElement("submit",   "run",       $label['addBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("reset",    "reset",     $label['rstBtn'],      array("class"=>"fs12_black"));
    $o_form->addElement("button",   "close",     $label['clsBtn'],      array("onclick"=>"close_window();", "class"=>"fs12_black"));
    $tplName = DIRECTORY_NAME."/memotyperegist.tpl";
} else {
    // 完了画面
    $tplName = "windowclose.tpl";
}

// smarty インスタンス化
$o_smarty = new KakikoSmarty();
$o_renderer =& new HTML_QuickForm_Renderer_ArraySmarty($o_smarty);
$o_form->accept($o_renderer);
$o_smarty->assign("form",         $o_renderer->toArray());
$o_smarty->assign("icontype",     $icontype);
$o_smarty->assign("infoLabel1",   $label['subLabel1']);
$o_smarty->assign("infoLabel2",   $label['subLabel2']);
$o_smarty->assign("infoLabel3",   $label['subLabel3']);
$o_smarty->assign("infoLabel4",   $label['subLabel4']);
$o_smarty->assign("infoLabel5",   $label['subLabel5']);
$o_smarty->assign("errorMessage", $errorMessage);

$o_smarty->display($tplName);


//#################################################################################################
//                                        以下、関数定義
//#################################################################################################
/**
* 関数概要：メモ種類登録処理
* 処理詳細：メモ種類を新規に登録する
*
* @引数： (I) o_service     - object DBサービスクラス
* @戻値： integer  1:正常登録
*      ：          0:チェックエラー
*      ：         -1:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function insertRecode($o_service) {

	// SESSION内容格納
	$session_layerid   = isset($_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid']) 
									? $_SESSION[DIRECTORY_NAME.'_mntlayer']['layerid'] 
										:$_SESSION[DIRECTORY_NAME.'_newlayer']['layerid'];

    global $systemicon_array;

    // アイコンの値
    if ($_POST['icontype'] == KAKIKOMAP_ICONTYPE_SYSTEM) {
        $icon        = $systemicon_array[$_POST['icon1_group']['icon1']]['file'];
        $ribboncolor = $systemicon_array[$_POST['icon1_group']['icon1']]['color'];
    } else {
        $icon = $_POST['icon2'];
        $ribboncolor = $_POST['ribboncolor'];
    }
    // 有効期限の値
    if ($_POST['effectiveterm_group']['effectiveterm'] == 1) {
        // 期限ありの場合
        $eff_date = $_POST['effectiveterm_date']['Y']."-".
                    $_POST['effectiveterm_date']['m']."-".
                    $_POST['effectiveterm_date']['d'];
    } else {
        // 期限なしの場合
        $eff_date = "9999-12-31";
    }

	// メモ種類データ作成
	$memotypedata = new MemoTypeData();

	$memotypedata->setLayerID($session_layerid);
	$memotypedata->setMemoTypeName($_POST['memotypename']);
	$memotypedata->setPublicMemoType($_POST['publicmemotype_group']['publicmemotype']);
	$memotypedata->setAuthorityMemoType($_POST['authoritymemotype_group']['authoritymemotype']);
	$memotypedata->setIconType($_POST['icontype']);
	$memotypedata->setIcon($icon);
	$memotypedata->setRibbonColor($ribboncolor);
	$memotypedata->setListType($_POST['listtype_group']['listtype']);
	$memotypedata->setEffectiveTerm($eff_date);
	$memotypedata->setDeleteFlg(KAKIKOMAP_DELETEFLG_OFF);
	$memotypedata->setAddDateTime(date('Y/m/d H:i:s'));
	$memotypedata->setUpdateDateTime(date('Y/m/d H:i:s'));

	// メモ種類登録処理
	$rtn = $o_service->insertMemoType($memotypedata);

    return $rtn;
}

/**
* 関数概要：ファイルアップロード
* 処理詳細：ファイルのアップロードを行う
*
* @引数： (I) $values - array 入力された連想配列
* @戻値： boolean TRUE :正常
*      ：         FALSE:異常
* @作成日/作成者：2006/09/01 (IIS)H.Keta
* @更新日/更新者：
* @更新内容：
*/
function process($values){
    global $file;
    if ($file->isUploadedFile()) {
        $file->moveUploadedFile("../img/icon", $_POST['filename']);
        return TRUE;
    }
    else {
        return FALSE;
    }
}

?>
